/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRValidationFault;

public class JRValidationException
extends JRException {
    private static final long serialVersionUID = 10200L;
    private final Collection faults;

    public JRValidationException(String message, Object source) {
        this(JRValidationException.createFault(message, source));
    }

    private static JRValidationFault createFault(String message, Object source) {
        JRValidationFault fault = new JRValidationFault();
        fault.setMessage(message);
        fault.setSource(source);
        return fault;
    }

    public JRValidationException(JRValidationFault fault) {
        this(Arrays.asList(fault));
    }

    public JRValidationException(Collection faults) {
        this(null, faults);
    }

    public JRValidationException(String message, Collection faults) {
        super(JRValidationException.appendMessages(message, faults));
        this.faults = faults;
    }

    public Collection getFaults() {
        return this.faults;
    }

    protected static String appendMessages(String header, Collection faults) {
        if (header == null) {
            header = "Report design not valid : ";
        }
        StringBuffer sbuffer = new StringBuffer();
        sbuffer.append(header);
        int i = 1;
        Iterator it = faults.iterator();
        while (it.hasNext()) {
            JRValidationFault fault = (JRValidationFault)it.next();
            sbuffer.append("\n\t " + i + ". " + fault.getMessage());
            ++i;
        }
        return sbuffer.toString();
    }
}

