/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.renderers;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.List;
import net.sf.jasperreports.engine.JRAbstractSvgRenderer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRImageMapRenderer;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.FileResolver;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public class BatikRenderer
extends JRAbstractSvgRenderer
implements JRImageMapRenderer {
    private static final long serialVersionUID = 10200L;
    private String svgText;
    private byte[] svgData;
    private String svgDataLocation;
    private List areaHyperlinks;
    private GraphicsNode rootNode;
    private Dimension2D documentSize;

    protected BatikRenderer(List areaHyperlinks) {
        this.areaHyperlinks = areaHyperlinks;
    }

    public BatikRenderer(String svgText, List areaHyperlinks) {
        this.svgText = svgText;
        this.areaHyperlinks = areaHyperlinks;
    }

    public BatikRenderer(byte[] svgData, List areaHyperlinks) {
        this.svgData = svgData;
        this.areaHyperlinks = areaHyperlinks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Graphics2D grx, Rectangle2D rectangle) throws JRException {
        this.ensureSvg();
        AffineTransform transform = ViewBox.getPreserveAspectRatioTransform((float[])new float[]{0.0f, 0.0f, (float)this.documentSize.getWidth(), (float)this.documentSize.getHeight()}, (short)1, (boolean)true, (float)((float)rectangle.getWidth()), (float)((float)rectangle.getHeight()));
        Graphics2D graphics = (Graphics2D)grx.create();
        graphics.translate(rectangle.getX(), rectangle.getY());
        graphics.transform(transform);
        GraphicsNode graphicsNode = this.rootNode;
        synchronized (graphicsNode) {
            this.rootNode.paint(graphics);
        }
    }

    public Dimension2D getDimension() {
        try {
            this.ensureSvg();
            return this.documentSize;
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected synchronized void ensureData() throws JRException {
        if (this.svgText == null && this.svgData == null && this.svgDataLocation != null) {
            this.svgData = JRLoader.loadBytesFromLocation(this.svgDataLocation);
        }
    }

    protected synchronized void ensureSvg() throws JRException {
        if (this.rootNode != null) {
            return;
        }
        this.ensureData();
        try {
            JRUserAgent userAgent = new JRUserAgent();
            SAXSVGDocumentFactory documentFactory = new SAXSVGDocumentFactory(userAgent.getXMLParserClassName(), true);
            documentFactory.setValidating(userAgent.isXMLParserValidating());
            SVGDocument document = this.svgText != null ? documentFactory.createSVGDocument("", (Reader)new StringReader(this.svgText)) : documentFactory.createSVGDocument("", (InputStream)new ByteArrayInputStream(this.svgData));
            BridgeContext ctx = new BridgeContext((UserAgent)userAgent);
            ctx.setDynamic(true);
            GVTBuilder builder = new GVTBuilder();
            this.rootNode = builder.build(ctx, (Document)document);
            this.documentSize = ctx.getDocumentSize();
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    public List renderWithHyperlinks(Graphics2D grx, Rectangle2D rectangle) throws JRException {
        this.render(grx, rectangle);
        return this.areaHyperlinks;
    }

    public List getImageAreaHyperlinks(Rectangle2D renderingArea) throws JRException {
        return this.areaHyperlinks;
    }

    public boolean hasImageAreaHyperlinks() {
        return this.areaHyperlinks != null && !this.areaHyperlinks.isEmpty();
    }

    protected Graphics2D createGraphics(BufferedImage bi) {
        return GraphicsUtil.createGraphics((BufferedImage)bi);
    }

    protected void setSvgDataLocation(String svgDataLocation) {
        this.svgDataLocation = svgDataLocation;
    }

    public static BatikRenderer getInstance(byte[] svgData) {
        return new BatikRenderer(svgData, null);
    }

    public static BatikRenderer getInstance(InputStream svgDataStream) throws JRException {
        byte[] data = JRLoader.loadBytes(svgDataStream);
        return new BatikRenderer(data, null);
    }

    public static BatikRenderer getInstance(File svgFile) throws JRException {
        byte[] data = JRLoader.loadBytes(svgFile);
        return new BatikRenderer(data, null);
    }

    public static BatikRenderer getInstance(URL svgURL) throws JRException {
        byte[] data = JRLoader.loadBytes(svgURL);
        return new BatikRenderer(data, null);
    }

    public static BatikRenderer getInstanceFromText(String svgText) throws JRException {
        return new BatikRenderer(svgText, null);
    }

    public static BatikRenderer getInstanceFromLocation(String location) throws JRException {
        byte[] data = JRLoader.loadBytesFromLocation(location);
        return new BatikRenderer(data, null);
    }

    public static BatikRenderer getInstanceFromLocation(String location, ClassLoader classLoader, URLStreamHandlerFactory urlHandlerFactory, FileResolver fileResolver) throws JRException {
        byte[] data = JRLoader.loadBytesFromLocation(location, classLoader, urlHandlerFactory, fileResolver);
        return new BatikRenderer(data, null);
    }

    public static BatikRenderer getLocationInstance(String location) throws JRException {
        BatikRenderer renderer = new BatikRenderer(null);
        renderer.setSvgDataLocation(location);
        return renderer;
    }

    protected static class JRUserAgent
    extends UserAgentAdapter {
        protected JRUserAgent() {
        }

        public float getPixelUnitToMillimeter() {
            return 0.35277778f;
        }
    }
}

