/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.resources;

import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.jasperserver.JServer;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.RepositoryFolder;
import com.jaspersoft.ireport.jasperserver.ui.ValidationUtils;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DataTypeDialog
extends JDialog {
    private int dialogResult = 2;
    private JServer server = null;
    private String parentFolder = null;
    private RepositoryFolder resource = null;
    private ResourceDescriptor newResourceDescriptor = null;
    private boolean doNotStore = false;
    private ButtonGroup buttonGroup1;
    private JButton jButtonClose;
    private JButton jButtonSave;
    private JCheckBox jCheckBoxMaxValue;
    private JCheckBox jCheckBoxMinValue;
    private JComboBox jComboBoxType;
    private JEditorPane jEditorPaneDescription;
    private JLabel jLabel1;
    private JLabel jLabelDescription;
    private JLabel jLabelLabel;
    private JLabel jLabelMaxVal;
    private JLabel jLabelMinValue;
    private JLabel jLabelName;
    private JLabel jLabelPattern;
    private JLabel jLabelStrictMaxVal;
    private JLabel jLabelStrictMinVal;
    private JLabel jLabelType;
    private JLabel jLabelUriString;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextFieldLabel;
    private JTextField jTextFieldMaxValue;
    private JTextField jTextFieldMinValue;
    private JTextField jTextFieldName;
    private JTextField jTextFieldPattern;
    private JTextField jTextFieldUriString;

    public DataTypeDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(null);
        DocumentListener changesListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                DataTypeDialog.this.updateSaveButton();
            }

            public void insertUpdate(DocumentEvent evt) {
                DataTypeDialog.this.updateSaveButton();
            }

            public void removeUpdate(DocumentEvent evt) {
                DataTypeDialog.this.updateSaveButton();
            }
        };
        this.jComboBoxType.addItem(new Tag((Object)"1", JasperServerManager.getString("dataTypeDialog.type.1", "Text")));
        this.jComboBoxType.addItem(new Tag((Object)"2", JasperServerManager.getString("dataTypeDialog.type.2", "Number")));
        this.jComboBoxType.addItem(new Tag((Object)"3", JasperServerManager.getString("dataTypeDialog.type.3", "Date")));
        this.jComboBoxType.addItem(new Tag((Object)"4", JasperServerManager.getString("dataTypeDialog.type.4", "Date/time")));
        this.jComboBoxType.setSelectedIndex(0);
        this.applyI18n();
        this.jTextFieldLabel.getDocument().addDocumentListener(changesListener);
        this.jTextFieldName.getDocument().addDocumentListener(changesListener);
        this.jTextFieldName.requestFocusInWindow();
    }

    public void applyI18n() {
        this.jButtonClose.setText(JasperServerManager.getString("dataTypeDialog.buttonCancel", "Cancel"));
        this.jButtonSave.setText(JasperServerManager.getString("dataTypeDialog.buttonSave", "Save"));
        this.jLabel1.setText(JasperServerManager.getString("dataTypeDialog.title", "Data Type"));
        this.jLabelDescription.setText(JasperServerManager.getString("dataTypeDialog.labelDescription", "Description"));
        this.jLabelLabel.setText(JasperServerManager.getString("dataTypeDialog.labelLabel", "Label"));
        this.jLabelMaxVal.setText(JasperServerManager.getString("dataTypeDialog.labelMaxVal", "Maximum value"));
        this.jLabelMinValue.setText(JasperServerManager.getString("dataTypeDialog.labelMinValue", "Minimum value"));
        this.jLabelName.setText(JasperServerManager.getString("dataTypeDialog.labelName", "Name"));
        this.jLabelUriString.setText(JasperServerManager.getString("dataTypeDialog.labelParentFolder", "Parent folder"));
        this.jLabelPattern.setText(JasperServerManager.getString("dataTypeDialog.labelPattern", "Pattern"));
        this.jLabelStrictMaxVal.setText(JasperServerManager.getString("dataTypeDialog.labelStrictMaxValue", "Is strict maximum"));
        this.jLabelStrictMinVal.setText(JasperServerManager.getString("dataTypeDialog.labelStrictMinValue", "Is strict minimum"));
        this.jLabelType.setText(JasperServerManager.getString("dataTypeDialog.labelType", "Type"));
        this.jTabbedPane1.setTitleAt(0, JasperServerManager.getString("dataTypeDialog.tabGeneral", "General"));
        this.jTabbedPane1.setTitleAt(1, JasperServerManager.getString("dataTypeDialog.tabDetails", "Date Type details"));
    }

    private void updateSaveButton() {
        if (this.jTextFieldLabel.getText().length() > 0 && this.jTextFieldName.getText().length() > 0) {
            this.jButtonSave.setEnabled(true);
        } else {
            this.jButtonSave.setEnabled(false);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jLabelUriString = new JLabel();
        this.jTextFieldUriString = new JTextField();
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.jLabelLabel = new JLabel();
        this.jTextFieldLabel = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPaneDescription = new JEditorPane();
        this.jLabelDescription = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabelType = new JLabel();
        this.jComboBoxType = new JComboBox();
        this.jLabelPattern = new JLabel();
        this.jTextFieldPattern = new JTextField();
        this.jLabelMinValue = new JLabel();
        this.jCheckBoxMinValue = new JCheckBox();
        this.jTextFieldMaxValue = new JTextField();
        this.jLabelMaxVal = new JLabel();
        this.jPanel5 = new JPanel();
        this.jCheckBoxMaxValue = new JCheckBox();
        this.jLabelStrictMinVal = new JLabel();
        this.jLabelStrictMaxVal = new JLabel();
        this.jTextFieldMinValue = new JTextField();
        this.jPanel4 = new JPanel();
        this.jButtonSave = new JButton();
        this.jButtonClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Data Type");
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setFont(new Font("Dialog", 1, 12));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/jasperserver/res/datasource_new.png")));
        this.jLabel1.setText("Data Type");
        this.jLabel1.setVerticalAlignment(3);
        this.jLabel1.setVerticalTextPosition(3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(2, 2));
        this.jSeparator1.setPreferredSize(new Dimension(2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel2.setPreferredSize(new Dimension(400, 185));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabelUriString.setText("Parent folder");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabelUriString, gridBagConstraints);
        this.jTextFieldUriString.setEditable(false);
        this.jTextFieldUriString.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTextFieldUriString.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jTextFieldUriString, gridBagConstraints);
        this.jLabelName.setText("Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabelName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jSeparator2.setMinimumSize(new Dimension(0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 6, 4);
        this.jPanel2.add((Component)this.jSeparator2, gridBagConstraints);
        this.jLabelLabel.setText("Label");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabelLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jTextFieldLabel, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jEditorPaneDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabelDescription.setText("Description");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel2.add((Component)this.jLabelDescription, gridBagConstraints);
        this.jTabbedPane1.addTab("General", this.jPanel2);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabelType.setHorizontalAlignment(4);
        this.jLabelType.setText("Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 20, 4, 0);
        this.jPanel3.add((Component)this.jLabelType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 4, 4, 20);
        this.jPanel3.add((Component)this.jComboBoxType, gridBagConstraints);
        this.jLabelPattern.setHorizontalAlignment(4);
        this.jLabelPattern.setText("Pattern");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 16, 0);
        this.jPanel3.add((Component)this.jLabelPattern, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.insets = new Insets(0, 4, 16, 20);
        this.jPanel3.add((Component)this.jTextFieldPattern, gridBagConstraints);
        this.jLabelMinValue.setHorizontalAlignment(4);
        this.jLabelMinValue.setText("Minimum value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 4, 0);
        this.jPanel3.add((Component)this.jLabelMinValue, gridBagConstraints);
        this.jCheckBoxMinValue.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 16, 20);
        this.jPanel3.add((Component)this.jCheckBoxMinValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.insets = new Insets(0, 4, 4, 20);
        this.jPanel3.add((Component)this.jTextFieldMaxValue, gridBagConstraints);
        this.jLabelMaxVal.setHorizontalAlignment(4);
        this.jLabelMaxVal.setText("Maximum value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 4, 0);
        this.jPanel3.add((Component)this.jLabelMaxVal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 99;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jPanel5, gridBagConstraints);
        this.jCheckBoxMaxValue.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 8, 20);
        this.jPanel3.add((Component)this.jCheckBoxMaxValue, gridBagConstraints);
        this.jLabelStrictMinVal.setHorizontalAlignment(4);
        this.jLabelStrictMinVal.setText("Is strict minimum");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 16, 0);
        this.jPanel3.add((Component)this.jLabelStrictMinVal, gridBagConstraints);
        this.jLabelStrictMaxVal.setHorizontalAlignment(4);
        this.jLabelStrictMaxVal.setText("Is strict maximum");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 8, 0);
        this.jPanel3.add((Component)this.jLabelStrictMaxVal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.insets = new Insets(0, 4, 4, 20);
        this.jPanel3.add((Component)this.jTextFieldMinValue, gridBagConstraints);
        this.jTabbedPane1.addTab("Data Type details", this.jPanel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jTabbedPane1, gridBagConstraints);
        this.jPanel4.setMinimumSize(new Dimension(10, 30));
        this.jPanel4.setPreferredSize(new Dimension(10, 30));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jButtonSave.setText("Save");
        this.jButtonSave.setEnabled(false);
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataTypeDialog.this.jButtonSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel4.add((Component)this.jButtonSave, gridBagConstraints);
        this.jButtonClose.setText("Cancel");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataTypeDialog.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.jButtonClose, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        ResourceDescriptor rd = new ResourceDescriptor();
        rd.setDescription(this.jEditorPaneDescription.getText().trim());
        rd.setName(this.jTextFieldName.getText());
        String uri = this.getParentFolder();
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        uri = uri + this.jTextFieldName.getText();
        rd.setUriString(uri);
        rd.setLabel(this.jTextFieldLabel.getText().trim());
        rd.setParentFolder(this.getParentFolder());
        rd.setIsNew(this.resource == null);
        rd.setWsType("dataType");
        rd.setDataType(Byte.parseByte(((Tag)this.jComboBoxType.getSelectedItem()).getValue() + ""));
        rd.setPattern(this.jTextFieldPattern.getText());
        rd.setMaxValue(this.jTextFieldMaxValue.getText());
        rd.setMinValue(this.jTextFieldMinValue.getText());
        rd.setStrictMax(this.jCheckBoxMaxValue.isSelected());
        rd.setStrictMin(this.jCheckBoxMinValue.isSelected());
        try {
            this.validate(rd);
            this.newResourceDescriptor = !this.doNotStore ? this.getServer().getWSClient().addOrModifyResource(rd, null) : rd;
            this.setDialogResult(0);
            if (this.resource != null) {
                this.resource.setDescriptor(this.newResourceDescriptor);
            }
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, JasperServerManager.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}));
            ex.printStackTrace();
            return;
        }
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public JServer getServer() {
        return this.server;
    }

    public void setServer(JServer server) {
        this.server = server;
    }

    public String getParentFolder() {
        return this.parentFolder;
    }

    public void setParentFolder(String parentFolder) {
        this.parentFolder = parentFolder;
        this.jTextFieldUriString.setText(parentFolder);
    }

    public ResourceDescriptor getNewResourceDescriptor() {
        return this.newResourceDescriptor;
    }

    public void setResource(RepositoryFolder resource) {
        this.resource = resource;
        if (resource != null) {
            this.setResource(resource.getDescriptor());
            this.jTextFieldName.setEditable(false);
            this.jTextFieldName.setOpaque(false);
        }
    }

    public void setResource(ResourceDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        this.jTextFieldName.setText(descriptor.getName());
        this.setTitle(JasperServerManager.getFormattedString("properties.title", "{0} - Properties", new Object[]{descriptor.getName()}));
        this.jTextFieldLabel.setText(descriptor.getLabel());
        this.jEditorPaneDescription.setText(descriptor.getDescription());
        if (descriptor.getWsType().equals("dataType")) {
            this.jCheckBoxMaxValue.setSelected(descriptor.isStrictMax());
            this.jCheckBoxMinValue.setSelected(descriptor.isStrictMin());
            this.jTextFieldMaxValue.setText(descriptor.getMaxValue() == null ? "" : descriptor.getMaxValue());
            this.jTextFieldMinValue.setText(descriptor.getMinValue() == null ? "" : descriptor.getMinValue());
            Misc.setComboboxSelectedTagValue((JComboBox)this.jComboBoxType, (Object)("" + descriptor.getDataType()));
            this.jTextFieldPattern.setText(descriptor.getPattern());
        }
    }

    public void validate(ResourceDescriptor dataType) throws Exception {
        String strMinValue = this.jTextFieldMinValue.getText();
        String strMaxValue = this.jTextFieldMaxValue.getText();
        ValidationUtils.validateName(dataType.getName());
        ValidationUtils.validateLabel(dataType.getLabel());
        ValidationUtils.validateDesc(dataType.getDescription());
        if (strMinValue != null && strMinValue.length() == 0) {
            dataType.setMinValue(null);
        }
        if (strMaxValue != null && strMaxValue.length() == 0) {
            dataType.setMaxValue(null);
        }
        if (dataType.getDataType() == 2) {
            BigDecimal maxValue;
            BigDecimal minValue;
            block12: {
                block11: {
                    minValue = null;
                    maxValue = null;
                    try {
                        minValue = new BigDecimal(strMinValue);
                    }
                    catch (NumberFormatException e) {
                        if (strMinValue.length() <= 0) break block11;
                        throw new Exception(JasperServerManager.getString("dataTypeDialog.message.invalidNumber", "Invalid number"));
                    }
                }
                try {
                    maxValue = new BigDecimal(strMaxValue);
                }
                catch (NumberFormatException e) {
                    if (strMaxValue.length() <= 0) break block12;
                    throw new Exception(JasperServerManager.getString("dataTypeDialog.message.invalidNumber", "Invalid number"));
                }
            }
            if (minValue != null && maxValue != null && minValue.compareTo(maxValue) >= 0) {
                throw new Exception(JasperServerManager.getString("dataTypeDialog.message.invalidMinMax", "Minimum value must be smaller than maximum value"));
            }
        }
        if (dataType.getDataType() == 1 && dataType.getPattern() != null && dataType.getPattern().trim().length() > 0) {
            if (strMinValue != null && strMinValue.trim().length() > 0 && !Pattern.matches(dataType.getPattern(), strMinValue)) {
                throw new Exception(JasperServerManager.getString("dataTypeDialog.message.invalidMinPattern", "Minimum value does not match pattern"));
            }
            if (strMaxValue != null && strMaxValue.trim().length() > 0 && !Pattern.matches(dataType.getPattern(), strMaxValue)) {
                throw new Exception(JasperServerManager.getString("dataTypeDialog.message.invalidMaxPattern", "Maximum value does not match pattern"));
            }
        }
    }

    public boolean isDoNotStore() {
        return this.doNotStore;
    }

    public void setDoNotStore(boolean doNotStore) {
        this.doNotStore = doNotStore;
    }
}

