/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import mondrian.olap.Connection;
import mondrian.olap.DriverManager;
import mondrian.olap.Query;

public class QueryRunner
extends Thread {
    private long mRunTime;
    private long mStartTime;
    private long mStopTime;
    private List<Exception> mExceptions = new ArrayList<Exception>();
    private int mMyId;
    private int mRunCount;
    private int mSuccessCount;
    private boolean mRandomQueries;
    private static final char nl = '\r';
    static final String[] Queries = new String[]{"select {[Measures].[Unit Sales]} on columns\r from Sales", "select\r    {[Measures].[Unit Sales]} on columns,\r    order(except([Promotion Media].[Media Type].members,{[Promotion Media].[Media Type].[No Media]}),[Measures].[Unit Sales],DESC) on rows\rfrom Sales", "select\r    { [Measures].[Units Shipped], [Measures].[Units Ordered] } on columns,\r    NON EMPTY [Store].[Store Name].members on rows\rfrom Warehouse", "with member [Measures].[Store Sales Last Period] as '([Measures].[Store Sales], Time.PrevMember)'\rselect\r    {[Measures].[Store Sales Last Period]} on columns,\r    {TopCount([Product].[Product Department].members,5, [Measures].[Store Sales Last Period])} on rows\rfrom Sales\rwhere ([Time].[1998])", "with member [Measures].[Total Store Sales] as 'Sum(YTD(),[Measures].[Store Sales])'\rselect\r    {[Measures].[Total Store Sales]} on columns,\r    {TopCount([Product].[Product Department].members,5, [Measures].[Total Store Sales])} on rows\rfrom Sales\rwhere ([Time].[1997].[Q2].[4])", "with member [Measures].[Store Profit Rate] as '([Measures].[Store Sales]-[Measures].[Store Cost])/[Measures].[Store Cost]', format = '#.00%'\rselect\r    {[Measures].[Store Cost],[Measures].[Store Sales],[Measures].[Store Profit Rate]} on columns,\r    Order([Product].[Product Department].members, [Measures].[Store Profit Rate], BDESC) on rows\rfrom Sales\rwhere ([Time].[1997])", "with\r   member [Product].[All Products].[Drink].[Percent of Alcoholic Drinks] as '[Product].[All Products].[Drink].[Alcoholic Beverages]/[Product].[All Products].[Drink]', format = '#.00%'\rselect\r   { [Product].[All Products].[Drink].[Percent of Alcoholic Drinks] } on columns,\r   order([Customers].[All Customers].[USA].[WA].Children, [Product].[All Products].[Drink].[Percent of Alcoholic Drinks],BDESC) on rows\rfrom Sales\rwhere ([Measures].[Unit Sales])", "with member [Measures].[Accumulated Sales] as 'Sum(YTD(),[Measures].[Store Sales])'\rselect\r    {[Measures].[Store Sales],[Measures].[Accumulated Sales]} on columns,\r    {Descendants([Time].[1997],[Time].[Month])} on rows\rfrom Sales", "select\r {[Measures].[Unit Sales]} on columns,\r [Gender].members on rows\rfrom Sales", "select {[Has bought dairy].members} on columns,\r {[Customers].[USA]} on rows\rfrom Sales\rwhere ([Measures].[Unit Sales])", "WITH\r   MEMBER [Measures].[StoreType] AS \r   '[Store].CurrentMember.Properties(\"Store Type\")',\r   SOLVE_ORDER = 2\r   MEMBER [Measures].[ProfitPct] AS \r   '((Measures.[Store Sales] - Measures.[Store Cost]) / Measures.[Store Sales])',\r   SOLVE_ORDER = 1, FORMAT_STRING = 'Percent'\rSELECT\r   { [Store].[Store Name].Members} ON COLUMNS,\r   { [Measures].[Store Sales], [Measures].[Store Cost], [Measures].[StoreType],\r   [Measures].[ProfitPct] } ON ROWS\rFROM Sales", "WITH\r   MEMBER [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[BigSeller] AS\r  'IIf([Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine] > 100, \"Yes\",\"No\")'\rSELECT\r   {[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[BigSeller]} ON COLUMNS,\r   {Store.[Store Name].Members} ON ROWS\rFROM Sales", "WITH\r   MEMBER [Measures].[ProfitPct] AS \r   '((Measures.[Store Sales] - Measures.[Store Cost]) / Measures.[Store Sales])',\r   SOLVE_ORDER = 1, FORMAT_STRING = 'Percent'\r   MEMBER [Measures].[ProfitValue] AS \r   '[Measures].[Store Sales] * [Measures].[ProfitPct]',\r   SOLVE_ORDER = 2, FORMAT_STRING = 'Currency'\rSELECT\r   { [Store].[Store Name].Members} ON COLUMNS,\r   { [Measures].[Store Sales], [Measures].[Store Cost], [Measures].[ProfitValue],\r   [Measures].[ProfitPct] } ON ROWS\rFROM Sales", "WITH\r   MEMBER [Product].[X] AS '[Product].[Y]'\r   MEMBER [Product].[Y] AS '[Product].[X]'\rSELECT\r   {[Product].[X]} ON COLUMNS,\r   {Store.[Store Name].Members} ON ROWS\rFROM Sales", "WITH MEMBER MEASURES.ProfitPercent AS\r     '([Measures].[Store Sales]-[Measures].[Store Cost])/([Measures].[Store Cost])',\r FORMAT_STRING = '#.00%', SOLVE_ORDER = 1\r MEMBER [Time].[First Half 97] AS  '[Time].[1997].[Q1] + [Time].[1997].[Q2]'\r MEMBER [Time].[Second Half 97] AS '[Time].[1997].[Q3] + [Time].[1997].[Q4]'\r SELECT {[Time].[First Half 97],\r     [Time].[Second Half 97],\r     [Time].[1997].CHILDREN} ON COLUMNS,\r {[Store].[Store Country].[USA].CHILDREN} ON ROWS\r FROM [Sales]\r WHERE ([Measures].[ProfitPercent])", "with member [Measures].[Accumulated Sales] as 'Sum(YTD(),[Measures].[Store Sales])'\rselect\r    {[Measures].[Store Sales],[Measures].[Accumulated Sales]} on columns,\r    {Descendants([Time].[1997],[Time].[Month])} on rows\rfrom [Warehouse and Sales]", "select CrossJoin(\r\n  {[Warehouse].DefaultMember, [Warehouse].[USA].children},\r  {[Measures].[Unit Sales], [Measures].[Units Shipped]}) on columns,\r [Time].children on rows\rfrom [Warehouse and Sales]", "select {[Measures].[Unit Sales]} on columns,\r {[Store], [Store].children} on rows\rfrom [Sales]", "select {[Measures].[Unit Sales]} on columns,\r {[Customers].members} on rows\rfrom [Sales]", "select\r  CrossJoin(\r    {[Measures].[Unit Sales], [Measures].[Store Sales]},\r    {[Time].[1997].[Q2].children}) on columns, \r  CrossJoin(\r    CrossJoin(\r      [Gender].members,\r      [Marital Status].members),\r   {[Store], [Store].children}) on rows\rfrom [Sales]\rwhere (\r [Product].[Food],\r [Education Level].[High School Degree],\r [Promotions].DefaultMember)"};

    public QueryRunner(int id, int numSeconds, boolean useRandomQuery) {
        this.mRunTime = (long)numSeconds * 1000L;
        this.mMyId = id;
        this.mRandomQueries = useRandomQuery;
    }

    public void run() {
        this.mStartTime = System.currentTimeMillis();
        try {
            Connection cxn = DriverManager.getConnection("Provider=mondrian;Jdbc=jdbc:JSQLConnect://engdb04:1433/database=MondrianFoodmart/user=mondrian/password=password;Catalog=file:demo\\FoodMart.xml;JdbcDrivers=com.jnetdirect.jsql.JSQLDriver;", null);
            int queryIndex = -1;
            while (System.currentTimeMillis() - this.mStartTime < this.mRunTime) {
                try {
                    queryIndex = this.mRandomQueries ? (int)(Math.random() * (double)Queries.length) : this.mRunCount % Queries.length;
                    ++this.mRunCount;
                    Query query = cxn.parseQuery(Queries[queryIndex]);
                    cxn.execute(query);
                    ++this.mSuccessCount;
                }
                catch (Exception e) {
                    this.mExceptions.add(new Exception("Exception occurred on iteration " + queryIndex, e));
                }
            }
            this.mStopTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            this.mExceptions.add(e);
        }
    }

    public void report(PrintStream out) {
        String message = MessageFormat.format("Thread {0} ran {1} queries, {2} successfully in {3} milliseconds", this.mMyId, this.mRunCount, this.mSuccessCount, this.mStopTime - this.mStartTime);
        out.println(message);
        for (Exception throwable : this.mExceptions) {
            throwable.printStackTrace(out);
        }
    }

    private static void runTest(int numThreads, int seconds, boolean randomQueries) {
        int idx;
        QueryRunner[] runners = new QueryRunner[numThreads];
        for (idx = 0; idx < runners.length; ++idx) {
            runners[idx] = new QueryRunner(idx, seconds, randomQueries);
        }
        for (idx = 0; idx < runners.length; ++idx) {
            runners[idx].start();
        }
        for (idx = 0; idx < runners.length; ++idx) {
            try {
                runners[idx].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (idx = 0; idx < runners.length; ++idx) {
            runners[idx].report(System.out);
        }
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.err.println("usage: QueryRunner numThreads seconds randomQueries");
            return;
        }
        QueryRunner.runTest(Integer.parseInt(args[0]), Integer.parseInt(args[1]), Boolean.valueOf(args[2]));
    }
}

