/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.olap.Id;
import mondrian.olap.OlapElement;
import mondrian.olap.Util;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberCacheHelper;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlConstraintFactory;
import mondrian.rolap.TupleReader;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;
import mondrian.util.ConcatenableList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartMemberReader
implements MemberReader {
    private final SqlConstraintFactory sqlConstraintFactory = SqlConstraintFactory.instance();
    protected final MemberReader source;
    protected final MemberCacheHelper cacheHelper;
    protected List<RolapMember> rootMembers;

    SmartMemberReader(MemberReader source) {
        this.source = source;
        this.cacheHelper = new MemberCacheHelper(source.getHierarchy());
        if (!source.setCache(this.cacheHelper)) {
            throw Util.newInternal("MemberSource (" + source + ", " + source.getClass() + ") does not support cache-writeback");
        }
    }

    @Override
    public RolapHierarchy getHierarchy() {
        return this.source.getHierarchy();
    }

    public MemberCache getMemberCache() {
        return this.cacheHelper;
    }

    @Override
    public boolean setCache(MemberCache cache) {
        return false;
    }

    @Override
    public RolapMember substitute(RolapMember member) {
        return member;
    }

    @Override
    public RolapMember desubstitute(RolapMember member) {
        return member;
    }

    @Override
    public List<RolapMember> getMembers() {
        RolapLevel[] levels;
        ConcatenableList<RolapMember> v = new ConcatenableList<RolapMember>();
        for (RolapLevel level : levels = (RolapLevel[])this.getHierarchy().getLevels()) {
            List<RolapMember> membersInLevel = this.getMembersInLevel(level, 0, Integer.MAX_VALUE);
            v.addAll(membersInLevel);
        }
        return v;
    }

    @Override
    public List<RolapMember> getRootMembers() {
        if (this.rootMembers == null) {
            this.rootMembers = this.source.getRootMembers();
        }
        return this.rootMembers;
    }

    @Override
    public List<RolapMember> getMembersInLevel(RolapLevel level, int startOrdinal, int endOrdinal) {
        TupleConstraint constraint = this.sqlConstraintFactory.getLevelMembersConstraint(null);
        return this.getMembersInLevel(level, startOrdinal, endOrdinal, constraint);
    }

    protected void checkCacheStatus() {
        this.cacheHelper.checkCacheStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RolapMember> getMembersInLevel(RolapLevel level, int startOrdinal, int endOrdinal, TupleConstraint constraint) {
        MemberCacheHelper memberCacheHelper = this.cacheHelper;
        synchronized (memberCacheHelper) {
            this.checkCacheStatus();
            List<RolapMember> members = this.cacheHelper.getLevelMembersFromCache(level, constraint);
            if (members != null) {
                return members;
            }
            members = this.source.getMembersInLevel(level, startOrdinal, endOrdinal, constraint);
            this.cacheHelper.putLevelMembersInCache(level, constraint, members);
            return members;
        }
    }

    @Override
    public int getLevelMemberCount(RolapLevel level) {
        return this.source.getLevelMemberCount(level);
    }

    @Override
    public void getMemberChildren(RolapMember parentMember, List<RolapMember> children) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        this.getMemberChildren(parentMember, children, constraint);
    }

    @Override
    public void getMemberChildren(RolapMember parentMember, List<RolapMember> children, MemberChildrenConstraint constraint) {
        List<RolapMember> parentMembers = Collections.singletonList(parentMember);
        this.getMemberChildren(parentMembers, children, constraint);
    }

    @Override
    public void getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        this.getMemberChildren(parentMembers, children, constraint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children, MemberChildrenConstraint constraint) {
        MemberCacheHelper memberCacheHelper = this.cacheHelper;
        synchronized (memberCacheHelper) {
            this.checkCacheStatus();
            ArrayList<RolapMember> missed = new ArrayList<RolapMember>();
            for (RolapMember parentMember : parentMembers) {
                List<RolapMember> list = this.cacheHelper.getChildrenFromCache(parentMember, constraint);
                if (list == null) {
                    if (parentMember.isNull()) continue;
                    missed.add(parentMember);
                    continue;
                }
                children.addAll(list);
            }
            if (missed.size() > 0) {
                this.readMemberChildren(missed, children, constraint);
            }
        }
    }

    @Override
    public RolapMember lookupMember(List<Id.Segment> uniqueNameParts, boolean failIfNotFound) {
        return RolapUtil.lookupMember(this, uniqueNameParts, failIfNotFound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readMemberChildren(List<RolapMember> members, List<RolapMember> result, MemberChildrenConstraint constraint) {
        ConcatenableList<RolapMember> children = new ConcatenableList<RolapMember>();
        this.source.getMemberChildren(members, children, constraint);
        HashMap<RolapMember, List> tempMap = new HashMap<RolapMember, List>();
        for (RolapMember member1 : members) {
            tempMap.put(member1, Collections.EMPTY_LIST);
        }
        for (RolapMember child : children) {
            assert (child != null) : "child";
            assert (tempMap != null) : "tempMap";
            RolapMember parentMember = child.getParentMember();
            ArrayList<RolapMember> list = (ArrayList<RolapMember>)tempMap.get(parentMember);
            if (list == null) continue;
            if (list == Collections.EMPTY_LIST) {
                list = new ArrayList<RolapMember>();
                tempMap.put(parentMember, list);
            }
            list.add(child);
            result.add(child);
        }
        MemberCacheHelper memberCacheHelper = this.cacheHelper;
        synchronized (memberCacheHelper) {
            for (Map.Entry entry : tempMap.entrySet()) {
                RolapMember member = (RolapMember)entry.getKey();
                if (this.cacheHelper.getChildrenFromCache(member, constraint) != null) continue;
                List list = (List)entry.getValue();
                this.cacheHelper.putChildren(member, constraint, list);
            }
        }
    }

    public boolean isSorted(List<RolapMember> members) {
        int count = members.size();
        if (count == 0) {
            return true;
        }
        RolapMember m1 = members.get(0);
        if (m1 == null) {
            return false;
        }
        for (int i = 1; i < count; ++i) {
            RolapMember m0 = m1;
            m1 = members.get(i);
            if (m1 != null && this.compare(m0, m1, false) < 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RolapMember getLeadMember(RolapMember member, int n) {
        MemberCacheHelper memberCacheHelper = this.cacheHelper;
        synchronized (memberCacheHelper) {
            if (n == 0 || member.isNull()) {
                return member;
            }
            SiblingIterator iter = new SiblingIterator(this, member);
            if (n > 0) {
                RolapMember sibling = null;
                while (n-- > 0) {
                    if (!iter.hasNext()) {
                        return (RolapMember)member.getHierarchy().getNullMember();
                    }
                    sibling = iter.nextMember();
                }
                return sibling;
            }
            n = -n;
            RolapMember sibling = null;
            while (n-- > 0) {
                if (!iter.hasPrevious()) {
                    return (RolapMember)member.getHierarchy().getNullMember();
                }
                sibling = iter.previousMember();
            }
            return sibling;
        }
    }

    @Override
    public void getMemberRange(RolapLevel level, RolapMember startMember, RolapMember endMember, List<RolapMember> list) {
        assert (startMember != null);
        assert (endMember != null);
        assert (startMember.getLevel() == endMember.getLevel());
        if (this.compare(startMember, endMember, false) > 0) {
            return;
        }
        list.add(startMember);
        if (startMember.equals((OlapElement)endMember)) {
            return;
        }
        SiblingIterator siblings = new SiblingIterator(this, startMember);
        while (siblings.hasNext()) {
            RolapMember member = siblings.nextMember();
            list.add(member);
            if (!member.equals((OlapElement)endMember)) continue;
            return;
        }
        throw Util.newInternal("sibling iterator did not hit end point, start=" + startMember + ", end=" + endMember);
    }

    @Override
    public int getMemberCount() {
        return this.source.getMemberCount();
    }

    @Override
    public int compare(RolapMember m1, RolapMember m2, boolean siblingsAreEqual) {
        int levelDepth2;
        if (m1.equals((OlapElement)m2)) {
            return 0;
        }
        if (Util.equals(m1.getParentMember(), m2.getParentMember())) {
            if (siblingsAreEqual) {
                return 0;
            }
            if (m1.getParentMember() == null) {
                int pos1 = -1;
                int pos2 = -1;
                List<RolapMember> siblingList = this.getRootMembers();
                int n = siblingList.size();
                for (int i = 0; i < n; ++i) {
                    RolapMember child = siblingList.get(i);
                    if (child.equals((OlapElement)m1)) {
                        pos1 = i;
                    }
                    if (!child.equals((OlapElement)m2)) continue;
                    pos2 = i;
                }
                if (pos1 == -1) {
                    throw Util.newInternal(m1 + " not found among siblings");
                }
                if (pos2 == -1) {
                    throw Util.newInternal(m2 + " not found among siblings");
                }
                Util.assertTrue(pos1 != pos2);
                return pos1 < pos2 ? -1 : 1;
            }
            ArrayList<RolapMember> children = new ArrayList<RolapMember>();
            this.getMemberChildren(m1.getParentMember(), children);
            int pos1 = -1;
            int pos2 = -1;
            int n = children.size();
            for (int i = 0; i < n; ++i) {
                RolapMember child = (RolapMember)children.get(i);
                if (child.equals((OlapElement)m1)) {
                    pos1 = i;
                }
                if (!child.equals((OlapElement)m2)) continue;
                pos2 = i;
            }
            if (pos1 == -1) {
                throw Util.newInternal(m1 + " not found among siblings");
            }
            if (pos2 == -1) {
                throw Util.newInternal(m2 + " not found among siblings");
            }
            Util.assertTrue(pos1 != pos2);
            return pos1 < pos2 ? -1 : 1;
        }
        int levelDepth1 = m1.getLevel().getDepth();
        if (levelDepth1 < (levelDepth2 = m2.getLevel().getDepth())) {
            int c = this.compare(m1, m2.getParentMember(), false);
            return c == 0 ? -1 : c;
        }
        if (levelDepth1 > levelDepth2) {
            int c = this.compare(m1.getParentMember(), m2, false);
            return c == 0 ? 1 : c;
        }
        return this.compare(m1.getParentMember(), m2.getParentMember(), false);
    }

    @Override
    public TupleReader.MemberBuilder getMemberBuilder() {
        return this.source.getMemberBuilder();
    }

    @Override
    public RolapMember getDefaultMember() {
        RolapMember defaultMember = (RolapMember)this.getHierarchy().getDefaultMember();
        if (defaultMember != null) {
            return defaultMember;
        }
        return this.getRootMembers().get(0);
    }

    @Override
    public RolapMember getMemberParent(RolapMember member) {
        RolapMember parentMember;
        for (parentMember = member.getParentMember(); parentMember != null && parentMember.isHidden(); parentMember = parentMember.getParentMember()) {
        }
        return parentMember;
    }

    class SiblingIterator {
        private final MemberReader reader;
        private final SiblingIterator parentIterator;
        private List<RolapMember> siblings;
        private int position;

        SiblingIterator(MemberReader reader, RolapMember member) {
            List<RolapMember> siblingList;
            this.reader = reader;
            RolapMember parent = member.getParentMember();
            if (parent == null) {
                siblingList = reader.getRootMembers();
                this.parentIterator = null;
            } else {
                siblingList = new ArrayList<RolapMember>();
                reader.getMemberChildren(parent, siblingList);
                this.parentIterator = new SiblingIterator(reader, parent);
            }
            this.siblings = siblingList;
            this.position = -1;
            for (int i = 0; i < this.siblings.size(); ++i) {
                if (!this.siblings.get(i).equals((OlapElement)member)) continue;
                this.position = i;
                break;
            }
            if (this.position == -1) {
                throw Util.newInternal("member " + member + " not found among its siblings");
            }
        }

        boolean hasNext() {
            return this.position < this.siblings.size() - 1 || this.parentIterator != null && this.parentIterator.hasNext();
        }

        Object next() {
            return this.nextMember();
        }

        RolapMember nextMember() {
            if (++this.position >= this.siblings.size()) {
                if (this.parentIterator == null) {
                    throw Util.newInternal("there is no next member");
                }
                RolapMember parent = this.parentIterator.nextMember();
                ArrayList<RolapMember> siblingList = new ArrayList<RolapMember>();
                this.reader.getMemberChildren(parent, siblingList);
                this.siblings = siblingList;
                this.position = 0;
            }
            return this.siblings.get(this.position);
        }

        boolean hasPrevious() {
            return this.position > 0 || this.parentIterator != null && this.parentIterator.hasPrevious();
        }

        Object previous() {
            return this.previousMember();
        }

        RolapMember previousMember() {
            if (--this.position < 0) {
                if (this.parentIterator == null) {
                    throw Util.newInternal("there is no next member");
                }
                RolapMember parent = this.parentIterator.previousMember();
                ArrayList<RolapMember> siblingList = new ArrayList<RolapMember>();
                this.reader.getMemberChildren(parent, siblingList);
                this.siblings = siblingList;
                this.position = this.siblings.size() - 1;
            }
            return this.siblings.get(this.position);
        }
    }
}

