/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mondrian.olap.Util;
import mondrian.rolap.RolapMember;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.Target;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultLoader {
    private final List<Target> targets;
    private final int enumTargetCount;
    private final ResultSet resultSet;
    private final boolean execQuery;
    private final String message;
    private final List<List<RolapMember>> partialResult;
    private final List<List<RolapMember>> newPartialResult;
    private final SqlStatement stmt;
    private final int[] srcMemberIdxes;
    int currPartialResultIdx = 0;

    public ResultLoader(int enumTargetCount, List<Target> targets, SqlStatement stmt, ResultSet resultSet, boolean execQuery, List<List<RolapMember>> partialResult, List<List<RolapMember>> newPartialResult) throws SQLException {
        this.targets = targets;
        this.enumTargetCount = enumTargetCount;
        this.stmt = stmt;
        this.resultSet = resultSet;
        this.execQuery = execQuery;
        this.partialResult = partialResult;
        this.newPartialResult = newPartialResult;
        this.srcMemberIdxes = enumTargetCount > 0 ? new int[enumTargetCount] : null;
        this.message = "Populating member cache with members for " + targets;
    }

    public boolean loadResult() throws SQLException {
        boolean moreRows = true;
        if (this.enumTargetCount == 0) {
            int column = 0;
            for (Target target : this.targets) {
                target.removeCurrMember();
                column = target.addRow(this.resultSet, column);
            }
        } else {
            int firstEnumTarget;
            for (firstEnumTarget = 0; firstEnumTarget < this.targets.size() && this.targets.get(firstEnumTarget).getSrcMembers() == null; ++firstEnumTarget) {
            }
            List<RolapMember> partialRow = this.execQuery ? null : this.partialResult.get(this.currPartialResultIdx);
            this.resetCurrMembers(partialRow);
            this.addTargets(0, firstEnumTarget, this.enumTargetCount, this.srcMemberIdxes, this.resultSet, this.message);
            if (this.newPartialResult != null) {
                this.savePartialResult(this.newPartialResult);
            }
        }
        if (this.execQuery) {
            moreRows = this.resultSet.next();
            if (moreRows) {
                ++this.stmt.rowCount;
            }
        } else {
            ++this.currPartialResultIdx;
            moreRows = this.currPartialResultIdx < this.partialResult.size();
        }
        return moreRows;
    }

    public void close() {
        if (this.stmt != null) {
            this.stmt.close();
        }
    }

    public RuntimeException handle(Exception e) {
        if (this.stmt != null) {
            return this.stmt.handle(e);
        }
        return Util.newError(e, this.message);
    }

    private void resetCurrMembers(List<RolapMember> partialRow) {
        int nativeTarget = 0;
        for (Target target : this.targets) {
            if (target.getSrcMembers() != null) continue;
            if (partialRow != null) {
                target.setCurrMember(partialRow.get(nativeTarget++));
                continue;
            }
            target.removeCurrMember();
        }
    }

    private void addTargets(int currEnumTargetIdx, int currTargetIdx, int nEnumTargets, int[] srcMemberIdxes, ResultSet resultSet, String message) {
        Target currTarget = this.targets.get(currTargetIdx);
        for (int i = 0; i < currTarget.getSrcMembers().size(); ++i) {
            srcMemberIdxes[currEnumTargetIdx] = i;
            if (currEnumTargetIdx < nEnumTargets - 1) {
                int nextTargetIdx;
                for (nextTargetIdx = currTargetIdx + 1; nextTargetIdx < this.targets.size() && this.targets.get(nextTargetIdx).getSrcMembers() == null; ++nextTargetIdx) {
                }
                this.addTargets(currEnumTargetIdx + 1, nextTargetIdx, nEnumTargets, srcMemberIdxes, resultSet, message);
                continue;
            }
            int column = 0;
            int enumTargetIdx = 0;
            for (Target target : this.targets) {
                if (target.getSrcMembers() == null) {
                    try {
                        column = target.addRow(resultSet, column);
                        continue;
                    }
                    catch (Throwable e) {
                        throw Util.newError(e, message);
                    }
                }
                RolapMember member = target.getSrcMembers().get(srcMemberIdxes[enumTargetIdx++]);
                target.add(member);
            }
        }
    }

    private void savePartialResult(List<List<RolapMember>> partialResult) {
        ArrayList<RolapMember> row = new ArrayList<RolapMember>();
        for (Target target : this.targets) {
            if (target.getSrcMembers() != null) continue;
            row.add(target.getCurrMember());
        }
        partialResult.add(row);
    }
}

