/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.export;

import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.JavaProcessExecuter;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FlashExporterExecuter
extends JavaProcessExecuter {
    private String jrprintFile = null;
    private String outputFile = null;

    public FlashExporterExecuter() {
        File lib_dir;
        File f_classes;
        if (System.getenv("FLEX_SDK_HOME") != null) {
            File f = new File(System.getenv("FLEX_SDK_HOME"));
            File[] jars = f.listFiles();
            for (int i = 0; i < jars.length; ++i) {
                if (!jars[i].getName().toLowerCase().endsWith(".jar")) continue;
                this.getClasspathEntries().add(0, jars[i].getPath());
            }
        }
        Vector cp = MainFrame.getMainInstance().getClasspath();
        for (int i = 0; i < cp.size(); ++i) {
            File f = new File(cp.elementAt(i) + "");
            if (!f.exists()) continue;
            try {
                this.getClasspathEntries().add(f.getCanonicalPath());
                continue;
            }
            catch (Exception ex) {
                System.out.println("Invalid path: " + f);
            }
        }
        MainFrame.getMainInstance();
        String irHome = MainFrame.IREPORT_HOME_DIR;
        if (irHome == null) {
            irHome = System.getProperty("ireport.home", ".");
        }
        if ((f_classes = new File(irHome, "classes")).exists()) {
            try {
                this.getClasspathEntries().add(f_classes.getCanonicalPath());
            }
            catch (IOException ex) {
                Logger.getLogger(FlashExporterExecuter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if ((lib_dir = new File(irHome, "lib")).exists()) {
            File[] jars = lib_dir.listFiles();
            for (int i = 0; i < jars.length; ++i) {
                if (!jars[i].getName().toLowerCase().endsWith(".jar") && !jars[i].getName().toLowerCase().endsWith(".zip")) continue;
                try {
                    this.getClasspathEntries().add(jars[i].getCanonicalPath());
                    continue;
                }
                catch (Exception ex) {
                    System.out.println("Invalid path: " + jars[i]);
                }
            }
        }
        this.setMainClass("it.businesslogic.ireport.export.FlashExporter");
    }

    public String getJrprintFile() {
        return this.jrprintFile;
    }

    public void setJrprintFile(String jrprintFile) {
        this.jrprintFile = jrprintFile;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public void execute() throws IOException {
        this.getParameters().clear();
        this.getParameters().add(this.getJrprintFile());
        this.getParameters().add(this.getOutputFile());
        super.execute();
    }
}

