/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.style;

import it.businesslogic.ireport.JasperTemplate;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.Style;
import it.businesslogic.ireport.Template;
import it.businesslogic.ireport.TemplateStyle;
import it.businesslogic.ireport.UndefinedStyle;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.dnd.JListTransfertHandler;
import it.businesslogic.ireport.gui.docking.GenericDragTargetListener;
import it.businesslogic.ireport.gui.event.ReportFrameActivatedEvent;
import it.businesslogic.ireport.gui.event.ReportFrameActivatedListener;
import it.businesslogic.ireport.gui.event.StyleChangedEvent;
import it.businesslogic.ireport.gui.event.StyleChangedListener;
import it.businesslogic.ireport.gui.event.TemplateChangedEvent;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.gui.style.JBGTree;
import it.businesslogic.ireport.gui.style.JRTemplateDialog;
import it.businesslogic.ireport.gui.style.StyleDialog;
import it.businesslogic.ireport.gui.style.TemplateDataDialog;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class StylesView
extends JPanel
implements LanguageChangedListener,
ReportFrameActivatedListener,
StyleChangedListener {
    private JReportFrame activeReportFrame = null;
    private DefaultTreeModel libraryTreeModel = null;
    private DefaultTreeModel reportTreeModel = null;
    private ArrayList<JasperTemplate> openedTemplates = new ArrayList();
    private JButton jButtonAddStyle;
    private JButton jButtonDeleteStyle;
    private JButton jButtonEditStyle;
    private JComboBox jComboBoxStyleType;
    private JBGTree jListStyles;
    private JBGTree jListStylesLibrary;
    private JMenuItem jMenuItemAddStyleToJT;
    private JMenuItem jMenuItemAddTemplateToJT;
    private JMenuItem jMenuItemCloseTemplate;
    private JMenuItem jMenuItemEditJTemplate;
    private JMenuItem jMenuItemEditStyle;
    private JMenuItem jMenuItemEditTemplate;
    private JMenuItem jMenuItemNewStyle;
    private JMenuItem jMenuItemNewStyleTemplate;
    private JMenuItem jMenuItemNewTemplateItem;
    private JMenuItem jMenuItemOpenStyleTemplate;
    private JMenuItem jMenuItemRemove;
    private JPanel jPanel1;
    private JPopupMenu jPopupMenu1;
    private JScrollPane jScrollPaneLibraryList;
    private JScrollPane jScrollPaneReportList;
    private JScrollPane jScrollPaneReportList1;
    private JToolBar jToolBar1;

    public StylesView() {
        this.initComponents();
        this.applyI18n();
        this.reportTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode("report"));
        this.jListStyles.setDropTarget(new DropTarget(this, 2, new GenericDragTargetListener(), true));
        this.jListStyles.setTransferHandler(new JListTransfertHandler());
        this.jListStyles.setRootVisible(false);
        this.jListStyles.setModel(this.reportTreeModel);
        this.libraryTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode("library"));
        this.jListStylesLibrary.setTransferHandler(new JListTransfertHandler());
        this.jListStylesLibrary.setRootVisible(false);
        this.jListStylesLibrary.setModel(this.libraryTreeModel);
        this.jComboBoxStyleType.addItem(new Tag("reportStyles", I18n.getString("stylesView.reportStyles", "Report styles")));
        this.jComboBoxStyleType.addItem(new Tag("libraryStyles", I18n.getString("stylesView.stylesLibrary", "Styles library")));
        this.languageChanged(null);
        MainFrame.getMainInstance().addReportFrameActivatedListener(this);
        this.updateStyles();
        this.jComboBoxStyleType.setSelectedIndex(0);
    }

    public void loadLibraryStyles() {
        Vector v = MainFrame.getMainInstance().getStyleLibrarySet();
        for (int i = 0; i < v.size(); ++i) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(v.elementAt(i));
            ((DefaultMutableTreeNode)this.libraryTreeModel.getRoot()).add(node);
        }
        this.jListStylesLibrary.clearSelection();
        this.jListStylesLibrary.updateUI();
    }

    public void refreshReportStyles() {
        ((DefaultMutableTreeNode)this.reportTreeModel.getRoot()).removeAllChildren();
        if (this.getActiveReportFrame() != null) {
            DefaultMutableTreeNode node;
            int i;
            Vector v = this.getActiveReportFrame().getReport().getStyles();
            for (i = 0; i < v.size(); ++i) {
                node = new DefaultMutableTreeNode(v.elementAt(i));
                ((DefaultMutableTreeNode)this.reportTreeModel.getRoot()).add(node);
            }
            v = this.getActiveReportFrame().getReport().getTemplates();
            for (i = 0; i < v.size(); ++i) {
                node = new DefaultMutableTreeNode(v.elementAt(i));
                ((DefaultMutableTreeNode)this.reportTreeModel.getRoot()).add(node);
            }
        }
        this.jListStyles.clearSelection();
        this.jListStyles.updateUI();
        if (this.isListingReportStyles()) {
            this.jListStylesValueChanged(null);
        }
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItemNewStyle = new JMenuItem();
        this.jMenuItemNewStyleTemplate = new JMenuItem();
        this.jMenuItemEditStyle = new JMenuItem();
        this.jMenuItemEditTemplate = new JMenuItem();
        this.jMenuItemRemove = new JMenuItem();
        this.jMenuItemCloseTemplate = new JMenuItem();
        this.jMenuItemAddTemplateToJT = new JMenuItem();
        this.jMenuItemAddStyleToJT = new JMenuItem();
        this.jMenuItemNewTemplateItem = new JMenuItem();
        this.jMenuItemOpenStyleTemplate = new JMenuItem();
        this.jScrollPaneLibraryList = new JScrollPane();
        this.jListStylesLibrary = new JBGTree();
        this.jMenuItemEditJTemplate = new JMenuItem();
        this.jScrollPaneReportList = new JScrollPane();
        this.jListStyles = new JBGTree();
        this.jPanel1 = new JPanel();
        this.jComboBoxStyleType = new JComboBox();
        this.jToolBar1 = new JToolBar();
        this.jButtonAddStyle = new JButton();
        this.jButtonEditStyle = new JButton();
        this.jButtonDeleteStyle = new JButton();
        this.jPopupMenu1.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                StylesView.this.jPopupMenu1PopupMenuWillBecomeVisible(evt);
            }
        });
        this.jMenuItemNewStyle.setText("New style");
        this.jMenuItemNewStyle.setActionCommand("New Style");
        this.jMenuItemNewStyle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StylesView.this.jMenuItemNewStyleActionPerformed(evt);
            }
        });
        this.jMenuItemNewStyleTemplate.setText("New Jasper Template");
        this.jMenuItemNewStyleTemplate.setActionCommand("New Style Template");
        this.jMenuItemNewStyleTemplate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StylesView.this.jMenuItemNewStyleTemplateActionPerformed(evt);
            }
        });
        this.jMenuItemEditStyle.setText("Edit Style");
        this.jMenuItemEditStyle.setActionCommand("New Style Template");
        this.jMenuItemEditStyle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StylesView.this.jMenuItemEditStyleActionPerformed(evt);
            }
        });
        this.jMenuItemEditTemplate.setText("Edit Template Reference");
        this.jMenuItemEditTemplate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StylesView.this.jMenuItemEditTemplateActionPerformed(evt);
            }
        });
        this.jMenuItemRemove.setText("Delete");
        this.jMenuItemRemove.setActionCommand("New Style Template");
        this.jMenuItemRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StylesView.this.jMenuItemRemoveActionPerformed(evt);
            }
        });
        this.jMenuItemCloseTemplate.setText("Close Jasper Template");
        this.jMenuItemCloseTemplate.setActionCommand("New Style Template");
        this.jMenuItemCloseTemplate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StylesView.this.jMenuItemCloseTemplateActionPerformed(evt);
            }
        });
        this.jMenuItemAddTemplateToJT.setText("Add Template to Jasper Template");
        this.jMenuItemAddTemplateToJT.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StylesView.this.jMenuItemAddTemplateToJTActionPerformed(evt);
            }
        });
        this.jMenuItemAddStyleToJT.setText("Add Style to Jasper Template");
        this.jMenuItemAddStyleToJT.setActionCommand("New Style");
        this.jMenuItemAddStyleToJT.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StylesView.this.jMenuItemAddStyleToJTActionPerformed(evt);
            }
        });
        this.jMenuItemNewTemplateItem.setText("New Template Item");
        this.jMenuItemNewTemplateItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StylesView.this.jMenuItemNewTemplateItemActionPerformed(evt);
            }
        });
        this.jMenuItemOpenStyleTemplate.setText("Open Jasper Template");
        this.jMenuItemOpenStyleTemplate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StylesView.this.jMenuItemOpenStyleTemplateActionPerformed(evt);
            }
        });
        this.jListStylesLibrary.setComponentPopupMenu(this.jPopupMenu1);
        this.jListStylesLibrary.setDragEnabled(true);
        this.jListStylesLibrary.setOpaque(false);
        this.jListStylesLibrary.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                StylesView.this.jListStylesLibraryMouseClicked(evt);
            }
        });
        this.jListStylesLibrary.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                StylesView.this.jListStylesLibraryValueChanged(evt);
            }
        });
        this.jScrollPaneLibraryList.setViewportView(this.jListStylesLibrary);
        this.jMenuItemEditJTemplate.setText("Edit Template Reference");
        this.jMenuItemEditJTemplate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StylesView.this.jMenuItemEditJTemplateActionPerformed(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jScrollPaneReportList.setBackground(new Color(255, 255, 255));
        this.jListStyles.setComponentPopupMenu(this.jPopupMenu1);
        this.jListStyles.setDragEnabled(true);
        this.jListStyles.setOpaque(false);
        this.jListStyles.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                StylesView.this.jListStylesMouseClicked(evt);
            }
        });
        this.jListStyles.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                StylesView.this.jListStylesValueChanged(evt);
            }
        });
        this.jScrollPaneReportList.setViewportView(this.jListStyles);
        this.add((Component)this.jScrollPaneReportList, "Center");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jComboBoxStyleType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StylesView.this.jComboBoxStyleTypeActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 4);
        this.jPanel1.add((Component)this.jComboBoxStyleType, gridBagConstraints);
        this.jToolBar1.setFloatable(false);
        this.jButtonAddStyle.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/styles/style_add.png")));
        this.jButtonAddStyle.setToolTipText("Style add");
        this.jButtonAddStyle.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButtonAddStyle.setFocusPainted(false);
        this.jButtonAddStyle.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonAddStyle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StylesView.this.jButtonAddStyleActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonAddStyle);
        this.jButtonEditStyle.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/styles/style_edit.png")));
        this.jButtonEditStyle.setToolTipText("Style add");
        this.jButtonEditStyle.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButtonEditStyle.setFocusPainted(false);
        this.jButtonEditStyle.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonEditStyle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StylesView.this.jButtonEditStyleActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonEditStyle);
        this.jButtonDeleteStyle.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/styles/style_delete.png")));
        this.jButtonDeleteStyle.setToolTipText("Style add");
        this.jButtonDeleteStyle.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButtonDeleteStyle.setFocusPainted(false);
        this.jButtonDeleteStyle.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonDeleteStyle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StylesView.this.jButtonDeleteStyleActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonDeleteStyle);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jToolBar1, gridBagConstraints);
        this.add((Component)this.jPanel1, "North");
    }

    private void jMenuItemEditJTemplateActionPerformed(ActionEvent evt) {
        Object selectedObject = this.getActiveList().getSelectedItem();
        if (selectedObject == null || !(selectedObject instanceof JasperTemplate)) {
            return;
        }
        JasperTemplate template = (JasperTemplate)selectedObject;
        if (template.getParent() != null) {
            return;
        }
        TemplateDataDialog td = new TemplateDataDialog((Frame)MainFrame.getMainInstance(), true);
        String exp = template.getExpression();
        td.setTemplate(exp);
        td.setVisible(true);
        if (td.getDialogResult() == 0) {
            template.setExpression(td.getTemplate());
            try {
                template.getParent().saveTemplateFile();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.getActiveList().updateUI();
        }
    }

    private void jMenuItemAddTemplateToJTActionPerformed(ActionEvent evt) {
        Object selectedObject = this.getActiveList().getSelectedItem();
        if (selectedObject != null && selectedObject instanceof JasperTemplate) {
            JasperTemplate jt = (JasperTemplate)selectedObject;
            if (jt.getParent() != null) {
                return;
            }
            if (jt.canWrite()) {
                TemplateDataDialog tdd = new TemplateDataDialog((Frame)MainFrame.getMainInstance(), true);
                tdd.setVisible(true);
                if (tdd.getDialogResult() == 0) {
                    String templateStr = tdd.getTemplate();
                    JasperTemplate newTemplate = new JasperTemplate(templateStr);
                    newTemplate.setParent(jt);
                    jt.getTemplates().add(newTemplate);
                    try {
                        jt.saveTemplateFile();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    DefaultMutableTreeNode node = Misc.findNodeWithUserObject(selectedObject, (DefaultMutableTreeNode)this.getActiveList().getModel().getRoot());
                    DefaultMutableTreeNode child = new DefaultMutableTreeNode(newTemplate);
                    node.add(child);
                    this.getActiveList().expandPath(new TreePath(node.getPath()));
                    this.getActiveList().updateUI();
                }
            }
        }
    }

    private void jMenuItemAddStyleToJTActionPerformed(ActionEvent evt) {
        Object selectedObject = this.getActiveList().getSelectedItem();
        if (selectedObject != null && selectedObject instanceof JasperTemplate) {
            JasperTemplate jt = (JasperTemplate)selectedObject;
            if (jt.getParent() != null) {
                return;
            }
            if (jt.canWrite()) {
                StyleDialog sd = new StyleDialog((Frame)MainFrame.getMainInstance(), true);
                sd.setLibraryStyle(true);
                sd.setJasperTemplate(jt);
                sd.setVisible(true);
                if (sd.getDialogResult() == 0) {
                    TemplateStyle templateStyle = new TemplateStyle(sd.getStyle());
                    templateStyle.setJasperTemplate(jt);
                    jt.getStyles().add(templateStyle);
                    try {
                        jt.saveTemplateFile();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    DefaultMutableTreeNode node = Misc.findNodeWithUserObject(selectedObject, (DefaultMutableTreeNode)this.getActiveList().getModel().getRoot());
                    DefaultMutableTreeNode child = new DefaultMutableTreeNode(templateStyle);
                    node.add(child);
                    this.getActiveList().expandPath(new TreePath(node.getPath()));
                    this.getActiveList().updateUI();
                }
            }
        }
    }

    private void jMenuItemCloseTemplateActionPerformed(ActionEvent evt) {
        Object selectedObject = this.getActiveList().getSelectedItem();
        if (selectedObject != null && selectedObject instanceof JasperTemplate) {
            JasperTemplate jt = (JasperTemplate)selectedObject;
            if (jt.getParent() != null) {
                jt = jt.getParent();
            }
            DefaultMutableTreeNode node = Misc.findNodeWithUserObject(jt, (DefaultMutableTreeNode)this.getActiveList().getModel().getRoot());
            ((DefaultTreeModel)this.getActiveList().getModel()).removeNodeFromParent(node);
            this.getActiveList().updateUI();
        }
    }

    private void jListStylesValueChanged(TreeSelectionEvent evt) {
        Object selectedObject = this.jListStyles.getSelectedItem();
        if (selectedObject == null || selectedObject instanceof TemplateStyle || selectedObject instanceof Template || selectedObject instanceof JasperTemplate) {
            this.jButtonEditStyle.setEnabled(false);
            this.jButtonDeleteStyle.setEnabled(false);
        } else if (selectedObject instanceof Style) {
            this.jButtonEditStyle.setEnabled(true);
            this.jButtonDeleteStyle.setEnabled(true);
        } else {
            this.jButtonEditStyle.setEnabled(false);
            this.jButtonDeleteStyle.setEnabled(false);
        }
        this.jButtonAddStyle.setEnabled(!this.isListingReportStyles() || this.getActiveReportFrame() != null);
    }

    private void jListStylesLibraryValueChanged(TreeSelectionEvent evt) {
        Object selectedObject = this.jListStylesLibrary.getSelectedItem();
        if (selectedObject == null || selectedObject instanceof TemplateStyle || selectedObject instanceof Template || selectedObject instanceof JasperTemplate) {
            this.jButtonEditStyle.setEnabled(false);
            this.jButtonDeleteStyle.setEnabled(false);
        } else if (selectedObject instanceof Style) {
            this.jButtonEditStyle.setEnabled(true);
            this.jButtonDeleteStyle.setEnabled(true);
        } else {
            this.jButtonEditStyle.setEnabled(false);
            this.jButtonDeleteStyle.setEnabled(false);
        }
        this.jButtonAddStyle.setEnabled(true);
    }

    private void jListStylesLibraryMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1) {
                Object selectedObject = this.jListStylesLibrary.getSelectedItem();
                if (selectedObject != null && selectedObject instanceof Style) {
                    this.jButtonEditStyleActionPerformed(null);
                } else if (selectedObject != null && selectedObject instanceof Template) {
                    this.jMenuItemEditTemplateActionPerformed(null);
                }
            }
        }
    }

    private void jMenuItemNewStyleTemplateActionPerformed(ActionEvent evt) {
        try {
            String fileName = "";
            JFileChooser jfc = new JFileChooser(MainFrame.getMainInstance().getCurrentDirectory());
            jfc.setDialogTitle("New JasperTemplate");
            jfc.setDialogTitle(I18n.getString("style.title.newJasperTemplate", "New JasperTemplate"));
            jfc.setAcceptAllFileFilterUsed(true);
            jfc.setFileSelectionMode(0);
            jfc.addChoosableFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    String filename = file.getName();
                    return filename.toLowerCase().endsWith(".jrtx") || file.isDirectory();
                }

                public String getDescription() {
                    return "*.jrtx";
                }
            });
            jfc.setDialogType(1);
            if (jfc.showOpenDialog(this) == 0) {
                File file = jfc.getSelectedFile();
                if (!file.getName().toLowerCase().endsWith(".jrtx")) {
                    file = new File(file + ".jrtx");
                }
                JasperTemplate jt = new JasperTemplate();
                jt.setFilename(file + "");
                System.out.println("Saved to " + jt.getFilename());
                jt.saveTemplateFile();
                this.openedTemplates.add(jt);
                ((DefaultMutableTreeNode)this.libraryTreeModel.getRoot()).add(this.createTemplateNode(jt));
                this.getActiveList().updateUI();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private DefaultMutableTreeNode createTemplateNode(JasperTemplate jt) {
        DefaultMutableTreeNode dmtn = new DefaultMutableTreeNode(jt);
        jt.reloadTemplate();
        for (JasperTemplate template : jt.getTemplates()) {
            DefaultMutableTreeNode templateNode = new DefaultMutableTreeNode(template);
            dmtn.add(templateNode);
        }
        for (TemplateStyle style : jt.getStyles()) {
            DefaultMutableTreeNode styleNode = new DefaultMutableTreeNode(style);
            dmtn.add(styleNode);
        }
        return dmtn;
    }

    private void jMenuItemNewStyleActionPerformed(ActionEvent evt) {
        this.jButtonAddStyleActionPerformed(evt);
    }

    private void jMenuItemEditStyleActionPerformed(ActionEvent evt) {
        this.jButtonEditStyleActionPerformed(evt);
    }

    private void jMenuItemRemoveActionPerformed(ActionEvent evt) {
        if (this.isListingReportStyles()) {
            if (this.getActiveReportFrame() == null) {
                return;
            }
            Object selectedObject = this.getActiveList().getSelectedItem();
            if (selectedObject == null) {
                return;
            }
            if (selectedObject instanceof Template) {
                Template template = (Template)selectedObject;
                this.getActiveReportFrame().getReport().removeTemplate(template);
                DefaultMutableTreeNode node = Misc.findNodeWithUserObject(selectedObject, (DefaultMutableTreeNode)this.getActiveList().getModel().getRoot());
                ((DefaultTreeModel)this.getActiveList().getModel()).removeNodeFromParent(node);
                this.getActiveList().updateUI();
            } else if (selectedObject instanceof Style) {
                this.jButtonDeleteStyleActionPerformed(null);
            }
        } else {
            Object selectedObject = this.getActiveList().getSelectedItem();
            if (selectedObject == null) {
                return;
            }
            if (selectedObject instanceof JasperTemplate) {
                JasperTemplate jt = (JasperTemplate)selectedObject;
                if (jt.getParent() != null) {
                    JasperTemplate parent = jt.getParent();
                    parent.getTemplates().remove(jt);
                    try {
                        parent.saveTemplateFile();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                DefaultMutableTreeNode node = Misc.findNodeWithUserObject(selectedObject, (DefaultMutableTreeNode)this.getActiveList().getModel().getRoot());
                ((DefaultTreeModel)this.getActiveList().getModel()).removeNodeFromParent(node);
                this.getActiveList().updateUI();
            } else if (selectedObject instanceof TemplateStyle) {
                TemplateStyle ts = (TemplateStyle)selectedObject;
                if (ts.getJasperTemplate() != null) {
                    JasperTemplate parent = ts.getJasperTemplate();
                    parent.getStyles().remove(ts);
                    try {
                        parent.saveTemplateFile();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                DefaultMutableTreeNode node = Misc.findNodeWithUserObject(selectedObject, (DefaultMutableTreeNode)this.getActiveList().getModel().getRoot());
                ((DefaultTreeModel)this.getActiveList().getModel()).removeNodeFromParent(node);
                this.getActiveList().updateUI();
            } else {
                this.jButtonDeleteStyleActionPerformed(null);
            }
        }
    }

    private void jMenuItemEditTemplateActionPerformed(ActionEvent evt) {
        if (this.getActiveReportFrame() == null) {
            return;
        }
        Object selectedObject = this.getActiveList().getSelectedItem();
        if (selectedObject == null || !(selectedObject instanceof Template)) {
            return;
        }
        Template template = (Template)selectedObject;
        JRTemplateDialog td = new JRTemplateDialog((Frame)MainFrame.getMainInstance(), true);
        td.setTemplate(template);
        td.setVisible(true);
        if (td.getDialogResult() == 0) {
            boolean modified = false;
            modified = modified || !template.getExpression().equals(td.getTemplate().getExpression());
            template.setExpression(td.getTemplate().getExpression());
            modified = modified || !template.getExpressionClass().equals(td.getTemplate().getExpressionClass());
            template.setExpressionClass(td.getTemplate().getExpressionClass());
            if (modified) {
                this.getActiveReportFrame().getReport().incrementReportChanges();
            }
            this.getActiveList().updateUI();
        }
    }

    private void jMenuItemNewTemplateItemActionPerformed(ActionEvent evt) {
        if (this.getActiveReportFrame() == null) {
            return;
        }
        JRTemplateDialog td = new JRTemplateDialog((Frame)MainFrame.getMainInstance(), true);
        td.setVisible(true);
        if (td.getDialogResult() == 0) {
            Template template = td.getTemplate();
            try {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(template);
                ((DefaultMutableTreeNode)this.jListStyles.getModel().getRoot()).add(node);
                this.jListStyles.updateUI();
            }
            catch (Exception ex) {
                return;
            }
            this.getActiveReportFrame().getReport().addTemplate(template);
            this.getActiveReportFrame().getReport().incrementReportChanges();
        }
    }

    private void jMenuItemOpenStyleTemplateActionPerformed(ActionEvent evt) {
        try {
            String fileName = "";
            JFileChooser jfc = new JFileChooser(MainFrame.getMainInstance().getCurrentDirectory());
            jfc.setDialogTitle("Open JasperTemplate");
            jfc.setDialogTitle(I18n.getString("style.title.openJasperTemplate", "Open JasperTemplate"));
            jfc.setAcceptAllFileFilterUsed(true);
            jfc.setFileSelectionMode(0);
            jfc.addChoosableFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    String filename = file.getName();
                    return filename.toLowerCase().endsWith(".jrtx") || file.isDirectory();
                }

                public String getDescription() {
                    return "*.jrtx";
                }
            });
            jfc.setMultiSelectionEnabled(true);
            jfc.setDialogType(0);
            if (jfc.showOpenDialog(this) == 0) {
                File[] files = jfc.getSelectedFiles();
                for (int i = 0; i < files.length; ++i) {
                    JasperTemplate jt = new JasperTemplate();
                    jt.setFilename(files[i] + "");
                    this.openedTemplates.add(jt);
                    ((DefaultMutableTreeNode)this.libraryTreeModel.getRoot()).add(this.createTemplateNode(jt));
                }
                this.getActiveList().updateUI();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jPopupMenu1PopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        Object selectedObject = this.getActiveList().getSelectedItem();
        this.jPopupMenu1.removeAll();
        if (this.isListingReportStyles()) {
            this.jPopupMenu1.add(this.jMenuItemNewStyle);
            this.jMenuItemNewStyle.setEnabled(this.getActiveReportFrame() != null);
            this.jPopupMenu1.add(this.jMenuItemNewTemplateItem);
            this.jMenuItemNewTemplateItem.setEnabled(this.getActiveReportFrame() != null);
            if (selectedObject != null) {
                if (selectedObject instanceof Style) {
                    this.jMenuItemEditStyle.setEnabled(true);
                    this.jPopupMenu1.add(this.jMenuItemEditStyle);
                } else if (selectedObject instanceof Template) {
                    this.jPopupMenu1.add(this.jMenuItemEditTemplate);
                }
                this.jMenuItemRemove.setEnabled(true);
                this.jPopupMenu1.add(this.jMenuItemRemove);
            }
        } else {
            this.jMenuItemNewStyle.setEnabled(true);
            this.jPopupMenu1.add(this.jMenuItemNewStyle);
            this.jPopupMenu1.add(this.jMenuItemNewStyleTemplate);
            this.jPopupMenu1.add(this.jMenuItemOpenStyleTemplate);
            if (selectedObject != null) {
                if (selectedObject instanceof TemplateStyle) {
                    TemplateStyle ts = (TemplateStyle)selectedObject;
                    this.jPopupMenu1.add(new JSeparator());
                    this.jPopupMenu1.add(this.jMenuItemEditStyle);
                    this.jMenuItemEditStyle.setEnabled(ts.getJasperTemplate().canWrite());
                    this.jPopupMenu1.add(this.jMenuItemRemove);
                    this.jMenuItemRemove.setEnabled(ts.getJasperTemplate().canWrite());
                } else if (selectedObject instanceof Style) {
                    this.jPopupMenu1.add(this.jMenuItemEditStyle);
                    this.jPopupMenu1.add(this.jMenuItemRemove);
                } else if (selectedObject instanceof JasperTemplate) {
                    JasperTemplate jt = (JasperTemplate)selectedObject;
                    this.jPopupMenu1.add(this.jMenuItemCloseTemplate);
                    if (jt.getParent() == null) {
                        this.jPopupMenu1.add(new JSeparator());
                        this.jPopupMenu1.add(this.jMenuItemAddStyleToJT);
                        this.jPopupMenu1.add(this.jMenuItemAddTemplateToJT);
                    } else {
                        this.jPopupMenu1.add(new JSeparator());
                        this.jPopupMenu1.add(this.jMenuItemEditJTemplate);
                        this.jMenuItemEditJTemplate.setEnabled(jt.getParent().canWrite());
                        this.jPopupMenu1.add(this.jMenuItemRemove);
                        this.jMenuItemRemove.setEnabled(jt.getParent().canWrite());
                    }
                }
            }
        }
    }

    private void jComboBoxStyleTypeActionPerformed(ActionEvent evt) {
        this.updateStyles();
    }

    private void jListStylesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1) {
                Object selectedObject = this.jListStyles.getSelectedItem();
                if (selectedObject != null && selectedObject instanceof Style) {
                    this.jButtonEditStyleActionPerformed(null);
                } else if (selectedObject != null && selectedObject instanceof Template) {
                    this.jMenuItemEditTemplateActionPerformed(null);
                }
            }
        }
    }

    private void jButtonDeleteStyleActionPerformed(ActionEvent evt) {
        Object selectedObject = this.getActiveList().getSelectedItem();
        if (selectedObject == null) {
            return;
        }
        if (selectedObject instanceof TemplateStyle) {
            return;
        }
        if (selectedObject instanceof Template) {
            return;
        }
        if (selectedObject instanceof Style) {
            Style irc = null;
            try {
                irc = (Style)selectedObject;
            }
            catch (Exception ex) {
                return;
            }
            if (JOptionPane.showConfirmDialog(this, I18n.getString("messages.stylesDialog.removingStyle", "Do you want really remove this style?"), "", 1, 3) == 0) {
                if (!this.isListingReportStyles()) {
                    MainFrame.getMainInstance().getStyleLibrarySet().remove(irc);
                    MainFrame.getMainInstance().saveStyleLibrary();
                    DefaultTreeModel dtm = (DefaultTreeModel)this.getActiveList().getModel();
                    dtm.removeNodeFromParent((MutableTreeNode)this.getActiveList().getSelectionPath().getLastPathComponent());
                } else {
                    Report report = MainFrame.getMainInstance().getActiveReportFrame().getReport();
                    report.removeStyle(irc);
                }
            }
        }
    }

    private void jButtonEditStyleActionPerformed(ActionEvent evt) {
        TemplateStyle ts;
        Object selectedObject = this.getActiveList().getSelectedItem();
        if (selectedObject == null) {
            return;
        }
        if (!(selectedObject instanceof Style)) {
            return;
        }
        StyleDialog cd = new StyleDialog((Frame)MainFrame.getMainInstance(), true);
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.getActiveList().getSelectionPath().getLastPathComponent();
        Style irc = (Style)selectedObject;
        cd.setStyle(irc);
        cd.setLibraryStyle(!this.isListingReportStyles());
        if (irc instanceof TemplateStyle && ((ts = (TemplateStyle)irc).getJasperTemplate().getParent() != null || !ts.getJasperTemplate().canWrite())) {
            cd.setReadOnly(true);
        }
        if (irc instanceof UndefinedStyle) {
            cd.setLibraryStyle(true);
            cd.setReadOnly(true);
        }
        cd.setVisible(true);
        if (cd.getDialogResult() == 0) {
            Style sub = cd.getStyle();
            try {
                selectedNode.setUserObject(sub);
                this.getActiveList().updateUI();
            }
            catch (Exception ex) {
                return;
            }
            if (selectedObject instanceof TemplateStyle) {
                try {
                    ((TemplateStyle)selectedObject).getJasperTemplate().saveTemplateFile();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (!this.isListingReportStyles()) {
                MainFrame.getMainInstance().saveStyleLibrary();
            }
            this.getActiveList().updateUI();
        }
    }

    private void jButtonAddStyleActionPerformed(ActionEvent evt) {
        StyleDialog cd = new StyleDialog((Frame)MainFrame.getMainInstance(), true);
        if (!this.isListingReportStyles()) {
            cd.setLibraryStyle(true);
        } else if (this.getActiveReportFrame() == null) {
            return;
        }
        cd.setVisible(true);
        if (cd.getDialogResult() == 0 && cd.isLibraryStyle()) {
            DefaultMutableTreeNode dmtn = new DefaultMutableTreeNode(cd.getStyle());
            ((DefaultMutableTreeNode)this.getActiveList().getModel().getRoot()).add(dmtn);
            this.getActiveList().updateUI();
            MainFrame.getMainInstance().saveStyleLibrary();
        }
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.jButtonAddStyle.setToolTipText(I18n.getString("gui.style.newStyle", "New Style"));
        this.jButtonEditStyle.setToolTipText(I18n.getString("gui.style.editStyle", "Edit Style"));
        this.jButtonDeleteStyle.setToolTipText(I18n.getString("gui.style.deleteStyle", "Delete Style"));
        this.jMenuItemNewStyle.setText(I18n.getString("gui.style.newStyle", "New Style"));
        this.jMenuItemEditStyle.setText(I18n.getString("gui.style.editStyle", "Edit Style"));
        this.jMenuItemRemove.setText(I18n.getString("gui.style.remove", "Remove"));
        this.jMenuItemNewTemplateItem.setText(I18n.getString("gui.style.newTemaplateItem", "New Template Item"));
        this.jMenuItemEditTemplate.setText(I18n.getString("gui.style.editTemaplateItem", "Edit Template Item"));
        for (int i = 0; i < this.jComboBoxStyleType.getItemCount(); ++i) {
            Tag t = (Tag)this.jComboBoxStyleType.getItemAt(i);
            if (t.getName().equals("reportStyles")) {
                t.setName(I18n.getString("gui.style.types.reportStyles", "Report Styles"));
                continue;
            }
            if (!t.getName().equals("libraryStyles")) continue;
            t.setName(I18n.getString("gui.style.types.libraryStyles", "Styles Library"));
        }
    }

    public void reportFrameActivated(ReportFrameActivatedEvent evt) {
        this.setActiveReportFrame(evt.getReportFrame());
    }

    public JReportFrame getActiveReportFrame() {
        return this.activeReportFrame;
    }

    public void setActiveReportFrame(JReportFrame newActiveReportFrame) {
        if (newActiveReportFrame != this.activeReportFrame) {
            if (this.activeReportFrame != null) {
                this.activeReportFrame.getReport().removeStyleChangedListener(this);
            }
        } else {
            return;
        }
        this.activeReportFrame = newActiveReportFrame;
        if (this.activeReportFrame != null) {
            this.activeReportFrame.getReport().addStyleChangedListener(this);
        }
        this.refreshReportStyles();
    }

    public void updateStyles() {
        this.jListStyles.setShowLibrary(!this.isListingReportStyles());
        if (((Tag)this.jComboBoxStyleType.getSelectedItem()).getValue().equals("libraryStyles")) {
            this.remove(this.jScrollPaneReportList);
            this.add((Component)this.jScrollPaneLibraryList, "Center");
            this.jListStylesLibraryValueChanged(null);
        } else if (((Tag)this.jComboBoxStyleType.getSelectedItem()).getValue().equals("reportStyles")) {
            this.remove(this.jScrollPaneLibraryList);
            this.add((Component)this.jScrollPaneReportList, "Center");
            this.jListStylesValueChanged(null);
        }
        this.updateUI();
    }

    public void styleChanged(StyleChangedEvent evt) {
        if (evt.getSource() == this) {
            return;
        }
        this.refreshReportStyles();
    }

    public void templateChanged(TemplateChangedEvent evt) {
        if (evt.getSource() == this) {
            return;
        }
        this.refreshReportStyles();
    }

    public boolean isListingReportStyles() {
        Tag t = (Tag)this.jComboBoxStyleType.getSelectedItem();
        return t != null && t.getValue().equals("reportStyles");
    }

    public void applyI18n() {
    }

    public JBGTree getActiveList() {
        return this.isListingReportStyles() ? this.jListStyles : this.jListStylesLibrary;
    }
}

