/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.dockbar.event;

import java.awt.Point;
import org.flexdock.dockbar.DockbarManager;
import org.flexdock.dockbar.event.DockbarEvent;
import org.flexdock.docking.Dockable;
import org.flexdock.event.EventManager;
import org.flexdock.logging.Log;
import org.flexdock.util.Utilities;

public class ActivationListener {
    private DockbarManager manager;
    private Deactivator deactivator;
    private boolean enabled;
    private boolean mouseOver;

    public ActivationListener(DockbarManager mgr) {
        this.manager = mgr;
        this.setEnabled(true);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isActive() {
        return this.manager.isActive() && !this.manager.isAnimating() && !this.manager.isDragging();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isAvailable() {
        return this.isEnabled() && this.isActive();
    }

    public boolean isViewpaneLocked() {
        return this.manager.getViewPane().isLocked();
    }

    private boolean isOverDockbars(Point mousePoint) {
        return this.manager.getLeftBar().getBounds().contains(mousePoint) || this.manager.getRightBar().getBounds().contains(mousePoint) || this.manager.getBottomBar().getBounds().contains(mousePoint);
    }

    public void mouseEntered(Point mousePoint) {
        if (this.mouseOver) {
            return;
        }
        this.mouseOver = true;
        if (this.deactivator != null) {
            this.deactivator.setEnabled(false);
        }
        this.deactivator = null;
    }

    public void mouseExited(Point mousePoint) {
        if (!this.mouseOver) {
            return;
        }
        this.mouseOver = false;
        if (!this.isOverDockbars(mousePoint)) {
            this.deactivator = new Deactivator(this.manager.getActiveDockableId());
            this.deactivator.setEnabled(true);
            this.deactivator.start();
        }
    }

    public void mousePressed(Point mousePoint, boolean mouseOver) {
        if (mouseOver) {
            if (!this.isViewpaneLocked()) {
                this.lockViewpane();
            }
        } else if (!this.isOverDockbars(mousePoint)) {
            this.manager.setActiveDockable((String)null);
        }
    }

    public void lockViewpane() {
        this.manager.getViewPane().setLocked(true);
        this.dispatchDockbarEvent(1);
    }

    private void dispatchDockbarEvent(int type) {
        Dockable dockable = this.manager.getActiveDockable();
        int edge = this.manager.getActiveEdge();
        DockbarEvent evt = new DockbarEvent(dockable, type, edge);
        EventManager.dispatch(evt);
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    private class Deactivator
    extends Thread {
        private String dockableId;
        private boolean enabled;

        private Deactivator(String id) {
            this.dockableId = id;
            this.enabled = true;
        }

        private synchronized void setEnabled(boolean b) {
            this.enabled = b;
        }

        private synchronized boolean isEnabled() {
            return this.enabled;
        }

        public void run() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Log.debug(e.getMessage(), e);
            }
            if (this.isEnabled() && !Utilities.isChanged(this.dockableId, ActivationListener.this.manager.getActiveDockableId()) && !ActivationListener.this.isViewpaneLocked()) {
                ActivationListener.this.manager.setActiveDockable((String)null);
            }
        }
    }
}

