/*
 * EJBQLConnectionEditor.java
 *
 * Created on March 27, 2007, 1:18 PM
 */

package it.businesslogic.ireport.connection.gui;

import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.connection.EJBQLConnection;
import it.businesslogic.ireport.IReportConnectionEditor;
import it.businesslogic.ireport.util.I18n;

/**
 *
 * @author  gtoffoli
 */
public class EJBQLConnectionEditor extends javax.swing.JPanel implements IReportConnectionEditor {
    
    private IReportConnection iReportConnection = null;
    private boolean init = false;
    
    /** Creates new form EJBQLConnectionEditor */
    public EJBQLConnectionEditor() {
        initComponents();
        applyI18n();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanelEJBQL = new javax.swing.JPanel();
        jLabel18 = new javax.swing.JLabel();
        jTextFieldPersistanceUnit = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();

        setLayout(new java.awt.BorderLayout());

        jPanelEJBQL.setLayout(new java.awt.GridBagLayout());

        jLabel18.setText("Persistance Unit Name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 2, 4);
        jPanelEJBQL.add(jLabel18, gridBagConstraints);

        jTextFieldPersistanceUnit.setMargin(new java.awt.Insets(0, 5, 2, 4));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 3, 4);
        jPanelEJBQL.add(jTextFieldPersistanceUnit, gridBagConstraints);

        jLabel1.setText("jLabel1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanelEJBQL.add(jLabel1, gridBagConstraints);

        add(jPanelEJBQL, java.awt.BorderLayout.CENTER);

    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel18;
    private javax.swing.JPanel jPanelEJBQL;
    private javax.swing.JTextField jTextFieldPersistanceUnit;
    // End of variables declaration//GEN-END:variables
    
    
    public void setIReportConnection(IReportConnection c) {
        
        this.iReportConnection = c;
        if (iReportConnection instanceof EJBQLConnection)
        {
            EJBQLConnection con = (EJBQLConnection)iReportConnection;
            this.jTextFieldPersistanceUnit.setText( it.businesslogic.ireport.util.Misc.nvl(con.getProperties().get("PersistenceUnit"), "") ); 
        }
    }

    public IReportConnection getIReportConnection() {
        
        IReportConnection irConn = new EJBQLConnection();

            if (jTextFieldPersistanceUnit.getText().trim().length() != 0)
            {
                irConn.getProperties().put("PersistenceUnit", jTextFieldPersistanceUnit.getText().trim());
            }
            else
            {
                javax.swing.JOptionPane.showMessageDialog(this,
                        I18n.getString("messages.connectionDialog.ejbql.invalidPersistenceUnit","Please specify a valid PersistenceUnit"),
                        I18n.getString("messages.connectionDialog.invalidPersistenceUnitCaption","Invalid PersistenceUnit!"),javax.swing.JOptionPane.WARNING_MESSAGE );
                return null;
            }

        iReportConnection = irConn;
        return iReportConnection;
    }
    
    public void applyI18n(){
                // Start autogenerated code ----------------------
                jLabel18.setText(I18n.getString("connectionDialog.label18","Persistance Unit Name"));
                jLabel1.setText("<html>" + I18n.getString("connectionDialog.textPane2","iReport will search for persistence.xml files within the META-INF directory of any CLASSPATH element"));
    }
    
    
}
