/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scripting.bsh;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.XThis;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.springframework.core.NestedRuntimeException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class BshScriptUtils {
    public static Object createBshObject(String scriptSource, Class[] interfaces) throws EvalError {
        Assert.hasText((String)scriptSource, (String)"Script source must not be empty");
        Assert.notEmpty((Object[])interfaces, (String)"At least one script interface is required");
        Interpreter interpreter = new Interpreter();
        interpreter.eval(scriptSource);
        XThis xt = (XThis)interpreter.eval("return this");
        return Proxy.newProxyInstance(ClassUtils.getDefaultClassLoader(), interfaces, (InvocationHandler)new BshObjectInvocationHandler(xt));
    }

    public static class BshExecutionException
    extends NestedRuntimeException {
        private BshExecutionException(EvalError ex) {
            super("BeanShell script execution failed", (Throwable)ex);
        }
    }

    private static class BshObjectInvocationHandler
    implements InvocationHandler {
        private final XThis xt;

        public BshObjectInvocationHandler(XThis xt) {
            this.xt = xt;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return this.xt.invokeMethod(method.getName(), args);
            }
            catch (EvalError ex) {
                throw new BshExecutionException(ex);
            }
        }
    }
}

