/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.field;

import com.lowagie.text.Font;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.field.RtfField;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfTOCEntry
extends RtfField {
    private static final byte[] TEXT_HIDDEN_ON = "\\v".getBytes();
    private static final byte[] TEXT_HIDDEN_OFF = "\\v0".getBytes();
    private static final byte[] TOC_ENTRY_PAGE_NUMBER = "\\tc".getBytes();
    private static final byte[] TOC_ENTRY_NO_PAGE_NUMBER = "\\tcn".getBytes();
    private String entry = "";
    private boolean showPageNumber = true;

    public RtfTOCEntry(String entry, Font font) {
        super((RtfDocument)null, font);
        if (entry != null) {
            this.entry = entry;
        }
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(TEXT_HIDDEN_ON);
            result.write(RtfBasicElement.OPEN_GROUP);
            if (this.showPageNumber) {
                result.write(TOC_ENTRY_PAGE_NUMBER);
            } else {
                result.write(TOC_ENTRY_NO_PAGE_NUMBER);
            }
            result.write(RtfBasicElement.DELIMITER);
            result.write(this.document.filterSpecialChar(this.entry, true, false).getBytes());
            result.write(RtfBasicElement.CLOSE_GROUP);
            result.write(TEXT_HIDDEN_OFF);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public void setShowPageNumber(boolean showPageNumber) {
        this.showPageNumber = showPageNumber;
    }

    protected byte[] writeFieldInstContent() throws IOException {
        return null;
    }

    protected byte[] writeFieldResultContent() throws IOException {
        return null;
    }
}

