/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.io.IOException;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.xml.JRXmlConstants;

public abstract class JRXmlBaseWriter {
    protected JRXmlWriteHelper writer;

    protected void useWriter(JRXmlWriteHelper aWriter) {
        this.writer = aWriter;
    }

    protected void writeStyle(JRStyle style) throws IOException {
        this.writer.startElement("style");
        this.writer.addEncodedAttribute("name", style.getName());
        this.writer.addAttribute("isDefault", style.isDefault());
        if (style.getStyle() != null) {
            this.writer.addEncodedAttribute("style", style.getStyle().getName());
        } else if (style.getStyleNameReference() != null) {
            this.writer.addEncodedAttribute("style", style.getStyleNameReference());
        }
        this.writer.addAttribute("mode", style.getOwnMode(), JRXmlConstants.getModeMap());
        this.writer.addAttribute("forecolor", style.getOwnForecolor());
        this.writer.addAttribute("backcolor", style.getOwnBackcolor());
        this.writer.addAttribute("pen", style.getOwnPen(), JRXmlConstants.getPenMap());
        this.writer.addAttribute("fill", style.getOwnFill(), JRXmlConstants.getFillMap());
        this.writer.addAttribute("radius", style.getOwnRadius());
        this.writer.addAttribute("scaleImage", style.getOwnScaleImage(), JRXmlConstants.getScaleImageMap());
        this.writer.addAttribute("hAlign", style.getOwnHorizontalAlignment(), JRXmlConstants.getHorizontalAlignMap());
        this.writer.addAttribute("vAlign", style.getOwnVerticalAlignment(), JRXmlConstants.getVerticalAlignMap());
        this.writer.addAttribute("rotation", style.getOwnRotation(), JRXmlConstants.getRotationMap());
        this.writer.addAttribute("lineSpacing", style.getOwnLineSpacing(), JRXmlConstants.getLineSpacingMap());
        this.writer.addAttribute("isStyledText", style.isOwnStyledText());
        this.writer.addEncodedAttribute("pattern", style.getOwnPattern());
        this.writer.addAttribute("isBlankWhenNull", style.isOwnBlankWhenNull());
        this.writer.addAttribute("border", style.getOwnBorder(), JRXmlConstants.getPenMap());
        this.writer.addAttribute("borderColor", style.getOwnBorderColor());
        this.writer.addAttribute("padding", style.getOwnPadding());
        this.writer.addAttribute("topBorder", style.getOwnTopBorder(), JRXmlConstants.getPenMap());
        this.writer.addAttribute("topBorderColor", style.getOwnTopBorderColor());
        this.writer.addAttribute("topPadding", style.getOwnTopPadding());
        this.writer.addAttribute("leftBorder", style.getOwnLeftBorder(), JRXmlConstants.getPenMap());
        this.writer.addAttribute("leftBorderColor", style.getOwnLeftBorderColor());
        this.writer.addAttribute("leftPadding", style.getOwnLeftPadding());
        this.writer.addAttribute("bottomBorder", style.getOwnBottomBorder(), JRXmlConstants.getPenMap());
        this.writer.addAttribute("bottomBorderColor", style.getOwnBottomBorderColor());
        this.writer.addAttribute("bottomPadding", style.getOwnBottomPadding());
        this.writer.addAttribute("rightBorder", style.getOwnRightBorder(), JRXmlConstants.getPenMap());
        this.writer.addAttribute("rightBorderColor", style.getOwnRightBorderColor());
        this.writer.addAttribute("rightPadding", style.getOwnRightPadding());
        this.writer.addEncodedAttribute("fontName", style.getOwnFontName());
        this.writer.addAttribute("fontSize", style.getOwnFontSize());
        this.writer.addAttribute("isBold", style.isOwnBold());
        this.writer.addAttribute("isItalic", style.isOwnItalic());
        this.writer.addAttribute("isUnderline", style.isOwnUnderline());
        this.writer.addAttribute("isStrikeThrough", style.isOwnStrikeThrough());
        this.writer.addEncodedAttribute("pdfFontName", style.getOwnPdfFontName());
        this.writer.addEncodedAttribute("pdfEncoding", style.getOwnPdfEncoding());
        this.writer.addAttribute("isPdfEmbedded", style.isOwnPdfEmbedded());
        if (this.toWriteConditionalStyles()) {
            JRConditionalStyle[] conditionalStyles = style.getConditionalStyles();
            if (!(style instanceof JRConditionalStyle) && conditionalStyles != null) {
                for (int i = 0; i < conditionalStyles.length; ++i) {
                    this.writeConditionalStyle(conditionalStyles[i]);
                }
            }
        }
        this.writer.closeElement();
    }

    protected abstract boolean toWriteConditionalStyles();

    protected void writeConditionalStyle(JRConditionalStyle style) throws IOException {
        this.writer.startElement("conditionalStyle");
        this.writer.writeExpression("conditionExpression", style.getConditionExpression(), false);
        this.writeStyle(style);
        this.writer.closeElement();
    }
}

