/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import net.sf.jasperreports.engine.util.FormatFactory;

public class JRFillContext {
    private Map loadedImages = new HashMap();
    private Map loadedSubreports = new HashMap();
    private boolean usingVirtualizer = false;
    private boolean perPageBoundElements = false;
    private JRPrintPage printPage = null;
    private boolean ignorePagination = false;
    private JRQueryExecuter queryExecuter;
    private JRVirtualizationContext virtualizationContext;
    private FormatFactory masterFormatFactory;
    private Locale masterLocale;
    private TimeZone masterTimeZone;

    public boolean hasLoadedImage(Object source) {
        return this.loadedImages.containsKey(source);
    }

    public JRPrintImage getLoadedImage(Object source) {
        return (JRPrintImage)this.loadedImages.get(source);
    }

    public void registerLoadedImage(Object source, JRPrintImage image) {
        this.loadedImages.put(source, image);
        if (this.usingVirtualizer) {
            this.virtualizationContext.cacheRenderer(image);
        }
    }

    public boolean hasLoadedSubreport(Object source) {
        return this.loadedSubreports.containsKey(source);
    }

    public JasperReport getLoadedSubreport(Object source) {
        return (JasperReport)this.loadedSubreports.get(source);
    }

    public void registerLoadedSubreport(Object source, JasperReport subreport) {
        this.loadedSubreports.put(source, subreport);
    }

    public void setUsingVirtualizer(boolean usingVirtualizer) {
        this.usingVirtualizer = usingVirtualizer;
        if (usingVirtualizer && this.virtualizationContext == null) {
            this.virtualizationContext = new JRVirtualizationContext();
        }
    }

    public boolean isUsingVirtualizer() {
        return this.usingVirtualizer;
    }

    public void setPerPageBoundElements(boolean perPageBoundElements) {
        this.perPageBoundElements = perPageBoundElements;
    }

    public boolean isPerPageBoundElements() {
        return this.perPageBoundElements;
    }

    public void setPrintPage(JRPrintPage page) {
        this.printPage = page;
    }

    public JRPrintPage getPrintPage() {
        return this.printPage;
    }

    public void setIgnorePagination(boolean ignorePagination) {
        this.ignorePagination = ignorePagination;
    }

    public boolean isIgnorePagination() {
        return this.ignorePagination;
    }

    public synchronized void setRunningQueryExecuter(JRQueryExecuter queryExecuter) {
        this.queryExecuter = queryExecuter;
    }

    public synchronized void clearRunningQueryExecuter() {
        this.queryExecuter = null;
    }

    public synchronized boolean cancelRunningQuery() throws JRException {
        if (this.queryExecuter != null) {
            return this.queryExecuter.cancelQuery();
        }
        return false;
    }

    public void ensureMasterPageAvailable() {
        if (this.usingVirtualizer) {
            this.printPage.getElements();
        }
    }

    public JRVirtualizationContext getVirtualizationContext() {
        return this.virtualizationContext;
    }

    public FormatFactory getMasterFormatFactory() {
        return this.masterFormatFactory;
    }

    public void setMasterFormatFactory(FormatFactory masterFormatFactory) {
        this.masterFormatFactory = masterFormatFactory;
    }

    public Locale getMasterLocale() {
        return this.masterLocale;
    }

    public void setMasterLocale(Locale masterLocale) {
        this.masterLocale = masterLocale;
    }

    public TimeZone getMasterTimeZone() {
        return this.masterTimeZone;
    }

    public void setMasterTimeZone(TimeZone masterTimeZone) {
        this.masterTimeZone = masterTimeZone;
    }
}

