/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRQueryChunk;
import net.sf.jasperreports.engine.base.JRBaseQuery;
import net.sf.jasperreports.engine.design.JRDesignQueryChunk;
import net.sf.jasperreports.engine.util.JRQueryChunkHandler;
import net.sf.jasperreports.engine.util.JRQueryParser;

public class JRDesignQuery
extends JRBaseQuery {
    private transient PropertyChangeSupport propSupport;
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_LANGUAGE = "language";
    protected List chunks = new ArrayList();
    private final transient JRQueryChunkHandler chunkAdder = new JRQueryChunkHandler(){

        public void handleParameterChunk(String text) {
            JRDesignQuery.this.addParameterChunk(text);
        }

        public void handleParameterClauseChunk(String text) {
            JRDesignQuery.this.addParameterClauseChunk(text);
        }

        public void handleTextChunk(String text) {
            JRDesignQuery.this.addTextChunk(text);
        }

        public void handleClauseChunk(String[] tokens) {
            JRDesignQuery.this.addClauseChunk(tokens);
        }
    };

    public JRQueryChunk[] getChunks() {
        JRQueryChunk[] chunkArray = null;
        if (this.chunks != null && this.chunks.size() > 0) {
            chunkArray = new JRQueryChunk[this.chunks.size()];
            this.chunks.toArray(chunkArray);
        }
        return chunkArray;
    }

    public void setChunks(List chunks) {
        this.chunks = chunks;
    }

    public void addChunk(JRDesignQueryChunk chunk) {
        this.chunks.add(chunk);
    }

    public void addTextChunk(String text) {
        JRDesignQueryChunk chunk = new JRDesignQueryChunk();
        chunk.setType((byte)1);
        chunk.setText(text);
        this.chunks.add(chunk);
    }

    public void addParameterChunk(String text) {
        JRDesignQueryChunk chunk = new JRDesignQueryChunk();
        chunk.setType((byte)2);
        chunk.setText(text);
        this.chunks.add(chunk);
    }

    public void addParameterClauseChunk(String text) {
        JRDesignQueryChunk chunk = new JRDesignQueryChunk();
        chunk.setType((byte)3);
        chunk.setText(text);
        this.chunks.add(chunk);
    }

    public void addClauseChunk(String[] tokens) {
        JRDesignQueryChunk chunk = new JRDesignQueryChunk();
        chunk.setType((byte)4);
        chunk.setTokens(tokens);
        this.chunks.add(chunk);
    }

    public void setText(String text) {
        this.chunks = new ArrayList();
        JRQueryParser.instance().parse(text, this.chunkAdder);
    }

    public void setLanguage(String language) {
        String oldValue = this.language;
        this.language = language;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_LANGUAGE, oldValue, this.language);
    }

    protected PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propSupport == null) {
            this.propSupport = new PropertyChangeSupport(this);
        }
        return this.propSupport;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPropertyChangeSupport().addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propName, PropertyChangeListener l) {
        this.getPropertyChangeSupport().addPropertyChangeListener(propName, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.getPropertyChangeSupport().removePropertyChangeListener(l);
    }

    public void removePropertyChangeListener(String propName, PropertyChangeListener l) {
        this.getPropertyChangeSupport().removePropertyChangeListener(propName, l);
    }
}

