/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.documentstructure;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.ChartReportElement2;
import it.businesslogic.ireport.ElementGroup;
import it.businesslogic.ireport.FrameReportElement;
import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.chart.gui.ChartPropertiesDialog;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.ValuesDialog;
import it.businesslogic.ireport.gui.docking.GenericDragTargetListener;
import it.businesslogic.ireport.gui.documentstructure.DocumentStructureExportHandler;
import it.businesslogic.ireport.gui.documentstructure.DocumentStructureTreeCellRenderer;
import it.businesslogic.ireport.gui.documentstructure.DocumentStructureTreeNode;
import it.businesslogic.ireport.gui.documentstructure.ReportObjectTreeNode;
import it.businesslogic.ireport.gui.event.ReportBandChangedEvent;
import it.businesslogic.ireport.gui.event.ReportBandsSelectionEvent;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;
import it.businesslogic.ireport.gui.event.ReportElementsSelectionEvent;
import it.businesslogic.ireport.gui.event.ReportFrameActivatedEvent;
import it.businesslogic.ireport.gui.event.ReportFrameActivatedListener;
import it.businesslogic.ireport.gui.event.ReportListener;
import it.businesslogic.ireport.gui.event.ReportObjectsSelectionEvent;
import it.businesslogic.ireport.gui.event.ReportSubDatasetChangedEvent;
import it.businesslogic.ireport.gui.event.ReportSubDatasetChangedListener;
import it.businesslogic.ireport.gui.event.SubDatasetObjectChangedEvent;
import it.businesslogic.ireport.gui.event.SubDatasetObjectChangedListener;
import it.businesslogic.ireport.gui.subdataset.SubDatasetDialog;
import it.businesslogic.ireport.gui.wizard.ReportGroupWizard;
import it.businesslogic.ireport.undo.UnGroupEmentsOperation;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DocumentStructurePanel
extends JPanel
implements ReportListener,
SubDatasetObjectChangedListener,
ReportSubDatasetChangedListener,
LanguageChangedListener,
ReportFrameActivatedListener {
    private boolean dontHandleEvent = false;
    ReportObjectTreeNode fieldsNode = null;
    ReportObjectTreeNode variablesNode = null;
    ReportObjectTreeNode parametersNode = null;
    private JReportFrame oldJReportFrame = null;
    private JReportFrame jReportFrame = null;
    private JLabel jLabelFilters;
    private JMenu jMenuAdd;
    private JMenuItem jMenuItemAddGroup;
    private JMenuItem jMenuItemCopy;
    private JMenuItem jMenuItemCut;
    private JMenuItem jMenuItemDS_chartProperties;
    private JMenuItem jMenuItemDS_copy;
    private JMenuItem jMenuItemDS_cut;
    private JMenuItem jMenuItemDS_delete;
    private JMenuItem jMenuItemDS_paste;
    private JMenuItem jMenuItemDS_properties;
    private JMenuItem jMenuItemDelete;
    private JMenuItem jMenuItemEdit;
    private JMenuItem jMenuItemMoveDown;
    private JMenuItem jMenuItemMoveDownObj;
    private JMenuItem jMenuItemMoveUp;
    private JMenuItem jMenuItemMoveUpObj;
    private JMenuItem jMenuItemNewField;
    private JMenuItem jMenuItemNewSubDataset;
    private JMenuItem jMenuItemNewVariable;
    private JMenuItem jMenuItemParameter;
    private JMenuItem jMenuItemPaste;
    private JMenuItem jMenuItemRefresh;
    private JMenuItem jMenuItemUngroup;
    private JPanel jPanel1;
    private JPopupMenu jPopupMenuDocumentStructure;
    private JPopupMenu jPopupMenuDocumentStructureGroup;
    private JPopupMenu jPopupMenuFields;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator22;
    private JSeparator jSeparator23;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JToggleButton jToggleButtonFilterBuiltinParameters;
    private JToggleButton jToggleButtonFilterBuiltinVariables;
    private JTree jTreeDocument;

    public JReportFrame getJReportFrame() {
        return this.jReportFrame;
    }

    public void setJReportFrame(JReportFrame jReportFrame) {
        this.jReportFrame = jReportFrame;
        this.updateDocumentStructureTree();
        if (jReportFrame != null) {
            this.addObjectsToSelection(jReportFrame.getSelectedObjects());
        }
    }

    public DocumentStructurePanel() {
        this.initComponents();
        DefaultTreeSelectionModel dtsm = (DefaultTreeSelectionModel)this.jTreeDocument.getSelectionModel();
        dtsm.setSelectionMode(4);
        this.jTreeDocument.setDropTarget(new DropTarget(this, new GenericDragTargetListener()));
        DocumentStructureTreeNode rootDoc = new DocumentStructureTreeNode(I18n.getString("document", "Document"));
        this.fieldsNode = new ReportObjectTreeNode("Fields", true);
        this.variablesNode = new ReportObjectTreeNode("Variables", true);
        this.parametersNode = new ReportObjectTreeNode("Parameters", true);
        DefaultTreeModel modelDoc = new DefaultTreeModel(rootDoc);
        this.jTreeDocument.setModel(modelDoc);
        this.jTreeDocument.setCellRenderer(new DocumentStructureTreeCellRenderer());
        MainFrame.getMainInstance().addReportFrameActivatedListener(this);
        this.jTreeDocument.setTransferHandler(new DocumentStructureExportHandler());
        this.jTreeDocument.setDragEnabled(true);
        this.jToggleButtonFilterBuiltinParameters.setSelected(MainFrame.getMainInstance().getProperties().getProperty("documentStructure.showBuiltinParameters", "true").equals("true"));
        this.jToggleButtonFilterBuiltinVariables.setSelected(MainFrame.getMainInstance().getProperties().getProperty("documentStructure.showBuiltinVariables", "true").equals("true"));
    }

    private void initComponents() {
        this.jPopupMenuDocumentStructure = new JPopupMenu();
        this.jMenuItemDS_properties = new JMenuItem();
        this.jMenuItemDS_chartProperties = new JMenuItem();
        this.jSeparator22 = new JSeparator();
        this.jMenuItemMoveUp = new JMenuItem();
        this.jMenuItemMoveDown = new JMenuItem();
        this.jSeparator23 = new JSeparator();
        this.jMenuItemDS_cut = new JMenuItem();
        this.jMenuItemDS_copy = new JMenuItem();
        this.jMenuItemDS_paste = new JMenuItem();
        this.jMenuItemDS_delete = new JMenuItem();
        this.jPopupMenuDocumentStructureGroup = new JPopupMenu();
        this.jMenuItemUngroup = new JMenuItem();
        this.jPopupMenuFields = new JPopupMenu();
        this.jMenuItemEdit = new JMenuItem();
        this.jMenuAdd = new JMenu();
        this.jMenuItemParameter = new JMenuItem();
        this.jMenuItemNewField = new JMenuItem();
        this.jMenuItemNewVariable = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.jMenuItemNewSubDataset = new JMenuItem();
        this.jSeparator5 = new JSeparator();
        this.jMenuItemMoveUpObj = new JMenuItem();
        this.jMenuItemMoveDownObj = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jMenuItemCut = new JMenuItem();
        this.jMenuItemCopy = new JMenuItem();
        this.jMenuItemPaste = new JMenuItem();
        this.jMenuItemDelete = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.jMenuItemAddGroup = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.jMenuItemRefresh = new JMenuItem();
        this.jScrollPane2 = new JScrollPane();
        this.jTreeDocument = new JTree();
        this.jPanel1 = new JPanel();
        this.jLabelFilters = new JLabel();
        this.jToggleButtonFilterBuiltinParameters = new JToggleButton();
        this.jToggleButtonFilterBuiltinVariables = new JToggleButton();
        this.jMenuItemDS_properties.setText("Properties");
        this.jMenuItemDS_properties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemDS_propertiesActionPerformed(evt);
            }
        });
        this.jPopupMenuDocumentStructure.add(this.jMenuItemDS_properties);
        this.jMenuItemDS_chartProperties.setText("Chart properties");
        this.jMenuItemDS_chartProperties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemDS_chartPropertiesActionPerformed(evt);
            }
        });
        this.jPopupMenuDocumentStructure.add(this.jMenuItemDS_chartProperties);
        this.jPopupMenuDocumentStructure.add(this.jSeparator22);
        this.jMenuItemMoveUp.setText("Move up");
        this.jMenuItemMoveUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemMoveUpActionPerformed(evt);
            }
        });
        this.jPopupMenuDocumentStructure.add(this.jMenuItemMoveUp);
        this.jMenuItemMoveDown.setText("Move down");
        this.jMenuItemMoveDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemMoveDownActionPerformed(evt);
            }
        });
        this.jPopupMenuDocumentStructure.add(this.jMenuItemMoveDown);
        this.jPopupMenuDocumentStructure.add(this.jSeparator23);
        this.jMenuItemDS_cut.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/cut.png")));
        this.jMenuItemDS_cut.setText("Cut");
        this.jMenuItemDS_cut.setEnabled(false);
        this.jMenuItemDS_cut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemDS_cutActionPerformed(evt);
            }
        });
        this.jPopupMenuDocumentStructure.add(this.jMenuItemDS_cut);
        this.jMenuItemDS_copy.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/copy.png")));
        this.jMenuItemDS_copy.setText("Copy");
        this.jMenuItemDS_copy.setEnabled(false);
        this.jMenuItemDS_copy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemDS_copyActionPerformed(evt);
            }
        });
        this.jPopupMenuDocumentStructure.add(this.jMenuItemDS_copy);
        this.jMenuItemDS_paste.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/paste.png")));
        this.jMenuItemDS_paste.setText("Paste");
        this.jMenuItemDS_paste.setEnabled(false);
        this.jMenuItemDS_paste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemDS_pasteActionPerformed(evt);
            }
        });
        this.jPopupMenuDocumentStructure.add(this.jMenuItemDS_paste);
        this.jMenuItemDS_delete.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/delete.png")));
        this.jMenuItemDS_delete.setText("Delete");
        this.jMenuItemDS_delete.setEnabled(false);
        this.jMenuItemDS_delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemDS_deleteActionPerformed(evt);
            }
        });
        this.jPopupMenuDocumentStructure.add(this.jMenuItemDS_delete);
        this.jMenuItemUngroup.setText("Ungroup");
        this.jMenuItemUngroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemUngroupActionPerformed(evt);
            }
        });
        this.jPopupMenuDocumentStructureGroup.add(this.jMenuItemUngroup);
        this.jPopupMenuFields.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                DocumentStructurePanel.this.jPopupMenuFieldsPopupMenuWillBecomeVisible(evt);
            }
        });
        this.jMenuItemEdit.setText("Edit");
        this.jMenuItemEdit.setEnabled(false);
        this.jMenuItemEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemEditActionPerformed(evt);
            }
        });
        this.jPopupMenuFields.add(this.jMenuItemEdit);
        this.jMenuAdd.setText("Add...");
        this.jMenuItemParameter.setText("Parameter");
        this.jMenuItemParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemParameterActionPerformed(evt);
            }
        });
        this.jMenuAdd.add(this.jMenuItemParameter);
        this.jMenuItemNewField.setText("Field");
        this.jMenuItemNewField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemNewFieldActionPerformed(evt);
            }
        });
        this.jMenuAdd.add(this.jMenuItemNewField);
        this.jMenuItemNewVariable.setText("Variable");
        this.jMenuItemNewVariable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemNewVariableActionPerformed(evt);
            }
        });
        this.jMenuAdd.add(this.jMenuItemNewVariable);
        this.jMenuAdd.add(this.jSeparator3);
        this.jMenuItemNewSubDataset.setText("Sub dataset");
        this.jMenuItemNewSubDataset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemNewSubDatasetActionPerformed(evt);
            }
        });
        this.jMenuAdd.add(this.jMenuItemNewSubDataset);
        this.jPopupMenuFields.add(this.jMenuAdd);
        this.jPopupMenuFields.add(this.jSeparator5);
        this.jMenuItemMoveUpObj.setText("Move Up");
        this.jMenuItemMoveUpObj.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemMoveUpObjActionPerformed(evt);
            }
        });
        this.jPopupMenuFields.add(this.jMenuItemMoveUpObj);
        this.jMenuItemMoveDownObj.setText("Move Down");
        this.jPopupMenuFields.add(this.jMenuItemMoveDownObj);
        this.jPopupMenuFields.add(this.jSeparator1);
        this.jMenuItemCut.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/cut.png")));
        this.jMenuItemCut.setText("Cut");
        this.jMenuItemCut.setEnabled(false);
        this.jMenuItemCut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemCutActionPerformed(evt);
            }
        });
        this.jPopupMenuFields.add(this.jMenuItemCut);
        this.jMenuItemCopy.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/copy.png")));
        this.jMenuItemCopy.setText("Copy");
        this.jMenuItemCopy.setEnabled(false);
        this.jMenuItemCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemCopyActionPerformed(evt);
            }
        });
        this.jPopupMenuFields.add(this.jMenuItemCopy);
        this.jMenuItemPaste.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/paste.png")));
        this.jMenuItemPaste.setText("Paste");
        this.jMenuItemPaste.setEnabled(false);
        this.jMenuItemPaste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemPasteActionPerformed(evt);
            }
        });
        this.jPopupMenuFields.add(this.jMenuItemPaste);
        this.jMenuItemDelete.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/delete.png")));
        this.jMenuItemDelete.setText("Delete");
        this.jMenuItemDelete.setEnabled(false);
        this.jMenuItemDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemDeleteActionPerformed(evt);
            }
        });
        this.jPopupMenuFields.add(this.jMenuItemDelete);
        this.jPopupMenuFields.add(this.jSeparator2);
        this.jMenuItemAddGroup.setText("Add report group");
        this.jMenuItemAddGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemAddGroupActionPerformed(evt);
            }
        });
        this.jPopupMenuFields.add(this.jMenuItemAddGroup);
        this.jPopupMenuFields.add(this.jSeparator4);
        this.jMenuItemRefresh.setText("Refresh");
        this.jMenuItemRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemRefreshActionPerformed(evt);
            }
        });
        this.jPopupMenuFields.add(this.jMenuItemRefresh);
        this.setLayout(new BorderLayout());
        this.jTreeDocument.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                DocumentStructurePanel.this.jTreeDocumentMousePressed(evt);
            }
        });
        this.jTreeDocument.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent evt) {
                DocumentStructurePanel.this.jTreeDocumentTreeCollapsed(evt);
            }

            public void treeExpanded(TreeExpansionEvent evt) {
                DocumentStructurePanel.this.jTreeDocumentTreeExpanded(evt);
            }
        });
        this.jTreeDocument.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                DocumentStructurePanel.this.jTreeDocumentValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTreeDocument);
        this.add((Component)this.jScrollPane2, "Center");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabelFilters.setText("Filters:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel1.add((Component)this.jLabelFilters, gridBagConstraints);
        this.jToggleButtonFilterBuiltinParameters.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/tree/editor/builtin_parameter.png")));
        this.jToggleButtonFilterBuiltinParameters.setSelected(true);
        this.jToggleButtonFilterBuiltinParameters.setToolTipText("Show / Hide Built-in Parameters");
        this.jToggleButtonFilterBuiltinParameters.setBorder(null);
        this.jToggleButtonFilterBuiltinParameters.setFocusPainted(false);
        this.jToggleButtonFilterBuiltinParameters.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButtonFilterBuiltinParameters.setMaximumSize(new Dimension(22, 22));
        this.jToggleButtonFilterBuiltinParameters.setMinimumSize(new Dimension(22, 22));
        this.jToggleButtonFilterBuiltinParameters.setPreferredSize(new Dimension(22, 22));
        this.jToggleButtonFilterBuiltinParameters.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                DocumentStructurePanel.this.jToggleButtonFilterBuiltinParametersItemStateChanged(evt);
            }
        });
        this.jToggleButtonFilterBuiltinParameters.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jToggleButtonFilterBuiltinParametersActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jToggleButtonFilterBuiltinParameters, new GridBagConstraints());
        this.jToggleButtonFilterBuiltinVariables.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/tree/editor/builtin_variable.png")));
        this.jToggleButtonFilterBuiltinVariables.setSelected(true);
        this.jToggleButtonFilterBuiltinVariables.setToolTipText("Show / Hide Built-in Variables");
        this.jToggleButtonFilterBuiltinVariables.setBorder(null);
        this.jToggleButtonFilterBuiltinVariables.setFocusPainted(false);
        this.jToggleButtonFilterBuiltinVariables.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButtonFilterBuiltinVariables.setMaximumSize(new Dimension(22, 22));
        this.jToggleButtonFilterBuiltinVariables.setMinimumSize(new Dimension(22, 22));
        this.jToggleButtonFilterBuiltinVariables.setPreferredSize(new Dimension(22, 22));
        this.jToggleButtonFilterBuiltinVariables.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jToggleButtonFilterBuiltinVariablesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jToggleButtonFilterBuiltinVariables, gridBagConstraints);
        this.add((Component)this.jPanel1, "Last");
    }

    private void jMenuItemMoveUpObjActionPerformed(ActionEvent evt) {
        TreePath tp = this.jTreeDocument.getSelectionPath();
        if (tp == null) {
            return;
        }
        if (this.getJReportFrame() == null) {
            return;
        }
        Object selectedObject = ((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject();
        SubDataset sd = Misc.getObjectSubDataset(this.getJReportFrame().getReport(), selectedObject);
        if (sd == null) {
            return;
        }
        Vector list = null;
        int objType = 0;
        if (selectedObject instanceof JRField) {
            list = sd.getFields();
            objType = 0;
        } else if (selectedObject instanceof JRParameter) {
            list = sd.getParameters();
            objType = 2;
        } else if (selectedObject instanceof JRVariable) {
            list = sd.getVariables();
            objType = 1;
        }
        if (list != null) {
            int oldIndex = list.indexOf(selectedObject);
            if (oldIndex > 0) {
                list.removeElement(selectedObject);
                list.insertElementAt(selectedObject, oldIndex - 1);
                sd.fireSubDatasetObjectChangedListenerSubDatasetObjectChanged(new SubDatasetObjectChangedEvent(sd, objType, 3, selectedObject, selectedObject));
            }
            this.getJReportFrame().getReport().incrementReportChanges();
        }
    }

    private void jToggleButtonFilterBuiltinParametersItemStateChanged(ItemEvent evt) {
        MainFrame.getMainInstance().getProperties().setProperty("documentStructure.showBuiltinParameters", this.jToggleButtonFilterBuiltinParameters.isSelected() + "");
        List openedPaths = this.getOpenedPaths();
        this.updateReportObjects(this.getJReportFrame(), openedPaths);
        this.updateSubDatasets(openedPaths);
        this.jTreeDocument.updateUI();
    }

    private void jToggleButtonFilterBuiltinVariablesActionPerformed(ActionEvent evt) {
        MainFrame.getMainInstance().getProperties().setProperty("documentStructure.showBuiltinVariables", this.jToggleButtonFilterBuiltinVariables.isSelected() + "");
        List openedPaths = this.getOpenedPaths();
        this.updateReportObjects(this.getJReportFrame(), openedPaths);
        this.updateSubDatasets(openedPaths);
        this.jTreeDocument.updateUI();
    }

    private void jToggleButtonFilterBuiltinParametersActionPerformed(ActionEvent evt) {
    }

    private void jMenuItemAddGroupActionPerformed(ActionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ReportGroupWizard rgw = new ReportGroupWizard();
                rgw.startWizard();
            }
        });
    }

    private void jPopupMenuFieldsPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        JReportFrame jrf = this.getJReportFrame();
        this.jMenuItemMoveUpObj.setVisible(false);
        this.jMenuItemMoveDownObj.setVisible(false);
        this.jSeparator5.setVisible(false);
        if (jrf == null) {
            this.jMenuItemCut.setEnabled(false);
            this.jMenuItemCopy.setEnabled(false);
            this.jMenuItemDelete.setEnabled(false);
            this.jMenuItemPaste.setEnabled(false);
            this.jMenuItemEdit.setEnabled(false);
            this.jMenuItemRefresh.setEnabled(false);
            this.jMenuAdd.setEnabled(false);
            return;
        }
        this.jMenuAdd.setEnabled(true);
        this.jMenuItemRefresh.setEnabled(true);
        TreePath[] paths = this.jTreeDocument.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            this.jMenuItemCut.setEnabled(false);
            this.jMenuItemCopy.setEnabled(false);
            this.jMenuItemDelete.setEnabled(false);
            this.jMenuItemPaste.setEnabled(false);
            this.jMenuItemEdit.setEnabled(false);
            return;
        }
        if (paths.length == 1 && paths[0].getLastPathComponent() instanceof DefaultMutableTreeNode && (((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject() instanceof JRField || ((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject() instanceof JRVariable || ((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject() instanceof JRParameter || ((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject() instanceof SubDataset)) {
            this.jMenuItemEdit.setEnabled(true);
            Object obj = ((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject();
            if (obj instanceof JRVariable && !((JRVariable)obj).isBuiltin() || obj instanceof JRField || obj instanceof JRParameter && !((JRParameter)obj).isBuiltin()) {
                Object previous;
                this.jSeparator5.setVisible(true);
                this.jMenuItemMoveUpObj.setVisible(true);
                this.jMenuItemMoveDownObj.setVisible(true);
                this.jMenuItemMoveUpObj.setEnabled(false);
                this.jMenuItemMoveDownObj.setEnabled(false);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
                if (node.getNextSibling() != null) {
                    this.jMenuItemMoveDownObj.setEnabled(true);
                }
                if (node.getPreviousSibling() != null && ((previous = node.getPreviousSibling().getUserObject()) instanceof JRVariable && !((JRVariable)previous).isBuiltin() || previous instanceof JRField || previous instanceof JRParameter && !((JRParameter)previous).isBuiltin())) {
                    this.jMenuItemMoveUpObj.setEnabled(true);
                }
            }
        } else {
            this.jMenuItemEdit.setEnabled(false);
        }
        if (paths.length > 0) {
            this.jMenuItemCut.setEnabled(true);
            this.jMenuItemCopy.setEnabled(true);
            this.jMenuItemDelete.setEnabled(true);
        } else {
            this.jMenuItemCut.setEnabled(false);
            this.jMenuItemCopy.setEnabled(false);
            this.jMenuItemDelete.setEnabled(false);
        }
        this.jMenuItemPaste.setEnabled(false);
        if (paths.length == 1 && paths[0].getLastPathComponent() instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode dmn = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
            if ((dmn.getUserObject().equals(I18n.getString("gui.library.fields", "Fields")) || dmn.getUserObject() instanceof JRField) && jrf.getMainFrame().getValuesDialog().getClipboardFields().size() > 0) {
                this.jMenuItemPaste.setEnabled(true);
            }
            if ((dmn.getUserObject().equals(I18n.getString("gui.library.variables", "Variables")) || dmn.getUserObject() instanceof JRVariable) && jrf.getMainFrame().getValuesDialog().getClipboardVariables().size() > 0) {
                this.jMenuItemPaste.setEnabled(true);
            }
            if ((dmn.getUserObject().equals(I18n.getString("gui.library.parameters", "Parameters")) || dmn.getUserObject() instanceof JRParameter) && jrf.getMainFrame().getValuesDialog().getClipboardParameters().size() > 0) {
                this.jMenuItemPaste.setEnabled(true);
            }
        }
    }

    private void jMenuItemRefreshActionPerformed(ActionEvent evt) {
        this.updateReportObjects(this.getJReportFrame(), this.getOpenedPaths());
    }

    private void jMenuItemDeleteActionPerformed(ActionEvent evt) {
        JReportFrame jrf = this.getJReportFrame();
        if (jrf == null) {
            return;
        }
        TreePath[] paths = this.jTreeDocument.getSelectionPaths();
        for (int i = 0; i < paths.length && jrf != null; ++i) {
            Report report = jrf.getReport();
            SubDataset sd = report;
            try {
                Object osd;
                if (paths[i].getPath().length == 4 && (osd = ((DefaultMutableTreeNode)paths[i].getPath()[1]).getUserObject()) instanceof SubDataset) {
                    sd = (SubDataset)osd;
                }
                if (!(paths[i].getLastPathComponent() instanceof DefaultMutableTreeNode)) continue;
                Object obj = ((DefaultMutableTreeNode)paths[i].getLastPathComponent()).getUserObject();
                if (obj instanceof JRVariable) {
                    sd.removeVariable((JRVariable)obj);
                }
                if (obj instanceof JRField) {
                    sd.removeField((JRField)obj);
                }
                if (obj instanceof JRParameter) {
                    sd.removeParameter((JRParameter)obj);
                }
                if (!(obj instanceof SubDataset) || JOptionPane.showConfirmDialog(this.jTreeDocument, I18n.getFormattedString("messages.libraryPanel.removingSubdataset", "Do you really want remove subDataset {0} ?", new Object[]{obj})) != 0) continue;
                jrf.getReport().removeSubDataset((SubDataset)obj);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void jMenuItemPasteActionPerformed(ActionEvent evt) {
        JReportFrame jrf = this.getJReportFrame();
        if (jrf == null) {
            return;
        }
        TreePath[] paths = this.jTreeDocument.getSelectionPaths();
        if (paths.length == 1 && paths[0].getLastPathComponent() instanceof DefaultMutableTreeNode) {
            Object osd;
            SubDataset sd = jrf.getReport();
            if (paths[0].getPath().length >= 3 && (osd = ((DefaultMutableTreeNode)paths[0].getPath()[1]).getUserObject()) instanceof SubDataset) {
                sd = (SubDataset)osd;
            }
            ValuesDialog vd = MainFrame.getMainInstance().getValuesDialog();
            DefaultMutableTreeNode dmn = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
            if ((dmn.getUserObject().equals(I18n.getString("gui.library.fields", "Fields")) || dmn.getUserObject() instanceof JRField) && jrf.getMainFrame().getValuesDialog().getClipboardFields().size() > 0) {
                vd.getValuesPanel().duplicateFields(vd.getClipboardFields(), sd);
            }
            if ((dmn.getUserObject().equals(I18n.getString("gui.library.variables", "Variables")) || dmn.getUserObject() instanceof JRVariable) && jrf.getMainFrame().getValuesDialog().getClipboardVariables().size() > 0) {
                vd.getValuesPanel().duplicateVariables(vd.getClipboardVariables(), sd);
            }
            if ((dmn.getUserObject().equals(I18n.getString("gui.library.parameters", "Parameters")) || dmn.getUserObject() instanceof JRParameter) && jrf.getMainFrame().getValuesDialog().getClipboardParameters().size() > 0) {
                vd.getValuesPanel().duplicateParameters(vd.getClipboardParameters(), sd);
            }
        }
    }

    private void jMenuItemCopyActionPerformed(ActionEvent evt) {
        JReportFrame jrf = this.getJReportFrame();
        if (jrf == null) {
            return;
        }
        TreePath[] paths = this.jTreeDocument.getSelectionPaths();
        boolean clearedVariablesClipboard = false;
        boolean clearedParametersClipboard = false;
        boolean clearedFieldsClipboard = false;
        for (int i = 0; i < paths.length && jrf != null; ++i) {
            ValuesDialog vd = MainFrame.getMainInstance().getValuesDialog();
            Report report = jrf.getReport();
            if (!(paths[i].getLastPathComponent() instanceof DefaultMutableTreeNode)) continue;
            Object obj = ((DefaultMutableTreeNode)paths[i].getLastPathComponent()).getUserObject();
            if (obj instanceof JRVariable) {
                if (!clearedVariablesClipboard) {
                    clearedVariablesClipboard = true;
                    vd.getClipboardVariables().removeAllElements();
                }
                vd.getClipboardVariables().add(((JRVariable)obj).cloneMe());
            }
            if (obj instanceof JRField) {
                if (!clearedFieldsClipboard) {
                    clearedFieldsClipboard = true;
                    vd.getClipboardFields().removeAllElements();
                }
                vd.getClipboardFields().add(((JRField)obj).cloneMe());
            }
            if (!(obj instanceof JRParameter)) continue;
            if (!clearedParametersClipboard) {
                clearedParametersClipboard = true;
                vd.getClipboardParameters().removeAllElements();
            }
            vd.getClipboardParameters().add(((JRParameter)obj).cloneMe());
        }
    }

    private void jMenuItemCutActionPerformed(ActionEvent evt) {
        JReportFrame jrf = this.getJReportFrame();
        if (jrf == null) {
            return;
        }
        TreePath[] paths = this.jTreeDocument.getSelectionPaths();
        boolean clearedVariablesClipboard = false;
        boolean clearedParametersClipboard = false;
        boolean clearedFieldsClipboard = false;
        for (int i = 0; i < paths.length && jrf != null; ++i) {
            Object osd;
            ValuesDialog vd = MainFrame.getMainInstance().getValuesDialog();
            Report report = jrf.getReport();
            SubDataset sd = report;
            if (paths[i].getPath().length == 4 && (osd = ((DefaultMutableTreeNode)paths[i].getPath()[1]).getUserObject()) instanceof SubDataset) {
                sd = (SubDataset)osd;
            }
            if (!(paths[i].getLastPathComponent() instanceof DefaultMutableTreeNode)) continue;
            Object obj = ((DefaultMutableTreeNode)paths[i].getLastPathComponent()).getUserObject();
            if (obj instanceof JRVariable) {
                if (!clearedVariablesClipboard) {
                    clearedVariablesClipboard = true;
                    vd.getClipboardVariables().removeAllElements();
                }
                vd.getClipboardVariables().add(((JRVariable)obj).cloneMe());
                sd.removeVariable((JRVariable)obj);
            }
            if (obj instanceof JRField) {
                if (!clearedFieldsClipboard) {
                    clearedFieldsClipboard = true;
                    vd.getClipboardFields().removeAllElements();
                }
                vd.getClipboardFields().add(((JRField)obj).cloneMe());
                sd.removeField((JRField)obj);
            }
            if (!(obj instanceof JRParameter)) continue;
            if (!clearedParametersClipboard) {
                clearedParametersClipboard = true;
                vd.getClipboardParameters().removeAllElements();
            }
            vd.getClipboardParameters().add(((JRParameter)obj).cloneMe());
            sd.removeParameter((JRParameter)obj);
        }
    }

    private void jMenuItemNewSubDatasetActionPerformed(ActionEvent evt) {
        JReportFrame jrf = this.getJReportFrame();
        if (jrf == null) {
            return;
        }
        SubDatasetDialog sdd = new SubDatasetDialog(Misc.frameFromComponent(this), true);
        sdd.setVisible(true);
    }

    private void jMenuItemParameterActionPerformed(ActionEvent evt) {
        JReportFrame jrf = this.getJReportFrame();
        if (jrf == null) {
            return;
        }
        MainFrame.getMainInstance().getValuesDialog().getValuesPanel().newParameter(this.getSelectedSubDataset());
    }

    private void jMenuItemNewVariableActionPerformed(ActionEvent evt) {
        JReportFrame jrf = this.getJReportFrame();
        if (jrf == null) {
            return;
        }
        MainFrame.getMainInstance().getValuesDialog().getValuesPanel().newVariable(this.getSelectedSubDataset());
    }

    private void jMenuItemNewFieldActionPerformed(ActionEvent evt) {
        JReportFrame jrf = this.getJReportFrame();
        if (jrf == null) {
            return;
        }
        MainFrame.getMainInstance().getValuesDialog().getValuesPanel().newField(this.getSelectedSubDataset());
    }

    private void jMenuItemEditActionPerformed(ActionEvent evt) {
        JReportFrame jrf = this.getJReportFrame();
        if (jrf == null) {
            return;
        }
        TreePath[] paths = this.jTreeDocument.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return;
        }
        if (paths.length == 1 && paths[0].getLastPathComponent() instanceof DefaultMutableTreeNode) {
            Object obj = ((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject();
            if (obj instanceof JRVariable) {
                MainFrame.getMainInstance().getValuesDialog().getValuesPanel().modifyVariable((JRVariable)obj, this.getSelectedSubDataset());
            }
            if (obj instanceof JRField) {
                MainFrame.getMainInstance().getValuesDialog().getValuesPanel().modifyField((JRField)obj, this.getSelectedSubDataset());
            }
            if (obj instanceof JRParameter) {
                MainFrame.getMainInstance().getValuesDialog().getValuesPanel().modifyParameter((JRParameter)obj, this.getSelectedSubDataset());
            }
            if (obj instanceof SubDataset) {
                Frame parent = Misc.frameFromComponent(this);
                SubDatasetDialog cd = new SubDatasetDialog(parent, true);
                cd.setSubDataset((SubDataset)obj);
                cd.setVisible(true);
            }
        }
    }

    private void jMenuItemUngroupActionPerformed(ActionEvent evt) {
        DocumentStructureTreeNode elementNode;
        if (this.jTreeDocument.getSelectionCount() > 0 && (elementNode = (DocumentStructureTreeNode)this.jTreeDocument.getSelectionPath().getLastPathComponent()).getUserObject() instanceof ElementGroup) {
            String elementGroupName = ((ElementGroup)elementNode.getUserObject()).getName();
            while (((DocumentStructureTreeNode)elementNode.getParent()).getUserObject() instanceof ElementGroup) {
                elementNode = (DocumentStructureTreeNode)elementNode.getParent();
                elementGroupName = ((ElementGroup)elementNode.getUserObject()).getName() + "." + elementGroupName;
            }
            String newElementGroupName = elementGroupName;
            newElementGroupName = newElementGroupName.lastIndexOf(".") >= 0 ? newElementGroupName.substring(0, newElementGroupName.lastIndexOf(".")) : "";
            UnGroupEmentsOperation undoOp = new UnGroupEmentsOperation(MainFrame.getMainInstance().getActiveReportFrame());
            Vector elements = MainFrame.getMainInstance().getActiveReportFrame().getReport().getElements();
            for (int i = 0; i < elements.size(); ++i) {
                ReportElement element = (ReportElement)elements.elementAt(i);
                String oldElementGroupName = element.getElementGroup();
                if (!element.getElementGroup().startsWith(elementGroupName + ".") && !element.getElementGroup().equals(elementGroupName)) continue;
                String tmpElementGroupName = element.getElementGroup().substring(elementGroupName.length());
                if (tmpElementGroupName.length() == 0) {
                    tmpElementGroupName = newElementGroupName;
                }
                if ((tmpElementGroupName = newElementGroupName + tmpElementGroupName).startsWith(".")) {
                    tmpElementGroupName = tmpElementGroupName.substring(1);
                }
                element.setElementGroup(tmpElementGroupName);
                undoOp.addElement(element, i, i, oldElementGroupName, tmpElementGroupName);
            }
            MainFrame.getMainInstance().getActiveReportFrame().addUndoOperation(undoOp);
            MainFrame.getMainInstance().getActiveReportFrame().fireReportListenerReportElementsChanged(new ReportElementChangedEvent(MainFrame.getMainInstance().getActiveReportFrame(), new Vector(), 1));
        }
    }

    private void jTreeDocumentTreeCollapsed(TreeExpansionEvent evt) {
    }

    private void jTreeDocumentTreeExpanded(TreeExpansionEvent evt) {
    }

    private void jMenuItemDS_deleteActionPerformed(ActionEvent evt) {
        MainFrame.getMainInstance().getActiveReportFrame().deleteSelectedElements();
    }

    private void jMenuItemDS_pasteActionPerformed(ActionEvent evt) {
        MainFrame.getMainInstance().getActiveReportFrame().paste();
    }

    private void jMenuItemDS_copyActionPerformed(ActionEvent evt) {
        MainFrame.getMainInstance().getActiveReportFrame().copy();
    }

    private void jMenuItemDS_cutActionPerformed(ActionEvent evt) {
        MainFrame.getMainInstance().getActiveReportFrame().cut();
    }

    private void jMenuItemMoveDownActionPerformed(ActionEvent evt) {
        if (MainFrame.getMainInstance().getActiveReportFrame() != null) {
            JReportFrame jrf = MainFrame.getMainInstance().getActiveReportFrame();
            jrf.moveDown();
            if (jrf.getSelectedElements().size() > 0) {
                this.updateDocumentStructureTree(jrf);
            }
        }
    }

    private void jMenuItemMoveUpActionPerformed(ActionEvent evt) {
        if (MainFrame.getMainInstance().getActiveReportFrame() != null) {
            JReportFrame jrf = MainFrame.getMainInstance().getActiveReportFrame();
            jrf.moveUp();
            this.jTreeDocument.updateUI();
            this.printSelectedPaths("Prima");
            if (jrf.getSelectedElements().size() > 0) {
                this.updateDocumentStructureTree(jrf);
            }
            this.printSelectedPaths("Dopo");
        }
    }

    private void jMenuItemDS_chartPropertiesActionPerformed(ActionEvent evt) {
        if (MainFrame.getMainInstance().getActiveReportFrame() != null) {
            DocumentStructureTreeNode elementNode;
            JReportFrame jrf = MainFrame.getMainInstance().getActiveReportFrame();
            if (this.jTreeDocument.getSelectionCount() > 0 && (elementNode = (DocumentStructureTreeNode)this.jTreeDocument.getSelectionPath().getLastPathComponent()).getUserObject() instanceof ChartReportElement2) {
                ChartPropertiesDialog cpd = new ChartPropertiesDialog((Frame)MainFrame.getMainInstance(), true);
                cpd.setChartElement((ChartReportElement2)elementNode.getUserObject());
                cpd.setVisible(true);
            }
        }
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    private void jMenuItemDS_propertiesActionPerformed(ActionEvent evt) {
        MainFrame.getMainInstance().getElementPropertiesDialog().setVisible(true);
        MainFrame.getMainInstance().getElementPropertiesDialog().updateSelection();
    }

    private void jTreeDocumentValueChanged(TreeSelectionEvent evt) {
        if (this.isDontHandleEvent()) {
            return;
        }
        if (MainFrame.getMainInstance().getActiveReportFrame() != null) {
            try {
                JReportFrame jrf = MainFrame.getMainInstance().getActiveReportFrame();
                Vector<ReportElement> elementsToSelect = new Vector<ReportElement>();
                Vector<Band> bandsToSelect = new Vector<Band>();
                Vector<Object> objectsToSelect = new Vector<Object>();
                TreePath[] path = this.jTreeDocument.getSelectionPaths();
                for (int i = 0; path != null && i < path.length; ++i) {
                    if (!(path[i].getLastPathComponent() instanceof ReportObjectTreeNode)) continue;
                    ReportObjectTreeNode elementNode = (ReportObjectTreeNode)path[i].getLastPathComponent();
                    if (elementNode.getUserObject() instanceof Band) {
                        bandsToSelect.addElement((Band)elementNode.getUserObject());
                    }
                    if (elementNode.getUserObject() instanceof JRParameter || elementNode.getUserObject() instanceof JRField || elementNode.getUserObject() instanceof JRVariable) {
                        objectsToSelect.addElement(elementNode.getUserObject());
                    }
                    if (!(elementNode.getUserObject() instanceof ReportElement)) continue;
                    elementsToSelect.addElement((ReportElement)elementNode.getUserObject());
                }
                jrf.getSelectedElements().clear();
                Enumeration e = elementsToSelect.elements();
                while (e.hasMoreElements()) {
                    jrf.addSelectedElement((ReportElement)e.nextElement(), false);
                }
                if (elementsToSelect.size() > 0) {
                    jrf.setSelectedBands(new Vector());
                    jrf.setSelectedObjects(new Vector());
                } else {
                    jrf.setSelectedObjects(objectsToSelect);
                    jrf.setSelectedBands(bandsToSelect);
                }
                jrf.fireSelectionChangedEvent();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void jTreeDocumentMousePressed(MouseEvent evt) {
        if (evt.getButton() == 3) {
            if (MainFrame.getMainInstance().getActiveReportFrame() != null) {
                JReportFrame jrf = MainFrame.getMainInstance().getActiveReportFrame();
                Misc.ensurePathIsSelected(this.jTreeDocument.getPathForLocation(evt.getX(), evt.getY()), this.jTreeDocument);
                if (this.jTreeDocument.getSelectionCount() > 0 && this.jTreeDocument.getSelectionPath().getLastPathComponent() instanceof DocumentStructureTreeNode && this.jTreeDocument.getModel().getRoot() != this.jTreeDocument.getSelectionPath().getLastPathComponent()) {
                    DocumentStructureTreeNode elementNode = (DocumentStructureTreeNode)this.jTreeDocument.getSelectionPath().getLastPathComponent();
                    if (elementNode.getUserObject() instanceof ReportElement) {
                        this.jMenuItemDS_chartProperties.setVisible(elementNode.getUserObject() instanceof ChartReportElement2);
                        this.jPopupMenuDocumentStructure.show(this.jTreeDocument, evt.getPoint().x, evt.getPoint().y);
                    } else if (elementNode.getUserObject() instanceof Band) {
                        this.jPopupMenuFields.show(this.jTreeDocument, evt.getPoint().x, evt.getPoint().y);
                    } else if (elementNode.getUserObject() instanceof ElementGroup) {
                        this.jPopupMenuDocumentStructureGroup.show(this.jTreeDocument, evt.getPoint().x, evt.getPoint().y);
                    }
                } else {
                    this.jPopupMenuFields.show(this.jTreeDocument, evt.getPoint().x, evt.getPoint().y);
                }
            }
        } else if (evt.getButton() == 1 && evt.getClickCount() == 2) {
            JReportFrame jrf;
            TreePath[] paths = this.jTreeDocument.getSelectionPaths();
            if (this.getJReportFrame() == null || paths == null || paths.length == 0) {
                return;
            }
            if (paths.length == 1 && paths[0].getLastPathComponent() instanceof DefaultMutableTreeNode) {
                Object obj = ((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject();
                if (obj instanceof JRVariable) {
                    MainFrame.getMainInstance().getValuesDialog().getValuesPanel().modifyVariable((JRVariable)obj, this.getSelectedSubDataset());
                }
                if (obj instanceof JRField) {
                    MainFrame.getMainInstance().getValuesDialog().getValuesPanel().modifyField((JRField)obj, this.getSelectedSubDataset());
                }
                if (obj instanceof JRParameter) {
                    MainFrame.getMainInstance().getValuesDialog().getValuesPanel().modifyParameter((JRParameter)obj, this.getSelectedSubDataset());
                }
                if (obj instanceof SubDataset) {
                    Frame parent = Misc.frameFromComponent(this);
                    SubDatasetDialog cd = new SubDatasetDialog(parent, true);
                    cd.setSubDataset((SubDataset)obj);
                    cd.setVisible(true);
                }
            }
            if ((jrf = this.getJReportFrame()).getSelectedElements().size() > 0) {
                MainFrame.getMainInstance().getElementPropertiesDialog().setVisible(true);
            }
        }
    }

    public void printSelectedPaths(String prefix) {
        try {
            Enumeration<TreePath> enum_extended_paths = this.jTreeDocument.getExpandedDescendants(new TreePath(new Object[]{this.jTreeDocument.getModel().getRoot()}));
            if (enum_extended_paths != null) {
                while (enum_extended_paths.hasMoreElements()) {
                    TreePath treePath = enum_extended_paths.nextElement();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private List getOpenedPaths() {
        ArrayList<String> openedPaths = null;
        Object root = this.jTreeDocument.getModel().getRoot();
        this.jTreeDocument.updateUI();
        try {
            openedPaths = new ArrayList<String>();
            Enumeration<TreePath> enum_extended_paths = this.jTreeDocument.getExpandedDescendants(new TreePath(new Object[]{this.jTreeDocument.getModel().getRoot()}));
            if (enum_extended_paths != null) {
                while (enum_extended_paths.hasMoreElements()) {
                    TreePath path = enum_extended_paths.nextElement();
                    if (!path.getPath()[0].equals(root) || !(path.getLastPathComponent() instanceof ReportObjectTreeNode)) continue;
                    Object[] objects = path.getPath();
                    for (int i = 0; i < objects.length - 1; ++i) {
                        ((ReportObjectTreeNode)objects[i + 1]).setParent((ReportObjectTreeNode)objects[i]);
                    }
                    String nodePath = ((ReportObjectTreeNode)path.getLastPathComponent()).getNodeId();
                    if (openedPaths.contains(nodePath)) continue;
                    openedPaths.add(nodePath);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return openedPaths;
    }

    public void updateDocumentStructureTree() {
        this.updateDocumentStructureTree(this.getJReportFrame());
    }

    public void updateDocumentStructureTree(JReportFrame jrf) {
        List openedPaths = this.getOpenedPaths();
        if (jrf != this.oldJReportFrame) {
            if (this.oldJReportFrame != null) {
                this.oldJReportFrame.setOpenedNodesDocumentStructure(openedPaths);
            }
            if (jrf != null) {
                openedPaths = jrf.getOpenedNodesDocumentStructure();
            }
        }
        this.setDontHandleEvent(true);
        ((DocumentStructureTreeNode)this.jTreeDocument.getModel().getRoot()).removeAllChildren();
        ((DefaultTreeModel)this.jTreeDocument.getModel()).reload();
        if (jrf != null) {
            this.updateReportObjects(jrf, openedPaths);
            this.updateSubDatasets(openedPaths);
            Enumeration bands = jrf.getReport().getBands().elements();
            while (bands.hasMoreElements()) {
                Band band = (Band)bands.nextElement();
                DocumentStructureTreeNode bandNode = new DocumentStructureTreeNode(band);
                ((DocumentStructureTreeNode)this.jTreeDocument.getModel().getRoot()).add(bandNode);
                Enumeration elements = jrf.getReport().getElements().elements();
                while (elements.hasMoreElements()) {
                    ReportElement element = (ReportElement)elements.nextElement();
                    if (element.getBand() != band) continue;
                    String elementGroup = element.getElementGroup();
                    try {
                        if (element.getParentElement() != null) {
                            DocumentStructureTreeNode parentNode = this.findElementTreeNode(element.getParentElement(), true);
                            if (parentNode == null) continue;
                            this.addElementToGroup(parentNode, elementGroup, element, openedPaths);
                            if (openedPaths == null || !openedPaths.contains(parentNode.getNodeId())) continue;
                            this.expandPath(parentNode);
                            continue;
                        }
                        this.addElementToGroup(bandNode, elementGroup, element, openedPaths);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (openedPaths == null || !openedPaths.contains(bandNode.getNodeId())) continue;
                this.expandPath(bandNode);
            }
            this.setDontHandleEvent(false);
            this.reportElementsSelectionChanged(new ReportElementsSelectionEvent(jrf, jrf.getSelectedElements()));
        }
        this.oldJReportFrame = jrf;
        this.jTreeDocument.updateUI();
    }

    public void addElementToGroup(DocumentStructureTreeNode parentNode, String subGroup, ReportElement element, List openedPaths) {
        if (subGroup.equals("")) {
            DocumentStructureTreeNode newNode = new DocumentStructureTreeNode(element);
            parentNode.add(newNode);
            if (openedPaths != null && openedPaths.contains(newNode.getNodeId())) {
                this.expandPath(newNode);
            }
            return;
        }
        String levelGroupName = "";
        if (subGroup.indexOf(".") >= 0) {
            levelGroupName = subGroup.substring(0, subGroup.indexOf("."));
            subGroup = subGroup.substring(subGroup.indexOf(".") + 1);
        } else {
            levelGroupName = subGroup;
            subGroup = "";
        }
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            ElementGroup ge;
            DocumentStructureTreeNode dmtn = (DocumentStructureTreeNode)parentNode.getChildAt(i);
            if (dmtn.getUserObject() == null || !(dmtn.getUserObject() instanceof ElementGroup) || !(ge = (ElementGroup)dmtn.getUserObject()).getName().equals(levelGroupName)) continue;
            this.addElementToGroup(dmtn, subGroup, element, openedPaths);
            return;
        }
        DocumentStructureTreeNode dmtn = new DocumentStructureTreeNode(new ElementGroup(levelGroupName));
        parentNode.add(dmtn);
        this.addElementToGroup(dmtn, subGroup, element, openedPaths);
        if (openedPaths != null && openedPaths.contains(dmtn.getNodeId())) {
            this.expandPath(dmtn);
        }
    }

    public void expandPath(ReportObjectTreeNode node) {
        try {
            if (node.getParent() != null) {
                this.expandPath((ReportObjectTreeNode)node.getParent());
            }
            this.jTreeDocument.expandPath(new TreePath(node.getPath()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void reportBandChanged(ReportBandChangedEvent evt) {
        this.updateDocumentStructureTree(evt.getJReportFrame());
    }

    public void reportElementsChanged(ReportElementChangedEvent evt) {
        if (evt.getType() == 3) {
            block0: for (int ir = 0; ir < evt.getElements().size(); ++ir) {
                ReportElement re = (ReportElement)evt.getElements().elementAt(ir);
                DocumentStructureTreeNode node = this.findElementTreeNode(re, true);
                if (node != null) continue;
                node = this.findElementTreeNode(re, false);
                if (node == null) {
                    return;
                }
                node.removeFromParent();
                DocumentStructureTreeNode root = (DocumentStructureTreeNode)this.jTreeDocument.getModel().getRoot();
                for (int i = 0; i < root.getChildCount(); ++i) {
                    DocumentStructureTreeNode bandNode;
                    if (!(root.getChildAt(i) instanceof DocumentStructureTreeNode) || (bandNode = (DocumentStructureTreeNode)root.getChildAt(i)).getUserObject() != re.band) continue;
                    bandNode.add(node);
                    this.setDontHandleEvent(true);
                    if (evt.getJReportFrame().getSelectedElements().contains(re)) {
                        this.jTreeDocument.getSelectionModel().addSelectionPath(new TreePath(new Object[]{root, bandNode, node}));
                    }
                    this.setDontHandleEvent(false);
                    continue block0;
                }
            }
            this.jTreeDocument.updateUI();
        } else if (evt.getType() == 1) {
            this.updateDocumentStructureTree(MainFrame.getMainInstance().getActiveReportFrame());
            this.jTreeDocument.updateUI();
        } else if (evt.getType() == 2) {
            this.updateDocumentStructureTree(MainFrame.getMainInstance().getActiveReportFrame());
            this.jTreeDocument.updateUI();
        }
    }

    public void reportElementsSelectionChanged(ReportElementsSelectionEvent evt) {
        DocumentStructureTreeNode enode;
        if (evt.getCrosstabReportElement() != null) {
            return;
        }
        if (this.isDontHandleEvent()) {
            return;
        }
        this.setDontHandleEvent(true);
        TreePath[] path = this.jTreeDocument.getSelectionPaths();
        if (path != null && evt.getSelectedElements() != null && evt.getSelectedElements().size() == 0 && (!(path[0].getLastPathComponent() instanceof DocumentStructureTreeNode) || ((DocumentStructureTreeNode)path[0].getLastPathComponent()).getUserObject() instanceof Band || ((DocumentStructureTreeNode)path[0].getLastPathComponent()).getUserObject() instanceof ElementGroup || (DocumentStructureTreeNode)path[0].getLastPathComponent() == this.jTreeDocument.getModel().getRoot())) {
            this.setDontHandleEvent(false);
            return;
        }
        this.jTreeDocument.getSelectionModel().clearSelection();
        Vector v = evt.getSelectedElements();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            ReportElement re = (ReportElement)e.nextElement();
            enode = this.findElementTreeNode(re, true);
            if (enode == null) continue;
            this.jTreeDocument.getSelectionModel().addSelectionPath(new TreePath(enode.getPath()));
        }
        if (v.size() == 0) {
            v = MainFrame.getMainInstance().getActiveReportFrame().getSelectedBands();
            e = v.elements();
            while (e.hasMoreElements()) {
                Band band = (Band)e.nextElement();
                enode = this.findBandTreeNode(band);
                if (enode == null) continue;
                this.jTreeDocument.getSelectionModel().addSelectionPath(new TreePath(enode.getPath()));
            }
        }
        this.setDontHandleEvent(false);
    }

    public DocumentStructureTreeNode findElementTreeNode(ReportElement re, boolean searchInYourBandOnly) {
        DocumentStructureTreeNode root = (DocumentStructureTreeNode)this.jTreeDocument.getModel().getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DocumentStructureTreeNode newchild;
            if (!(root.getChildAt(i) instanceof DocumentStructureTreeNode)) continue;
            DocumentStructureTreeNode bandNode = (DocumentStructureTreeNode)root.getChildAt(i);
            if (searchInYourBandOnly && bandNode.getUserObject() != re.band || (newchild = this.findElementInTreeNode(bandNode, re)) == null) continue;
            return newchild;
        }
        return null;
    }

    public DocumentStructureTreeNode findBandTreeNode(Band band) {
        DocumentStructureTreeNode root = (DocumentStructureTreeNode)this.jTreeDocument.getModel().getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DocumentStructureTreeNode bandNode;
            if (!(root.getChildAt(i) instanceof DocumentStructureTreeNode) || (bandNode = (DocumentStructureTreeNode)root.getChildAt(i)).getUserObject() != band) continue;
            return bandNode;
        }
        return null;
    }

    public DocumentStructureTreeNode findElementInTreeNode(DocumentStructureTreeNode parentNode, ReportElement re) {
        for (int k = 0; k < parentNode.getChildCount(); ++k) {
            DocumentStructureTreeNode newchild;
            DocumentStructureTreeNode child = (DocumentStructureTreeNode)parentNode.getChildAt(k);
            if (child.getUserObject() == re) {
                return child;
            }
            if (re.getElementGroup().equals("") && re.getParentElement() == null || !(child.getUserObject() instanceof ElementGroup) && !(child.getUserObject() instanceof FrameReportElement) || (newchild = this.findElementInTreeNode(child, re)) == null) continue;
            return newchild;
        }
        return null;
    }

    public boolean isDontHandleEvent() {
        return this.dontHandleEvent;
    }

    public void setDontHandleEvent(boolean dontHandleEvent) {
        this.dontHandleEvent = dontHandleEvent;
    }

    public void applyI18n() {
        this.jMenuItemDS_chartProperties.setText(I18n.getString("documentStructurePanel.menuItemDS_chartProperties", "Chart properties"));
        this.jMenuItemUngroup.setText(I18n.getString("documentStructurePanel.menuItemUngroup", "Ungroup"));
        this.jMenuItemDS_cut.setText(I18n.getString("cut", "Cut"));
        this.jMenuItemDS_copy.setText(I18n.getString("copy", "Copy"));
        this.jMenuItemDS_paste.setText(I18n.getString("paste", "Paste"));
        this.jMenuItemDS_delete.setText(I18n.getString("delete", "Delete"));
        this.jMenuItemMoveUp.setText(I18n.getString("moveUp", "Move up"));
        this.jMenuItemMoveDown.setText(I18n.getString("moveDown", "Move down"));
        this.jMenuItemDS_properties.setText(I18n.getString("properties", "Properties"));
        this.jMenuItemDS_cut.setText(I18n.getString("cut", "Cut"));
        this.jMenuItemDS_copy.setText(I18n.getString("copy", "Copy"));
        this.jMenuItemDS_paste.setText(I18n.getString("paste", "Paste"));
        this.jMenuItemDS_delete.setText(I18n.getString("delete", "Delete"));
        this.jMenuItemMoveUp.setText(I18n.getString("moveUp", "Move up"));
        this.jMenuItemMoveDown.setText(I18n.getString("moveDown", "Move down"));
        this.jMenuItemDS_properties.setText(I18n.getString("properties", "Properties"));
        ((DefaultMutableTreeNode)this.jTreeDocument.getModel().getRoot()).setUserObject(I18n.getString("document", "Document"));
        this.fieldsNode.setUserObject(I18n.getString("gui.library.fields", "Fields"));
        this.variablesNode.setUserObject(I18n.getString("gui.library.variables", "Variables"));
        this.parametersNode.setUserObject(I18n.getString("gui.library.parameters", "Parameters"));
        this.jMenuItemAddGroup.setText(I18n.getString("newReportGroupWizard", "New report group wizard"));
        this.jLabelFilters.setText(I18n.getString("documentStructurePanel.filters", "Filters:"));
        this.jMenuItemMoveUpObj.setText(I18n.getString("moveUp", "Move up"));
        this.jMenuItemMoveDownObj.setText(I18n.getString("moveDown", "Move down"));
        this.jToggleButtonFilterBuiltinParameters.setText(I18n.getString("documentStructurePanel.tooltipParametersFilter", "Show / Hide Built-in Parameters"));
        this.jToggleButtonFilterBuiltinVariables.setText(I18n.getString("documentStructurePanel.tooltipVariablesFilter", "Show / Hide Built-in Variables"));
    }

    public void setCutCopyEnabled(boolean enabled) {
        this.jMenuItemDS_cut.setEnabled(enabled);
        this.jMenuItemDS_copy.setEnabled(enabled);
        this.jMenuItemDS_delete.setEnabled(enabled);
    }

    public void setPasteEnebled(boolean enabled) {
        this.jMenuItemDS_paste.setEnabled(enabled);
    }

    public void reportBandsSelectionChanged(ReportBandsSelectionEvent evt) {
    }

    public void setSelectedObject(Object obj) {
        DefaultMutableTreeNode mtd = Misc.findNodeWithUserObject(obj, (TreeNode)this.jTreeDocument.getModel().getRoot());
        if (mtd != null) {
            TreePath path = new TreePath(mtd.getPath());
            this.jTreeDocument.setSelectionPath(path);
            this.jTreeDocument.scrollPathToVisible(path);
        }
    }

    public void updateReportObjects(JReportFrame jrf, List openedNodeIds) {
        this.fieldsNode.removeAllChildren();
        this.parametersNode.removeAllChildren();
        this.variablesNode.removeAllChildren();
        if (jrf == null) {
            return;
        }
        Enumeration e = jrf.getReport().getFields().elements();
        if (((DocumentStructureTreeNode)this.jTreeDocument.getModel().getRoot()).getIndex(this.parametersNode) == -1) {
            ((DocumentStructureTreeNode)this.jTreeDocument.getModel().getRoot()).add(this.parametersNode);
        }
        if (((DocumentStructureTreeNode)this.jTreeDocument.getModel().getRoot()).getIndex(this.fieldsNode) == -1) {
            ((DocumentStructureTreeNode)this.jTreeDocument.getModel().getRoot()).add(this.fieldsNode);
        }
        if (((DocumentStructureTreeNode)this.jTreeDocument.getModel().getRoot()).getIndex(this.variablesNode) == -1) {
            ((DocumentStructureTreeNode)this.jTreeDocument.getModel().getRoot()).add(this.variablesNode);
        }
        while (e.hasMoreElements()) {
            this.fieldsNode.add(new ReportObjectTreeNode(e.nextElement()));
        }
        if (openedNodeIds != null && openedNodeIds.contains(this.fieldsNode.getNodeId())) {
            this.expandPath(this.fieldsNode);
        }
        e = jrf.getReport().getParameters().elements();
        boolean showBuiltInParams = MainFrame.getMainInstance().getProperties().getProperty("documentStructure.showBuiltinParameters", "true").equals("true");
        while (e.hasMoreElements()) {
            JRParameter param = (JRParameter)e.nextElement();
            if (param.isBuiltin() && !showBuiltInParams) continue;
            this.parametersNode.add(new ReportObjectTreeNode(param));
        }
        if (openedNodeIds != null && openedNodeIds.contains(this.parametersNode.getNodeId())) {
            this.expandPath(this.parametersNode);
        }
        e = jrf.getReport().getVariables().elements();
        boolean showBuiltInPVars = MainFrame.getMainInstance().getProperties().getProperty("documentStructure.showBuiltinVariables", "true").equals("true");
        while (e.hasMoreElements()) {
            JRVariable var = (JRVariable)e.nextElement();
            if (var.isBuiltin() && !showBuiltInPVars) continue;
            this.variablesNode.add(new ReportObjectTreeNode(var));
        }
        if (openedNodeIds != null && openedNodeIds.contains(this.variablesNode.getNodeId())) {
            this.expandPath(this.variablesNode);
        }
    }

    private SubDataset getSelectedSubDataset() {
        Object osd;
        JReportFrame jrf = this.getJReportFrame();
        if (jrf == null) {
            return null;
        }
        SubDataset sd = jrf.getReport();
        TreePath[] paths = this.jTreeDocument.getSelectionPaths();
        if (paths != null && paths.length == 1 && paths[0].getLastPathComponent() instanceof DefaultMutableTreeNode && paths[0].getPath().length >= 2 && (osd = ((DefaultMutableTreeNode)paths[0].getPath()[1]).getUserObject()) instanceof SubDataset) {
            sd = (SubDataset)osd;
        }
        return sd;
    }

    public void subDatasetObjectChanged(SubDatasetObjectChangedEvent evt) {
        block14: {
            block13: {
                if (evt != null) {
                    if (evt.getAction() == 1) {
                        this.jTreeDocument.updateUI();
                        return;
                    }
                }
                List list = this.getSelectedObjects();
                if (evt != null && evt.getSource() instanceof Report) {
                    this.updateReportObjects(this.getJReportFrame(), this.getOpenedPaths());
                } else {
                    this.updateSubDatasetNode(evt.getSource(), this.getOpenedPaths());
                }
                this.addObjectsToSelection(list);
                this.jTreeDocument.updateUI();
                if (evt.getAction() == 2) break block13;
                if (evt.getAction() != 3) break block14;
            }
            TreePath[] paths = this.jTreeDocument.getSelectionPaths();
            ArrayList<TreePath> pp = new ArrayList<TreePath>();
            block0: for (int i = 0; paths != null && i < paths.length; ++i) {
                Object obj = ((DefaultMutableTreeNode)paths[i].getLastPathComponent()).getUserObject();
                DefaultMutableTreeNode uNode = Misc.findNodeWithUserObject(obj, (TreeNode)this.jTreeDocument.getModel().getRoot());
                if (uNode == null) {
                    pp.add(paths[i]);
                    continue;
                }
                TreeNode[] realPath = ((DefaultTreeModel)this.jTreeDocument.getModel()).getPathToRoot(uNode);
                Object[] assumedPath = paths[i].getPath();
                if (realPath == null || realPath.length != assumedPath.length) {
                    pp.add(paths[i]);
                }
                for (int k = 0; k < realPath.length; ++k) {
                    if (realPath[k] == assumedPath[k]) continue;
                    pp.add(paths[i]);
                    continue block0;
                }
            }
            if (pp.size() > 0) {
                TreePath[] delPaths = new TreePath[pp.size()];
                for (int i = 0; i < pp.size(); ++i) {
                    delPaths[i] = (TreePath)pp.get(i);
                }
                this.jTreeDocument.getSelectionModel().removeSelectionPaths(delPaths);
            }
            this.jTreeDocumentValueChanged(null);
        }
    }

    public List getSelectedObjects() {
        TreePath[] paths = this.jTreeDocument.getSelectionPaths();
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; paths != null && i < paths.length; ++i) {
            list.add(((DefaultMutableTreeNode)paths[i].getLastPathComponent()).getUserObject());
        }
        return list;
    }

    public void addObjectsToSelection(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            DefaultMutableTreeNode mtd = Misc.findNodeWithUserObject(obj, (TreeNode)this.jTreeDocument.getModel().getRoot());
            if (mtd == null) continue;
            this.jTreeDocument.addSelectionPath(new TreePath(mtd.getPath()));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void reportSubDatasetChanged(ReportSubDatasetChangedEvent evt) {
        block10: {
            DefaultMutableTreeNode root;
            block12: {
                block11: {
                    block9: {
                        root = (DefaultMutableTreeNode)this.jTreeDocument.getModel().getRoot();
                        if (evt.getAction() != 2) break block9;
                        if (evt.getObjectType() != 1) break block9;
                        int lastDatasourceIndex = 3;
                        for (lastDatasourceIndex = 3; root.getChildCount() > lastDatasourceIndex && ((DefaultMutableTreeNode)root.getChildAt(lastDatasourceIndex)).getUserObject() instanceof SubDataset; ++lastDatasourceIndex) {
                        }
                        for (int i = 0; i < evt.getElements().size(); ++lastDatasourceIndex, ++i) {
                            ReportObjectTreeNode subDatasetNode = new ReportObjectTreeNode(evt.getElements().elementAt(i));
                            root.insert(subDatasetNode, lastDatasourceIndex);
                            this.updateSubDatasetNode(subDatasetNode, null);
                        }
                        this.jTreeDocument.updateUI();
                        break block10;
                    }
                    if (evt.getAction() != 1) break block11;
                    if (evt.getObjectType() == 1) break block12;
                }
                if (evt.getAction() == 8) {
                    if (evt.getObjectType() == 1) {
                        this.jTreeDocument.updateUI();
                    }
                }
                break block10;
            }
            Object subDatasetNode = null;
            int i = 0;
            while (true) {
                if (i < evt.getElements().size()) {
                } else {
                    this.jTreeDocument.updateUI();
                    break;
                }
                for (int k = 0; k < root.getChildCount(); ++k) {
                    if (((DefaultMutableTreeNode)root.getChildAt(k)).getUserObject() != evt.getElements().elementAt(i)) continue;
                    root.remove(k);
                    break;
                }
                ++i;
            }
        }
        if (evt.getAction() == 1) {
            this.jTreeDocumentValueChanged(null);
        }
    }

    public void updateSubDatasetNode(SubDataset subDataset, List openedNodeIds) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.jTreeDocument.getModel().getRoot();
        for (int k = 0; k < root.getChildCount(); ++k) {
            if (((DefaultMutableTreeNode)root.getChildAt(k)).getUserObject() != subDataset) continue;
            ReportObjectTreeNode rotn = (ReportObjectTreeNode)root.getChildAt(k);
            this.updateSubDatasetNode(rotn, openedNodeIds);
            if (openedNodeIds != null && openedNodeIds.contains(rotn.getNodeId())) {
                this.expandPath(rotn);
            }
            return;
        }
    }

    public void updateSubDatasetNode(ReportObjectTreeNode subDatasetNode, List openedNodeIds) {
        ReportObjectTreeNode dsFieldsNode = null;
        ReportObjectTreeNode dsVariablesNode = null;
        ReportObjectTreeNode dsParametersNode = null;
        SubDataset subDataset = (SubDataset)subDatasetNode.getUserObject();
        if (subDatasetNode.getChildCount() == 0) {
            dsParametersNode = new ReportObjectTreeNode(I18n.getString("gui.library.parameters", "Parameters"), true);
            subDatasetNode.add(dsParametersNode);
            dsFieldsNode = new ReportObjectTreeNode(I18n.getString("gui.library.fields", "Fields"), true);
            subDatasetNode.add(dsFieldsNode);
            dsVariablesNode = new ReportObjectTreeNode(I18n.getString("gui.library.variables", "Variables"), true);
            subDatasetNode.add(dsVariablesNode);
        } else {
            dsParametersNode = (ReportObjectTreeNode)subDatasetNode.getChildAt(0);
            dsFieldsNode = (ReportObjectTreeNode)subDatasetNode.getChildAt(1);
            dsVariablesNode = (ReportObjectTreeNode)subDatasetNode.getChildAt(2);
        }
        dsFieldsNode.removeAllChildren();
        dsVariablesNode.removeAllChildren();
        dsParametersNode.removeAllChildren();
        Enumeration e = subDataset.getFields().elements();
        while (e.hasMoreElements()) {
            dsFieldsNode.add(new ReportObjectTreeNode(e.nextElement()));
        }
        if (openedNodeIds != null && openedNodeIds.contains(dsFieldsNode.getNodeId())) {
            this.expandPath(dsFieldsNode);
        }
        e = subDataset.getParameters().elements();
        boolean showBuiltInParams = MainFrame.getMainInstance().getProperties().getProperty("documentStructure.showBuiltinParameters", "true").equals("true");
        while (e.hasMoreElements()) {
            JRParameter param = (JRParameter)e.nextElement();
            if (param.isBuiltin() && !showBuiltInParams) continue;
            dsParametersNode.add(new ReportObjectTreeNode(param));
        }
        if (openedNodeIds != null && openedNodeIds.contains(dsParametersNode.getNodeId())) {
            this.expandPath(dsParametersNode);
        }
        e = subDataset.getVariables().elements();
        boolean showBuiltInPVars = MainFrame.getMainInstance().getProperties().getProperty("documentStructure.showBuiltinVariables", "true").equals("true");
        while (e.hasMoreElements()) {
            JRVariable var = (JRVariable)e.nextElement();
            if (var.isBuiltin() && !showBuiltInPVars) continue;
            dsVariablesNode.add(new ReportObjectTreeNode(var));
        }
        if (openedNodeIds != null && openedNodeIds.contains(dsVariablesNode.getNodeId())) {
            this.expandPath(dsVariablesNode);
        }
    }

    public void updateSubDatasets(List openedPaths) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.jTreeDocument.getModel().getRoot();
        for (int k = 0; k < root.getChildCount(); ++k) {
            if (!(((DefaultMutableTreeNode)root.getChildAt(k)).getUserObject() instanceof SubDataset)) continue;
            root.remove(k);
            --k;
        }
        JReportFrame jrf = this.getJReportFrame();
        if (jrf != null) {
            int lastDatasourceIndex = 3;
            for (int i = 0; i < jrf.getReport().getSubDatasets().size(); ++i) {
                ReportObjectTreeNode subDatasetNode = new ReportObjectTreeNode(jrf.getReport().getSubDatasets().elementAt(i));
                root.insert(subDatasetNode, lastDatasourceIndex);
                this.updateSubDatasetNode(subDatasetNode, openedPaths);
                ++lastDatasourceIndex;
                if (openedPaths == null || !openedPaths.contains(subDatasetNode.getNodeId())) continue;
                this.expandPath(subDatasetNode);
            }
        }
    }

    public void reportFrameActivated(ReportFrameActivatedEvent evt) {
        this.setJReportFrame(evt.getReportFrame());
    }

    public void reportObjectsSelectionChanged(ReportObjectsSelectionEvent evt) {
    }
}

