/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class TextAreaCellRenderer
extends JTextPane
implements ListCellRenderer {
    private Color selectionBackground;
    private Color background;
    Style methodStyle = null;
    Style returnTypeStyle = null;

    public TextAreaCellRenderer(JList list) {
        this.selectionBackground = list.getSelectionBackground();
        this.background = list.getBackground();
        DefaultStyledDocument doc = new DefaultStyledDocument();
        this.setDocument(doc);
        this.methodStyle = doc.addStyle("methodStyle", null);
        StyleConstants.setBold(this.methodStyle, true);
        this.returnTypeStyle = doc.addStyle("returnType", null);
        StyleConstants.setForeground(this.returnTypeStyle, Color.gray);
    }

    public Component getListCellRendererComponent(JList list, Object object, int index, boolean isSelected, boolean cellHasFocus) {
        String s = (String)object;
        this.setText("");
        StyledDocument doc = (StyledDocument)this.getDocument();
        try {
            doc.insertString(doc.getLength(), s.substring(0, s.indexOf("(")), this.methodStyle);
            doc.insertString(doc.getLength(), s.substring(s.indexOf("("), s.lastIndexOf(")") + 1), null);
            doc.insertString(doc.getLength(), s.substring(s.lastIndexOf(")") + 1), this.returnTypeStyle);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.setBackground(isSelected ? this.selectionBackground : this.background);
        return this;
    }
}

