/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import javax.servlet.http.HttpServletRequest;
import org.springframework.core.Ordered;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;

public abstract class AbstractHandlerMapping
extends WebApplicationObjectSupport
implements HandlerMapping,
Ordered {
    private int order = Integer.MAX_VALUE;
    private Object defaultHandler;
    private HandlerInterceptor[] interceptors;

    public final void setOrder(int order) {
        this.order = order;
    }

    public final int getOrder() {
        return this.order;
    }

    public final void setDefaultHandler(Object defaultHandler) {
        this.defaultHandler = defaultHandler;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Default mapping to handler [" + this.defaultHandler + "]"));
        }
    }

    protected final Object getDefaultHandler() {
        return this.defaultHandler;
    }

    public final void setInterceptors(HandlerInterceptor[] interceptors) {
        this.interceptors = interceptors;
    }

    public final HandlerExecutionChain getHandler(HttpServletRequest request) throws Exception {
        Object handler = this.getHandlerInternal(request);
        if (handler == null) {
            handler = this.defaultHandler;
        }
        if (handler == null) {
            return null;
        }
        if (handler instanceof String) {
            String handlerName = (String)handler;
            handler = this.getApplicationContext().getBean(handlerName);
        }
        return new HandlerExecutionChain(handler, this.interceptors);
    }

    protected abstract Object getHandlerInternal(HttpServletRequest var1) throws Exception;
}

