/*
 * Decompiled with CFR 0.152.
 */
package com.digitprop.tonic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JToggleButton;
import javax.swing.border.Border;

public class OptionalMatteBorder
implements Border {
    private boolean drawBorder = false;
    private Color color;
    private int insets;

    public OptionalMatteBorder(Color color, int insets) {
        this.color = color;
        this.insets = insets;
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(this.insets + 1, this.insets + 1, this.insets + 2, this.insets + 2);
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void setDrawBorder(boolean drawBorder) {
        this.drawBorder = drawBorder;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.drawBorder) {
            boolean shift = false;
            boolean drawPressed = false;
            if (c instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)c;
                drawPressed = b.getModel().isPressed() || b instanceof JToggleButton && ((JToggleButton)b).isSelected();
            }
            g.setColor(this.color);
            if (drawPressed) {
                g.drawRect(x + 1, y + 1, width - 2, width - 2);
            } else {
                g.drawRect(x, y, width - 2, height - 2);
            }
        }
    }
}

