/*
 * Decompiled with CFR 0.152.
 */
package uk.co.wilson.net;

import java.io.IOException;
import java.io.InterruptedIOException;

public abstract class MinMLThreadPool {
    protected final int minWorkers;
    protected final int maxWorkers;
    protected final int workerIdleLife;
    protected boolean serverActive = true;
    private int liveWorkerCount = 0;
    private int workingWorkerCount = 0;
    protected static final boolean debug = false;

    public MinMLThreadPool(int minWorkers, int maxWorkers, int workerIdleLife) {
        this.minWorkers = Math.max(minWorkers, 1);
        this.maxWorkers = Math.max(this.minWorkers, maxWorkers);
        this.workerIdleLife = workerIdleLife;
    }

    public void start() {
        this.getNewWorker().run();
    }

    public abstract void shutDown() throws IOException;

    protected abstract Worker makeNewWorker();

    protected abstract void setTimeout(int var1);

    private Worker getNewWorker() {
        if (this.liveWorkerCount++ == this.minWorkers) {
            this.setTimeout(this.workerIdleLife);
        }
        return this.makeNewWorker();
    }

    private synchronized void startWork() {
        if (++this.workingWorkerCount == this.liveWorkerCount && this.liveWorkerCount < this.maxWorkers) {
            Thread workerThread = new Thread(this.getNewWorker());
            workerThread.setDaemon(false);
            workerThread.setName("Thread Pool worker thread");
            workerThread.start();
        }
    }

    private synchronized void endWork() {
        --this.workingWorkerCount;
    }

    private synchronized boolean workerMustDie() {
        if (this.liveWorkerCount > this.minWorkers && this.liveWorkerCount != this.workingWorkerCount + 1) {
            this.workerDies();
            return true;
        }
        return false;
    }

    private synchronized void workerDies() {
        if (--this.liveWorkerCount == this.minWorkers) {
            this.setTimeout(0);
        }
        if (this.serverActive && this.liveWorkerCount < this.minWorkers) {
            new Thread(this.getNewWorker()).start();
        }
    }

    protected abstract class Worker
    implements Runnable {
        protected Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            block18: while (true) {
                try {
                    while (true) {
                        try {
                            Object resource = this.getResource();
                            try {
                                try {
                                    MinMLThreadPool.this.startWork();
                                    Thread.yield();
                                    this.process(resource);
                                }
                                catch (Exception e) {
                                    this.processingException(e);
                                }
                                continue block18;
                            }
                            finally {
                                try {
                                    this.dispose(resource);
                                }
                                catch (IOException e) {}
                                continue block18;
                                finally {
                                    MinMLThreadPool.this.endWork();
                                    continue block18;
                                }
                            }
                        }
                        catch (InterruptedIOException e) {
                            if (!MinMLThreadPool.this.workerMustDie()) continue;
                            return;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    this.operatingException(e);
                    MinMLThreadPool.this.workerDies();
                    return;
                }
            }
        }

        protected void processingException(Exception e) {
        }

        protected void operatingException(Exception e) {
        }

        protected abstract Object getResource() throws Exception;

        protected abstract void dispose(Object var1) throws Exception;

        protected abstract void process(Object var1) throws Exception;
    }
}

