/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla;

import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mondrian.olap.Axis;
import mondrian.olap.Cell;
import mondrian.olap.Connection;
import mondrian.olap.DriverManager;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.MondrianException;
import mondrian.olap.Position;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.Result;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnection;
import mondrian.util.SAXHandler;
import mondrian.util.SAXWriter;
import mondrian.xmla.DataSourcesConfig;
import mondrian.xmla.Enumeration;
import mondrian.xmla.PropertyDefinition;
import mondrian.xmla.Rowset;
import mondrian.xmla.RowsetDefinition;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlaMediator {
    private static final boolean DRILLTHROUGH_EXTENDS_CONTEXT = true;
    private static final Logger LOGGER = Logger.getLogger((Class)XmlaMediator.class);
    private static final String XSD_NS = "http://www.w3.org/2001/XMLSchema";
    private static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XMLA_NS = "urn:schemas-microsoft-com:xml-analysis";
    private static final String XMLA_MDDATASET_NS = "urn:schemas-microsoft-com:xml-analysis:mddataset";
    private static final String XMLA_ROWSET_NS = "urn:schemas-microsoft-com:xml-analysis:rowset";
    static ThreadLocal threadServletContext = new ThreadLocal();
    static Map dataSourcesMap = new HashMap();

    public static void initDataSourcesMap(DataSourcesConfig.DataSources dataSources) {
        HashMap<String, DataSourcesConfig.DataSource> map = new HashMap<String, DataSourcesConfig.DataSource>();
        for (int i = 0; i < dataSources.dataSources.length; ++i) {
            DataSourcesConfig.DataSource ds = dataSources.dataSources[i];
            if (map.containsKey(ds.getDataSourceName())) {
                throw Util.newError("duplicated data source name '" + ds.getDataSourceName() + "'");
            }
            map.put(ds.getDataSourceName(), ds);
        }
        dataSourcesMap = Collections.unmodifiableMap(map);
    }

    public void process(String request, Writer response) {
        block7: {
            Document document;
            DocumentBuilder documentBuilder;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            try {
                documentBuilder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw Util.newError(e, "Error processing '" + request + "'");
            }
            try {
                document = documentBuilder.parse(new InputSource(new StringReader(request)));
            }
            catch (SAXException e) {
                throw Util.newError(e, "Error processing '" + request + "'");
            }
            catch (IOException e) {
                throw Util.newError(e, "Error processing '" + request + "'");
            }
            Element documentElement = document.getDocumentElement();
            try {
                this.process(documentElement, new SAXHandler(new SAXWriter(response)));
            }
            catch (SAXException e) {
                if (!LOGGER.isDebugEnabled()) break block7;
                LOGGER.debug((Object)("Request " + request + " failed"), (Throwable)e);
            }
        }
    }

    public void process(Element element, SAXHandler saxHandler) throws SAXException {
        saxHandler.startDocument();
        this.processEnvelope(element, saxHandler);
        saxHandler.endDocument();
    }

    private void processEnvelope(Element element, SAXHandler saxHandler) throws SAXException {
        String tagName = element.getLocalName();
        Util.assertTrue(tagName.equals("Envelope"));
        saxHandler.startElement("SOAP-ENV:Envelope", new String[]{"xmlns:SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV:encodingStyle", "http://schemas.xmlsoap.org/soap/encoding/"});
        saxHandler.startElement("SOAP-ENV:Body");
        this.processBody(this.firstElement(element, "Body"), saxHandler);
        saxHandler.endElement();
        saxHandler.endElement();
    }

    private void processBody(Element element, SAXHandler saxHandler) {
        String tagName = element.getLocalName();
        Util.assertTrue(tagName.equals("Body"));
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!(node instanceof Element)) continue;
            this.processRequest((Element)node, saxHandler);
        }
    }

    private void processRequest(Element element, SAXHandler saxHandler) {
        String tagName = element.getLocalName();
        if (tagName.equals("Discover")) {
            this.discover(element, saxHandler);
        } else if (tagName.equals("Execute")) {
            this.execute(element, saxHandler);
        } else {
            throw Util.newError("Element <" + tagName + "> not supported");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(Element execute, SAXHandler saxHandler) {
        Element command = this.firstElement(execute, "Command");
        if (command == null) {
            throw Util.newError("<Command> parameter is required");
        }
        String statement = this.firstElementCDATA(command, "Statement");
        if (statement == null) {
            throw Util.newError("<Statement> parameter is required");
        }
        Properties properties = this.getProperties(execute);
        boolean isDrillThrough = false;
        String upperStatement = statement.toUpperCase();
        int dtOffset = upperStatement.indexOf("DRILLTHROUGH");
        int slOffset = upperStatement.indexOf("SELECT");
        if (dtOffset != -1 && dtOffset < slOffset) {
            String format = properties.getProperty(PropertyDefinition.Format.name);
            if ("Tabular".compareToIgnoreCase(format) == 0) {
                isDrillThrough = true;
            } else {
                throw Util.newError("Must set property 'Format' to 'Tabular' for DrillThrough");
            }
        }
        try {
            saxHandler.startElement("ExecuteResponse", new String[]{"xmlns", XMLA_NS});
            saxHandler.startElement("return", new String[]{"xmlns:xsi", XSI_NS, "xmlns:xsd", XSD_NS});
            saxHandler.startElement("root", new String[]{"xmlns", isDrillThrough ? XMLA_ROWSET_NS : XMLA_MDDATASET_NS});
            saxHandler.startElement("xsd:schema", new String[]{"xmlns:xsd", XSD_NS});
            saxHandler.endElement();
            try {
                if (isDrillThrough) {
                    StringBuffer dtStatement = new StringBuffer();
                    dtStatement.append(statement.substring(0, dtOffset));
                    dtStatement.append(statement.substring(dtOffset + "DRILLTHROUGH".length()));
                    this.executeDrillThroughQuery(dtStatement.toString(), properties).unparse(saxHandler);
                } else {
                    this.executeQuery(statement, properties).unparse(saxHandler);
                }
            }
            catch (RuntimeException re) {
                saxHandler.completeBeforeElement("root");
                this.reportXmlaError(saxHandler, re);
            }
            finally {
                saxHandler.endElement();
                saxHandler.endElement();
                saxHandler.endElement();
            }
        }
        catch (SAXException e) {
            throw Util.newError(e, "Error while processing execute request");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private TabularRowSet executeDrillThroughQuery(String statement, Properties properties) {
        TabularRowSet rowset;
        block28: {
            Query query;
            Connection connection = XmlaMediator.getConnection(properties);
            Result result = connection.execute(query = connection.parseQuery(statement));
            Cell dtCell = result.getCell(new int[]{0, 0});
            if (!dtCell.canDrillThrough()) {
                throw Util.newError("Cannot do DillThrough operation on the cell");
            }
            String dtSql = dtCell.getDrillThroughSQL(true);
            rowset = null;
            java.sql.Connection conn = null;
            Statement stmt = null;
            ResultSet rs = null;
            conn = ((RolapConnection)connection).getDataSource().getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(dtSql);
            rowset = new TabularRowSet(rs);
            Object var14_12 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ignored) {
                // empty catch block
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException ignored) {
                // empty catch block
            }
            try {
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
                break block28;
            }
            catch (SQLException ignored) {}
            break block28;
            {
                catch (SQLException sqle) {
                    Util.newError(sqle, "Error while executing DrillThrough sql '" + dtSql + "'");
                    Object var14_13 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (SQLException ignored) {
                        // empty catch block
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException ignored) {
                        // empty catch block
                    }
                    try {
                        if (conn != null && !conn.isClosed()) {
                            conn.close();
                        }
                        break block28;
                    }
                    catch (SQLException ignored) {}
                }
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ignored) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException ignored) {
                    // empty catch block
                }
                try {
                    if (conn != null && !conn.isClosed()) {
                        conn.close();
                    }
                }
                catch (SQLException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return rowset;
    }

    private MDDataSet executeQuery(String statement, Properties properties) {
        String formatName = properties.getProperty(PropertyDefinition.Format.name);
        Enumeration.Format format = Enumeration.Format.getValue(formatName);
        String axisFormatName = properties.getProperty(PropertyDefinition.AxisFormat.name);
        Enumeration.AxisFormat axisFormat = Enumeration.AxisFormat.getValue(axisFormatName);
        Connection connection = XmlaMediator.getConnection(properties);
        Query query = connection.parseQuery(statement);
        Result result = connection.execute(query);
        return new MDDataSet(result, format, axisFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discover(Element discover, SAXHandler saxHandler) {
        String requestType = this.firstElementCDATA(discover, "RequestType");
        if (requestType == null) {
            throw Util.newError("<RequestType> parameter is required");
        }
        HashMap restrictionsProperties = this.getRestrictions(discover);
        Properties propertyProperties = this.getProperties(discover);
        RowsetDefinition rowsetDefinition = RowsetDefinition.getValue(requestType);
        Rowset rowset = rowsetDefinition.getRowset(restrictionsProperties, propertyProperties);
        try {
            saxHandler.startElement("DiscoverResponse", new String[]{"xmlns", XMLA_NS});
            saxHandler.startElement("return");
            saxHandler.startElement("root", new String[]{"xmlns", XMLA_ROWSET_NS});
            saxHandler.startElement("xsd:schema", new String[]{"xmlns:xsd", XSD_NS, "targetNamespace", XMLA_ROWSET_NS, "xmlns:xsi", XSI_NS, "xmlns:sql", "urn:schemas-microsoft-com:xml-sql", "elementFormDefault", "qualified"});
            saxHandler.endElement();
            try {
                rowset.unparse(saxHandler);
            }
            catch (RuntimeException re) {
                saxHandler.completeBeforeElement("root");
                this.reportXmlaError(saxHandler, re);
            }
            finally {
                saxHandler.endElement();
                saxHandler.endElement();
                saxHandler.endElement();
            }
        }
        catch (SAXException e) {
            throw Util.newError(e, "Error while processing '" + requestType + "' discovery request");
        }
    }

    private void reportXmlaError(SAXHandler saxHandler, Exception exception) throws SAXException {
        Throwable throwable = XmlaMediator.gotoRootThrowable(exception);
        saxHandler.startElement("Messages");
        saxHandler.startElement("Error", new String[]{"ErrorCode", throwable.getClass().getName(), "Description", throwable.getMessage(), "Source", "Mondrian", "Help", ""});
        saxHandler.endElement();
        saxHandler.endElement();
    }

    private HashMap getRestrictions(Element discover) {
        Element restrictions = this.firstElement(discover, "Restrictions");
        if (restrictions == null) {
            throw Util.newError("<Restrictions> parameter is required (but may be empty)");
        }
        Element restrictionList = this.firstElement(restrictions, "RestrictionList");
        HashMap<String, Object> restrictionsMap = new HashMap<String, Object>();
        if (restrictionList != null) {
            NodeList childNodes = restrictionList.getChildNodes();
            int n = childNodes.getLength();
            for (int i = 0; i < n; ++i) {
                Node childNode = childNodes.item(i);
                if (!(childNode instanceof Element)) continue;
                Element childElement = (Element)childNode;
                String childTag = childElement.getLocalName();
                Object childValue = this.getCDATA2(childElement);
                restrictionsMap.put(childTag, childValue);
            }
        }
        return restrictionsMap;
    }

    private Properties getProperties(Element method) {
        Element properties = this.firstElement(method, "Properties");
        if (properties == null) {
            throw Util.newError("<Properties> parameter is required (but may be epmty)");
        }
        Element propertyList = this.firstElement(properties, "PropertyList");
        Properties propertyProperties = new Properties();
        if (propertyList != null) {
            NodeList childNodes = propertyList.getChildNodes();
            int n = childNodes.getLength();
            for (int i = 0; i < n; ++i) {
                Node childNode = childNodes.item(i);
                if (!(childNode instanceof Element)) continue;
                Element childElement = (Element)childNode;
                String childTag = childElement.getLocalName();
                String childValue = this.getCDATA(childElement);
                propertyProperties.setProperty(childTag, childValue);
            }
        }
        return propertyProperties;
    }

    static Connection getConnection(Properties properties) {
        String dataSourceInfo = properties.getProperty(PropertyDefinition.DataSourceInfo.name);
        if (!dataSourcesMap.containsKey(dataSourceInfo)) {
            throw Util.newError("no data source is configured with name '" + dataSourceInfo + "'");
        }
        DataSourcesConfig.DataSource ds = (DataSourcesConfig.DataSource)((Object)dataSourcesMap.get(dataSourceInfo));
        Util.PropertyList connectProperties = Util.parseConnectString(ds.getDataSourceInfo());
        String catalog = properties.getProperty(PropertyDefinition.Catalog.name);
        if (catalog != null) {
            connectProperties.put("CatalogName", catalog);
        }
        ServletContext servletContext = (ServletContext)threadServletContext.get();
        return DriverManager.getConnection(connectProperties, servletContext, false);
    }

    static Throwable gotoRootThrowable(Throwable throwable) {
        Throwable rootThrowable = throwable.getCause();
        if (rootThrowable != null && rootThrowable instanceof MondrianException) {
            return XmlaMediator.gotoRootThrowable(rootThrowable);
        }
        return throwable;
    }

    private Element firstElement(Element element, String tagName) {
        NodeList elements = element.getElementsByTagNameNS("*", tagName);
        for (int i = 0; i < elements.getLength(); ++i) {
            Node node = elements.item(i);
            if (!(node instanceof Element)) continue;
            return (Element)node;
        }
        return null;
    }

    private String firstElementCDATA(Element element, String tagName) {
        Element child = this.firstElement(element, tagName);
        if (child == null) {
            return null;
        }
        return this.getCDATA(child);
    }

    private String getCDATA(Element child) {
        child.normalize();
        NodeList childNodes = child.getChildNodes();
        switch (childNodes.getLength()) {
            case 0: {
                return "";
            }
            case 1: {
                Text grandChild = (Text)childNodes.item(0);
                return grandChild.getData();
            }
        }
        StringBuffer sb = new StringBuffer();
        int n = childNodes.getLength();
        for (int i = 0; i < n; ++i) {
            sb.append(childNodes.item(i).toString());
        }
        return sb.toString();
    }

    private Object getCDATA2(Element child) {
        child.normalize();
        NodeList childNodes = child.getChildNodes();
        if (XmlaMediator.valuesExist(childNodes)) {
            ArrayList<String> list = new ArrayList<String>();
            int n = childNodes.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = childNodes.item(i);
                if (!(node instanceof Element) || !node.getLocalName().equals("Value")) continue;
                list.add(this.getCDATA((Element)node));
            }
            return list.toArray(new String[0]);
        }
        return this.getCDATA(child);
    }

    private static boolean valuesExist(NodeList childNodes) {
        int n = childNodes.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = childNodes.item(i);
            if (!(node instanceof Element) || !node.getLocalName().equals("Value")) continue;
            return true;
        }
        return false;
    }

    private static String normalizeNumricString(String numericStr) {
        int index = numericStr.indexOf(46);
        if (index > 0) {
            boolean found = false;
            int p = numericStr.length();
            char c = numericStr.charAt(p - 1);
            while (c == '0') {
                found = true;
                c = numericStr.charAt(--p - 1);
            }
            if (c == '.') {
                --p;
            }
            if (found) {
                return numericStr.substring(0, p);
            }
        }
        return numericStr;
    }

    static class MDDataSet {
        private final Result result;
        private final Enumeration.Format format;
        private final Enumeration.AxisFormat axisFormat;
        private static final String[] cellProps = new String[]{"Value", "FmtValue", "FormatString"};
        private static final String[] cellPropLongs = new String[]{Property.VALUE.name, Property.FORMATTED_VALUE.name, Property.FORMAT_STRING.name};
        private static final String[] props = new String[]{"UName", "Caption", "LName", "LNum", "DisplayInfo"};
        private static final String[] propLongs = new String[]{Property.MEMBER_UNIQUE_NAME.name, Property.MEMBER_CAPTION.name, Property.LEVEL_UNIQUE_NAME.name, Property.LEVEL_NUMBER.name, "DISPLAY_INFO"};
        private static final String[] realPropLongs = new String[]{Property.MEMBER_UNIQUE_NAME.name, Property.MEMBER_CAPTION.name, Property.LEVEL_UNIQUE_NAME.name, Property.LEVEL_NUMBER.name, Property.CHILDREN_CARDINALITY.name};

        public MDDataSet(Result result, Enumeration.Format format, Enumeration.AxisFormat axisFormat) {
            this.result = result;
            this.format = format;
            this.axisFormat = axisFormat;
        }

        public void unparse(SAXHandler saxHandler) throws SAXException {
            if (this.format != Enumeration.Format.Multidimensional) {
                throw new UnsupportedOperationException("<Format>: only 'Multidimensional' currently supported");
            }
            this.olapInfo(saxHandler);
            this.axes(saxHandler);
            this.cellData(saxHandler);
        }

        private void olapInfo(SAXHandler saxHandler) throws SAXException {
            saxHandler.startElement("OlapInfo");
            saxHandler.startElement("CubeInfo");
            saxHandler.startElement("Cube");
            saxHandler.startElement("CubeName");
            saxHandler.characters(this.result.getQuery().getCube().getName());
            saxHandler.endElement();
            saxHandler.endElement();
            saxHandler.endElement();
            saxHandler.startElement("AxesInfo");
            Axis[] axes = this.result.getAxes();
            this.axisInfo(saxHandler, this.result.getSlicerAxis(), "SlicerAxis");
            for (int i = 0; i < axes.length; ++i) {
                this.axisInfo(saxHandler, axes[i], "Axis" + i);
            }
            saxHandler.endElement();
            saxHandler.startElement("CellInfo");
            saxHandler.element("Value", new String[]{"name", "VALUE"});
            saxHandler.element("FmtValue", new String[]{"name", "FORMATTED_VALUE"});
            saxHandler.element("FormatString", new String[]{"name", "FORMAT_STRING"});
            saxHandler.endElement();
            saxHandler.endElement();
        }

        private void axisInfo(SAXHandler saxHandler, Axis axis, String axisName) throws SAXException {
            Hierarchy[] hierarchies;
            saxHandler.startElement("AxisInfo", new String[]{"name", axisName});
            if (axis.positions.length > 0) {
                Position position = axis.positions[0];
                hierarchies = new Hierarchy[position.members.length];
                for (int j = 0; j < position.members.length; ++j) {
                    Member member = position.members[j];
                    hierarchies[j] = member.getHierarchy();
                }
            } else {
                hierarchies = new Hierarchy[]{};
            }
            for (int j = 0; j < hierarchies.length; ++j) {
                saxHandler.startElement("HierarchyInfo", new String[]{"name", hierarchies[j].getName()});
                for (int k = 0; k < props.length; ++k) {
                    saxHandler.element(props[k], new String[]{"name", hierarchies[j].getUniqueName() + ".[" + propLongs[k] + "]"});
                }
                saxHandler.endElement();
            }
            saxHandler.endElement();
        }

        private void axes(SAXHandler saxHandler) throws SAXException {
            if (this.axisFormat != Enumeration.AxisFormat.TupleFormat) {
                throw new UnsupportedOperationException("<AxisFormat>: only 'TupleFormat' currently supported");
            }
            saxHandler.startElement("Axes");
            this.axis(saxHandler, this.result.getSlicerAxis(), "SlicerAxis");
            Axis[] axes = this.result.getAxes();
            for (int i = 0; i < axes.length; ++i) {
                this.axis(saxHandler, axes[i], "Axis" + i);
            }
            saxHandler.endElement();
        }

        private void axis(SAXHandler saxHandler, Axis axis, String axisName) throws SAXException {
            saxHandler.startElement("Axis", new String[]{"name", axisName});
            saxHandler.startElement("Tuples");
            Position[] positions = axis.positions;
            for (int j = 0; j < positions.length; ++j) {
                Position position = positions[j];
                saxHandler.startElement("Tuple");
                for (int k = 0; k < position.members.length; ++k) {
                    Member member = position.members[k];
                    saxHandler.startElement("Member", new String[]{"Hierarchy", member.getHierarchy().getName()});
                    for (int m = 0; m < props.length; ++m) {
                        Object value = member.getPropertyValue(realPropLongs[m]);
                        if (value == null) continue;
                        saxHandler.startElement(props[m]);
                        if (realPropLongs[m].equals(Property.CHILDREN_CARDINALITY.name)) {
                            int displayInfo = this.calculateDisplayInfo(j == 0 ? null : positions[j - 1], j + 1 == positions.length ? null : positions[j + 1], member, k, (Integer)value);
                            saxHandler.characters(Integer.toString(displayInfo));
                        } else {
                            saxHandler.characters(value.toString());
                        }
                        saxHandler.endElement();
                    }
                    saxHandler.endElement();
                }
                saxHandler.endElement();
            }
            saxHandler.endElement();
            saxHandler.endElement();
        }

        private int calculateDisplayInfo(Position prevPosition, Position nextPosition, Member currentMember, int memberOrdinal, int childrenCount) {
            int displayInfo = 0xFFFF & childrenCount;
            if (nextPosition != null) {
                String nextParentUName;
                String currentUName = currentMember.getUniqueName();
                displayInfo |= currentUName.equals(nextParentUName = nextPosition.members[memberOrdinal].getParentUniqueName()) ? 65536 : 0;
            }
            if (prevPosition != null) {
                String currentParentUName = currentMember.getParentUniqueName();
                String prevParentUName = prevPosition.members[memberOrdinal].getParentUniqueName();
                displayInfo |= currentParentUName != null && currentParentUName.equals(prevParentUName) ? 131072 : 0;
            }
            return displayInfo;
        }

        private void cellData(SAXHandler saxHandler) throws SAXException {
            saxHandler.startElement("CellData");
            int axisCount = this.result.getAxes().length;
            int[] pos = new int[axisCount];
            int[] cellOrdinal = new int[]{0};
            if (axisCount == 0) {
                this.emitCell(saxHandler, this.result.getCell(pos), cellOrdinal[0]);
            } else {
                this.recurse(saxHandler, pos, axisCount - 1, cellOrdinal);
            }
            saxHandler.endElement();
        }

        private void recurse(SAXHandler saxHandler, int[] pos, int axis, int[] cellOrdinal) throws SAXException {
            int axisLength = this.result.getAxes()[axis].positions.length;
            for (int i = 0; i < axisLength; ++i) {
                pos[axis] = i;
                if (axis == 0) {
                    Cell cell = this.result.getCell(pos);
                    int n = cellOrdinal[0];
                    cellOrdinal[0] = n + 1;
                    this.emitCell(saxHandler, cell, n);
                    continue;
                }
                this.recurse(saxHandler, pos, axis - 1, cellOrdinal);
            }
        }

        private void emitCell(SAXHandler saxHandler, Cell cell, int ordinal) throws SAXException {
            if (cell.isNull()) {
                return;
            }
            saxHandler.startElement("Cell", new String[]{"CellOrdinal", Integer.toString(ordinal)});
            for (int i = 0; i < cellProps.length; ++i) {
                String cellPropLong = cellPropLongs[i];
                Object value = cell.getPropertyValue(cellPropLong);
                String datatype = (String)cell.getPropertyValue(Property.DATATYPE.getName());
                String valueType = datatype != null ? (datatype.equals("Integer") ? "xsd:int" : (datatype.equals("Numeric") ? "xsd:double" : "xsd:string")) : (value instanceof Integer || value instanceof Long ? "xsd:int" : (value instanceof Double || value instanceof BigDecimal ? "xsd:double" : "xsd:string"));
                if (value == null) continue;
                if (cellPropLong.equals(Property.VALUE.name)) {
                    saxHandler.startElement(cellProps[i], new String[]{"xsi:type", valueType});
                } else {
                    saxHandler.startElement(cellProps[i]);
                }
                String valueString = value.toString();
                if (cellPropLong.equals(Property.VALUE.name) && value instanceof Number) {
                    valueString = XmlaMediator.normalizeNumricString(valueString);
                }
                saxHandler.characters(valueString);
                saxHandler.endElement();
            }
            saxHandler.endElement();
        }
    }

    static class TabularRowSet {
        private String[] header;
        private List rows;

        public TabularRowSet(ResultSet rs) throws SQLException {
            ResultSetMetaData md = rs.getMetaData();
            int columnCount = md.getColumnCount();
            this.header = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                this.header[i] = md.getColumnName(i + 1);
            }
            this.rows = new ArrayList();
            while (rs.next()) {
                Object[] row = new Object[columnCount];
                for (int i = 0; i < columnCount; ++i) {
                    row[i] = rs.getObject(i + 1);
                }
                this.rows.add(row);
            }
        }

        public void unparse(SAXHandler saxHandler) throws SAXException {
            String[] encodedHeader = new String[this.header.length];
            for (int i = 0; i < this.header.length; ++i) {
                encodedHeader[i] = this.header[i].replaceAll(" ", "_x0020_");
            }
            Iterator it = this.rows.iterator();
            while (it.hasNext()) {
                Object[] row = (Object[])it.next();
                saxHandler.startElement("row");
                for (int i = 0; i < row.length; ++i) {
                    saxHandler.startElement(encodedHeader[i]);
                    Object value = row[i];
                    if (value == null) {
                        saxHandler.characters("<null>");
                    } else if (value instanceof Number) {
                        saxHandler.characters(XmlaMediator.normalizeNumricString(row[i].toString()));
                    } else {
                        saxHandler.characters(row[i].toString());
                    }
                    saxHandler.endElement();
                }
                saxHandler.endElement();
            }
        }
    }
}

