/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.aggmatcher;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.sql.DataSource;
import mondrian.olap.MondrianDef;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapStar;
import mondrian.rolap.aggmatcher.JdbcSchema;
import org.apache.log4j.Logger;

public class JdbcSchema {
    private static final Logger LOGGER = Logger.getLogger((Class)JdbcSchema.class);
    private static final MondrianResource mres = MondrianResource.instance();
    public static final String FACTORY_CLASS = "mondrian.rolap.aggregates.jdbcFactoryClass";
    private static Factory factory;
    public static final int UNKNOWN_COLUMN_USAGE = 1;
    public static final int FOREIGN_KEY_COLUMN_USAGE = 2;
    public static final int MEASURE_COLUMN_USAGE = 4;
    public static final int LEVEL_COLUMN_USAGE = 8;
    public static final int FACT_COUNT_COLUMN_USAGE = 16;
    public static final int IGNORE_COLUMN_USAGE = 32;
    public static final String UNKNOWN_COLUMN_NAME = "UNKNOWN";
    public static final String FOREIGN_KEY_COLUMN_NAME = "FOREIGN_KEY";
    public static final String MEASURE_COLUMN_NAME = "MEASURE";
    public static final String LEVEL_COLUMN_NAME = "LEVEL";
    public static final String FACT_COUNT_COLUMN_NAME = "FACT_COUNT";
    public static final String IGNORE_COLUMN_NAME = "IGNORE";
    public static final int UNKNOWN_TABLE_USAGE = 10;
    public static final int FACT_TABLE_USAGE = 11;
    public static final int AGG_TABLE_USAGE = 12;
    public static final String UNKNOWN_TABLE_USAGE_NAME = "UNKNOWN";
    public static final String FACT_TABLE_USAGE_NAME = "FACT";
    public static final String AGG_TABLE_USAGE_NAME = "AGG";
    public static final String UNKNOWN_TABLE_TYPE = "UNKNOWN";
    public static final String TABLE_TABLE_TYPE = "TABLE";
    public static final String VIEW_TYPE = "VIEW";
    public static final String SYSTEM_TABLE_TABLE_TYPE = "SYSTEM TABLE";
    public static final String GLOBAL_TEMP_TABLE_TYPE = "GLOBAL TEMPORARY";
    public static final String LOCAL_TEMP_TABLE_TYPE = "LOCAL TEMPORARY";
    public static final String ALIAS_TABLE_TYPE = "ALIAS";
    public static final String SYNONYM_TABLE_TYPE = "SYNONYM";
    private DataSource dataSource;
    private String schema;
    private String catalog;
    private boolean allTablesLoaded;
    private Map tables;

    public Logger getLogger() {
        return LOGGER;
    }

    private static void makeFactory() {
        if (factory == null) {
            String classname = System.getProperty(FACTORY_CLASS);
            if (classname == null) {
                factory = new StdFactory();
            } else {
                try {
                    Class<?> clz = Class.forName(classname);
                    factory = (Factory)clz.newInstance();
                }
                catch (ClassNotFoundException ex) {
                    throw JdbcSchema.mres.BadJdbcFactoryClassName.ex(classname);
                }
                catch (InstantiationException ex) {
                    throw JdbcSchema.mres.BadJdbcFactoryInstantiation.ex(classname);
                }
                catch (IllegalAccessException ex) {
                    throw JdbcSchema.mres.BadJdbcFactoryAccess.ex(classname);
                }
            }
        }
    }

    public static synchronized void clearDB(DataSource dataSource) {
        JdbcSchema.makeFactory();
        factory.clearDB(dataSource);
    }

    public static synchronized JdbcSchema makeDB(DataSource dataSource) {
        JdbcSchema.makeFactory();
        return factory.makeDB(dataSource);
    }

    public static boolean isUniqueColumnType(int columnType) {
        switch (columnType) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 4: {
                return true;
            }
            case 8: {
                return true;
            }
            case 16: {
                return true;
            }
            case 32: {
                return true;
            }
        }
        return false;
    }

    public static String convertColumnTypeToName(int columnType) {
        switch (columnType) {
            case 1: {
                return "UNKNOWN";
            }
            case 2: {
                return FOREIGN_KEY_COLUMN_NAME;
            }
            case 4: {
                return MEASURE_COLUMN_NAME;
            }
            case 8: {
                return LEVEL_COLUMN_NAME;
            }
            case 16: {
                return FACT_COUNT_COLUMN_NAME;
            }
            case 32: {
                return IGNORE_COLUMN_NAME;
            }
        }
        StringBuffer buf = new StringBuffer();
        if ((columnType & 1) != 0) {
            buf.append("UNKNOWN");
        }
        if ((columnType & 2) != 0) {
            if (buf.length() != 0) {
                buf.append('|');
            }
            buf.append(FOREIGN_KEY_COLUMN_NAME);
        }
        if ((columnType & 4) != 0) {
            if (buf.length() != 0) {
                buf.append('|');
            }
            buf.append(MEASURE_COLUMN_NAME);
        }
        if ((columnType & 8) != 0) {
            if (buf.length() != 0) {
                buf.append('|');
            }
            buf.append(LEVEL_COLUMN_NAME);
        }
        if ((columnType & 0x10) != 0) {
            if (buf.length() != 0) {
                buf.append('|');
            }
            buf.append(FACT_COUNT_COLUMN_NAME);
        }
        if ((columnType & 0x20) != 0) {
            if (buf.length() != 0) {
                buf.append('|');
            }
            buf.append(IGNORE_COLUMN_NAME);
        }
        return buf.toString();
    }

    public static boolean isNumeric(int javaType) {
        switch (javaType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static boolean isText(int javaType) {
        switch (javaType) {
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public static String convertTableUsageToName(int tableUsage) {
        switch (tableUsage) {
            case 10: {
                return "UNKNOWN";
            }
            case 11: {
                return FACT_TABLE_USAGE_NAME;
            }
            case 12: {
                return AGG_TABLE_USAGE_NAME;
            }
        }
        return "UNKNOWN";
    }

    JdbcSchema(DataSource dataSource) {
        this.dataSource = dataSource;
        this.tables = new HashMap();
    }

    public void load() throws SQLException {
        this.loadTables();
    }

    protected void clear() {
        this.allTablesLoaded = false;
        this.schema = null;
        this.catalog = null;
        this.tables.clear();
    }

    void resetAllTablesLoaded() {
        this.allTablesLoaded = false;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    protected void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    public void setSchemaName(String schema) {
        this.schema = schema;
    }

    public String getSchemaName() {
        return this.schema;
    }

    public void setCatalogName(String catalog) {
        this.catalog = catalog;
    }

    public String getCatalogName() {
        return this.catalog;
    }

    public synchronized Iterator getTables() {
        return this.getTablesMap().values().iterator();
    }

    public synchronized Table getTable(String tableName) {
        Map tables = this.getTablesMap();
        Table table = (Table)tables.get(tableName);
        return table;
    }

    public String toString() {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter(sw);
        this.print(pw, "");
        pw.flush();
        return sw.toString();
    }

    public void print(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.println("JdbcSchema:");
        String subprefix = prefix + "  ";
        String subsubprefix = subprefix + "  ";
        pw.print(subprefix);
        pw.println("Tables: [");
        Iterator it = this.getTablesMap().values().iterator();
        while (it.hasNext()) {
            Table table = (Table)it.next();
            table.print(pw, subsubprefix);
        }
        pw.print(subprefix);
        pw.println("]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTables() throws SQLException {
        if (!this.allTablesLoaded) {
            Map tables = this.getTablesMap();
            Connection conn = this.getConnection();
            DatabaseMetaData dmd = conn.getMetaData();
            String schema = this.getSchemaName();
            String catalog = this.getCatalogName();
            String[] tableTypes = new String[]{TABLE_TABLE_TYPE, VIEW_TYPE};
            String tableName = "%";
            ResultSet rs = null;
            try {
                rs = dmd.getTables(catalog, schema, tableName, tableTypes);
                if (rs != null) {
                    while (rs.next()) {
                        this.addTable(rs);
                    }
                } else {
                    this.getLogger().debug((Object)"ERROR: rs == null");
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            try {
                conn.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            this.allTablesLoaded = true;
        }
    }

    protected void addTable(ResultSet rs) throws SQLException {
        String name = rs.getString(3);
        String tableType = rs.getString(4);
        Table table = new Table(name);
        table.setTableType(tableType);
        this.tables.put(table.getName(), table);
    }

    private Map getTablesMap() {
        return this.tables;
    }

    public class Table {
        private final String name;
        private Map columnMap;
        private int totalColumnSize;
        private int tableUsage;
        private String tableType;
        public MondrianDef.Table table;
        private boolean allColumnsLoaded;

        private Table(String name) {
            this.name = name;
            this.tableUsage = 10;
            this.tableType = "UNKNOWN";
        }

        public void load() throws SQLException {
            this.loadColumns();
        }

        public String getName() {
            return this.name;
        }

        public int getTotalColumnSize() {
            return this.totalColumnSize;
        }

        public int getNumberOfRows() {
            return -1;
        }

        public Iterator getColumns() {
            return this.getColumnMap().values().iterator();
        }

        public Iterator getColumnUsages(int columnType) {
            class CTIterator
            implements Iterator {
                private final Iterator columns;
                private final int columnType;
                private Iterator it;
                private Object nextObject;
                private final /* synthetic */ Table this$1;

                CTIterator(Table this$1, Iterator columns, int columnType) {
                    this.this$1 = this$1;
                    this.columns = columns;
                    this.columnType = columnType;
                }

                public boolean hasNext() {
                    Column.Usage usage;
                    while (true) {
                        if (this.it == null || !this.it.hasNext()) {
                            if (!this.columns.hasNext()) {
                                this.nextObject = null;
                                return false;
                            }
                            Column c = (Column)this.columns.next();
                            this.it = c.getUsages();
                            continue;
                        }
                        usage = (Column.Usage)this.it.next();
                        if (usage.isColumnType(this.columnType)) break;
                    }
                    this.nextObject = usage;
                    return true;
                }

                public Object next() {
                    return this.nextObject;
                }

                public void remove() {
                    this.it.remove();
                }
            }
            return new CTIterator(this, this.getColumns(), columnType);
        }

        public Column getColumn(String columnName) {
            return (Column)this.getColumnMap().get(columnName);
        }

        public boolean constainsColumn(String columnName) {
            return this.getColumnMap().containsKey(columnName);
        }

        public void setTableUsage(int tableUsage) {
            if (this.tableUsage != 10 && this.tableUsage != tableUsage) {
                throw mres.AttemptToChangeTableUsage.ex(this.getName(), JdbcSchema.convertTableUsageToName(this.tableUsage), JdbcSchema.convertTableUsageToName(tableUsage));
            }
            this.tableUsage = tableUsage;
        }

        public int getTableUsage() {
            return this.tableUsage;
        }

        public void setTableType(String tableType) {
            if (this.tableType != "UNKNOWN" && !this.tableType.equals(tableType)) {
                throw mres.AttemptToChangeTableType.ex(this.getName(), this.tableType, tableType);
            }
            this.tableType = tableType;
        }

        public String getTableType() {
            return this.tableType;
        }

        public String toString() {
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter(sw);
            this.print(pw, "");
            pw.flush();
            return sw.toString();
        }

        public void print(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.println("Table:");
            String subprefix = prefix + "  ";
            String subsubprefix = subprefix + "  ";
            pw.print(subprefix);
            pw.print("name=");
            pw.print(this.getName());
            pw.print(", type=");
            pw.print(this.getTableType());
            pw.print(", usage=");
            pw.println(JdbcSchema.convertTableUsageToName(this.getTableUsage()));
            pw.print(subprefix);
            pw.print("totalColumnSize=");
            pw.println(this.getTotalColumnSize());
            pw.print(subprefix);
            pw.println("Columns: [");
            Iterator it = this.getColumnMap().values().iterator();
            while (it.hasNext()) {
                Column column = (Column)it.next();
                column.print(pw, subsubprefix);
                pw.println();
            }
            pw.print(subprefix);
            pw.println("]");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadColumns() throws SQLException {
            if (!this.allColumnsLoaded) {
                Connection conn = JdbcSchema.this.getConnection();
                try {
                    DatabaseMetaData dmd = conn.getMetaData();
                    String schema = JdbcSchema.this.getSchemaName();
                    String catalog = JdbcSchema.this.getCatalogName();
                    String tableName = this.getName();
                    String columnNamePattern = "%";
                    ResultSet rs = null;
                    try {
                        Map map = this.getColumnMap();
                        rs = dmd.getColumns(catalog, schema, tableName, columnNamePattern);
                        while (rs.next()) {
                            String name = rs.getString(4);
                            int type = rs.getInt(5);
                            String typeName = rs.getString(6);
                            int columnSize = rs.getInt(7);
                            int decimalDigits = rs.getInt(9);
                            int numPrecRadix = rs.getInt(10);
                            int charOctetLength = rs.getInt(16);
                            String isNullable = rs.getString(18);
                            Column column = new Column(name);
                            column.setType(type);
                            column.setTypeName(typeName);
                            column.setColumnSize(columnSize);
                            column.setDecimalDigits(decimalDigits);
                            column.setNumPrecRadix(numPrecRadix);
                            column.setCharOctetLength(charOctetLength);
                            column.setIsNullable(!isNullable.equals("NO"));
                            map.put(name, column);
                            this.totalColumnSize += column.getColumnSize();
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
                this.allColumnsLoaded = true;
            }
        }

        private Map getColumnMap() {
            if (this.columnMap == null) {
                this.columnMap = new HashMap();
            }
            return this.columnMap;
        }

        public class Column {
            private final String name;
            private int type;
            private String typeName;
            private int columnSize;
            private int decimalDigits;
            private int numPrecRadix;
            private int charOctetLength;
            private boolean isNullable;
            public final MondrianDef.Column column;
            private final List usages;
            private int columnType;

            private Column(String name) {
                this.name = name;
                this.column = new MondrianDef.Column(Table.this.getName(), name);
                this.usages = new ArrayList();
            }

            public String getName() {
                return this.name;
            }

            private void setType(int type) {
                this.type = type;
            }

            public int getType() {
                return this.type;
            }

            private void setTypeName(String typeName) {
                this.typeName = typeName;
            }

            public String getTypeName() {
                return this.typeName;
            }

            public Table getTable() {
                return Table.this;
            }

            public boolean isNumeric() {
                return JdbcSchema.isNumeric(this.getType());
            }

            private void setColumnSize(int columnSize) {
                this.columnSize = columnSize;
            }

            public int getColumnSize() {
                return this.columnSize;
            }

            private void setDecimalDigits(int decimalDigits) {
                this.decimalDigits = decimalDigits;
            }

            public int getDecimalDigits() {
                return this.decimalDigits;
            }

            private void setNumPrecRadix(int numPrecRadix) {
                this.numPrecRadix = numPrecRadix;
            }

            public int getNumPrecRadix() {
                return this.numPrecRadix;
            }

            private void setCharOctetLength(int charOctetLength) {
                this.charOctetLength = charOctetLength;
            }

            public int getCharOctetLength() {
                return this.charOctetLength;
            }

            private void setIsNullable(boolean isNullable) {
                this.isNullable = isNullable;
            }

            public boolean isNullable() {
                return this.isNullable;
            }

            public int numberOfUsages() {
                return this.usages.size();
            }

            public boolean hasUsage() {
                return this.usages.size() != 0;
            }

            public boolean hasUsage(int columnType) {
                return (this.columnType & columnType) != 0;
            }

            public Iterator getUsages() {
                return this.usages.iterator();
            }

            public Iterator getUsages(int columnType) {
                class ColumnTypeIterator
                implements Iterator {
                    private final Iterator it;
                    private final int columnType;
                    private Object nextObject;
                    private final /* synthetic */ Column this$2;

                    ColumnTypeIterator(Column this$2, Iterator it, int columnType) {
                        this.this$2 = this$2;
                        this.it = it;
                        this.columnType = columnType;
                    }

                    public boolean hasNext() {
                        while (this.it.hasNext()) {
                            E o = this.it.next();
                            if (!this.isColumnType(o, this.columnType)) continue;
                            this.nextObject = o;
                            return true;
                        }
                        this.nextObject = null;
                        return false;
                    }

                    protected boolean isColumnType(Object o, int columnType) {
                        return ((Usage)o).isColumnType(columnType);
                    }

                    public Object next() {
                        return this.nextObject;
                    }

                    public void remove() {
                        this.it.remove();
                    }
                }
                return new ColumnTypeIterator(this, this.getUsages(), columnType);
            }

            public Usage newUsage(int columnType) {
                this.columnType |= columnType;
                Usage usage = new Usage(columnType);
                this.usages.add(usage);
                return usage;
            }

            public String toString() {
                StringWriter sw = new StringWriter(256);
                PrintWriter pw = new PrintWriter(sw);
                this.print(pw, "");
                pw.flush();
                return sw.toString();
            }

            public void print(PrintWriter pw, String prefix) {
                pw.print(prefix);
                pw.print("name=");
                pw.print(this.getName());
                pw.print(", typename=");
                pw.print(this.getTypeName());
                pw.print(", size=");
                pw.print(this.getColumnSize());
                switch (this.getType()) {
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        pw.print(", decimalDigits=");
                        pw.print(this.getDecimalDigits());
                        pw.print(", numPrecRadix=");
                        pw.print(this.getNumPrecRadix());
                        break;
                    }
                    case 1: 
                    case 12: {
                        pw.print(", charOctetLength=");
                        pw.print(this.getCharOctetLength());
                        break;
                    }
                }
                pw.print(", isNullable=");
                pw.print(this.isNullable());
                if (this.hasUsage()) {
                    pw.print(" Usages [");
                    Iterator it = this.getUsages();
                    while (it.hasNext()) {
                        Usage u = (Usage)it.next();
                        pw.print('(');
                        u.print(pw, prefix);
                        pw.print(')');
                    }
                    pw.println("]");
                }
            }

            public class Usage {
                private final int columnType;
                private String symbolicName;
                private RolapAggregator aggregator;
                public RolapStar.Measure rMeasure;
                public MondrianDef.Relation relation;
                public MondrianDef.Expression joinExp;
                public String levelColumnName;
                public RolapStar.Column rColumn;
                public RolapStar.Table rTable;
                public String rightJoinConditionColumnName;
                public String usagePrefix;

                Usage(int columnType) {
                    this.columnType = columnType;
                }

                public Column getColumn() {
                    return Column.this;
                }

                public int getColumnType() {
                    return this.columnType;
                }

                public boolean isColumnType(int columnType) {
                    return (this.columnType & columnType) != 0;
                }

                public void setSymbolicName(String symbolicName) {
                    this.symbolicName = symbolicName;
                }

                public String getSymbolicName() {
                    return this.symbolicName;
                }

                public void setAggregator(RolapAggregator aggregator) {
                    this.aggregator = aggregator;
                }

                public RolapAggregator getAggregator() {
                    return this.aggregator;
                }

                public String toString() {
                    StringWriter sw = new StringWriter(64);
                    PrintWriter pw = new PrintWriter(sw);
                    this.print(pw, "");
                    pw.flush();
                    return sw.toString();
                }

                public void print(PrintWriter pw, String prefix) {
                    if (this.getSymbolicName() != null) {
                        pw.print("symbolicName=");
                        pw.print(this.getSymbolicName());
                    }
                    if (this.getAggregator() != null) {
                        pw.print(", aggregator=");
                        pw.print(this.getAggregator().getName());
                    }
                    pw.print(", columnType=");
                    pw.print(JdbcSchema.convertColumnTypeToName(this.getColumnType()));
                }
            }
        }
    }

    public static class StdFactory
    implements Factory {
        private final WeakHashMap dbMap = new WeakHashMap();

        StdFactory() {
        }

        public JdbcSchema makeDB(DataSource dataSource) {
            JdbcSchema db = (JdbcSchema)this.dbMap.get(dataSource);
            if (db == null) {
                db = new JdbcSchema(dataSource);
                this.dbMap.put(dataSource, db);
            }
            return db;
        }

        public void clearDB(DataSource dataSource) {
            JdbcSchema db = (JdbcSchema)this.dbMap.get(dataSource);
            if (db != null) {
                db.clear();
            }
        }
    }

    public static interface Factory {
        public JdbcSchema makeDB(DataSource var1);

        public void clearDB(DataSource var1);
    }
}

