/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import mondrian.rolap.CellKey;
import mondrian.rolap.agg.Aggregation;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.agg.SegmentDataset;

class DenseSegmentDataset
implements SegmentDataset {
    private final Segment segment;
    private final Object[] values;

    DenseSegmentDataset(Segment segment, Object[] values) {
        this.segment = segment;
        this.values = values;
    }

    public Object get(CellKey keys) {
        int offset = this.getOffset(keys.ordinals);
        return this.values[offset];
    }

    public double getBytes() {
        return this.values.length * 12;
    }

    boolean contains(Object[] keys) {
        return this.getOffset(keys) >= 0;
    }

    Object get(Object[] keys) {
        int offset = this.getOffset(keys);
        return keys[offset];
    }

    void put(Object[] keys, Object value) {
        int offset = this.getOffset(keys);
        keys[offset] = value;
    }

    private int getOffset(int[] keys) {
        int offset = 0;
        for (int i = 0; i < keys.length; ++i) {
            Aggregation.Axis axis = this.segment.axes[i];
            Object[] ks = axis.getKeys();
            offset *= ks.length;
            offset += keys[i];
        }
        return offset;
    }

    private int getOffset(Object[] keys) {
        int offset = 0;
        block0: for (int i = 0; i < keys.length; ++i) {
            Aggregation.Axis axis = this.segment.axes[i];
            Object[] ks = axis.getKeys();
            offset *= ks.length;
            Object value = keys[i];
            int axisLength = ks.length;
            for (int j = 0; j < axisLength; ++j) {
                if (!ks[j].equals(value)) continue;
                offset += j;
                continue block0;
            }
            return -1;
        }
        return offset;
    }

    void set(int k, Object o) {
        this.values[k] = o;
    }
}

