/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.MemberBase;
import mondrian.olap.Property;
import mondrian.olap.PropertyFormatter;
import mondrian.olap.Schema;
import mondrian.olap.Util;
import mondrian.olap.type.Type;
import mondrian.rolap.HierarchyUsage;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapUtil;
import org.apache.log4j.Logger;

public class RolapMember
extends MemberBase {
    private static final Logger LOGGER = Logger.getLogger((Class)RolapMember.class);
    private int ordinal;
    private final Object key;
    private Map mapPropertyNameToValue;

    private static String keyToString(Object key) {
        String name = key.toString();
        if (key instanceof Number && name.endsWith(".0")) {
            name = name.substring(0, name.length() - 2);
        }
        return name;
    }

    RolapMember(Member parentMember, RolapLevel level, Object key, String name, int flags) {
        super(parentMember, level, flags);
        this.key = key;
        this.ordinal = -1;
        this.mapPropertyNameToValue = Collections.EMPTY_MAP;
        if (!(name == null || key != null && name.equals(key.toString()))) {
            this.setProperty(Property.NAME.name, name);
        } else {
            this.setUniqueName(key);
        }
    }

    RolapMember(Member parentMember, RolapLevel level, Object value) {
        this(parentMember, level, value, null, 1);
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    RolapLevel getRolapLevel() {
        return (RolapLevel)this.level;
    }

    RolapHierarchy getRolapHierarchy() {
        return (RolapHierarchy)this.getHierarchy();
    }

    void makeUniqueName(HierarchyUsage hierarchyUsage) {
        String n;
        if (this.parentMember == null && this.key != null && (n = hierarchyUsage.getName()) != null) {
            String name = RolapMember.keyToString(this.key);
            n = Util.quoteMdxIdentifier(n);
            this.uniqueName = Util.makeFqName(n, name);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("RolapMember.makeUniqueName: uniqueName=" + this.uniqueName));
            }
        }
    }

    private void setUniqueName(Object key) {
        String name = RolapMember.keyToString(key);
        this.uniqueName = this.parentMember == null ? Util.makeFqName(this.getHierarchy(), name) : Util.makeFqName(this.parentMember, name);
    }

    public boolean isCalculatedInQuery() {
        return false;
    }

    public String getName() {
        String name = (String)this.getPropertyValue(Property.NAME.name);
        return name != null ? name : RolapMember.keyToString(this.key);
    }

    public void setName(String name) {
        throw new Error("unsupported");
    }

    public synchronized void setProperty(String name, Object value) {
        if (name.equals(Property.CAPTION.name)) {
            this.setCaption((String)value);
            return;
        }
        if (this.mapPropertyNameToValue.isEmpty()) {
            this.mapPropertyNameToValue = new HashMap();
        }
        this.mapPropertyNameToValue.put(name, value);
        if (name.equals(Property.NAME.name)) {
            this.setUniqueName(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPropertyValue(String name) {
        Property property = Property.lookup(name);
        if (property != null) {
            switch (property.ordinal) {
                case 2: {
                    break;
                }
                case 3: {
                    return this.getCaption();
                }
                case 4: {
                    ArrayList list = new ArrayList();
                    this.getRolapHierarchy().memberReader.getMemberChildren(this, list);
                    return list;
                }
                case 10: {
                    break;
                }
                case 11: {
                    Schema schema = this.getHierarchy().getDimension().getSchema();
                    return schema.getName();
                }
                case 12: {
                    break;
                }
                case 13: {
                    return this.getHierarchy().getDimension().getUniqueName();
                }
                case 14: {
                    return this.getHierarchy().getUniqueName();
                }
                case 15: {
                    return this.getLevel().getUniqueName();
                }
                case 16: {
                    return new Integer(this.getLevel().getDepth());
                }
                case 19: {
                    return this.getUniqueName();
                }
                case 18: {
                    return this.getName();
                }
                case 20: {
                    return new Integer(this.getMemberType());
                }
                case 21: {
                    return null;
                }
                case 22: {
                    return this.getCaption();
                }
                case 17: {
                    return new Integer(this.getOrdinal());
                }
                case 23: {
                    ArrayList list = new ArrayList();
                    this.getRolapHierarchy().memberReader.getMemberChildren(this, list);
                    return new Integer(list.size());
                }
                case 24: {
                    Member parentMember = this.getParentMember();
                    return new Integer(parentMember == null ? -1 : parentMember.getLevel().getDepth());
                }
                case 25: {
                    Member parentMember = this.getParentMember();
                    return parentMember == null ? null : parentMember.getUniqueName();
                }
                case 26: {
                    Member parentMember = this.getParentMember();
                    return new Integer(parentMember == null ? 0 : 1);
                }
                case 27: {
                    return this.getDescription();
                }
                case 28: {
                    break;
                }
            }
        }
        RolapMember rolapMember = this;
        synchronized (rolapMember) {
            return this.mapPropertyNameToValue.get(name);
        }
    }

    public Property[] getProperties() {
        return this.level.getInheritedProperties();
    }

    public Object evaluateScalar(Evaluator evaluator) {
        Member old = evaluator.setContext(this);
        Object value = evaluator.evaluateCurrent();
        evaluator.setContext(old);
        return value;
    }

    String quoteKeyForSql() {
        return (this.getRolapLevel().getFlags() & 1) != 0 ? this.key.toString() : Util.singleQuoteString(this.key.toString());
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    Object getKey() {
        return this.key;
    }

    public int compareTo(Object o) {
        RolapMember other = (RolapMember)o;
        if (this.key != null && other.key == null) {
            return 1;
        }
        if (this.key == null && other.key != null) {
            return -1;
        }
        if (this.key == null && other.key == null) {
            return this.getUniqueName().compareTo(other.getUniqueName());
        }
        if (this.key == RolapUtil.sqlNullValue || other.key == RolapUtil.sqlNullValue) {
            return this.getUniqueName().compareTo(other.getUniqueName());
        }
        if (this.key.getClass().equals(other.key.getClass())) {
            return ((Comparable)this.key).compareTo(other.key);
        }
        return this.getUniqueName().compareTo(other.getUniqueName());
    }

    public boolean isHidden() {
        RolapLevel rolapLevel = this.getRolapLevel();
        switch (rolapLevel.getHideMemberCondition().ordinal) {
            case 0: {
                return false;
            }
            case 1: {
                String name = this.getName();
                return name.equals("null") || name.equals("");
            }
            case 2: {
                Member parentMember = this.getParentMember();
                if (parentMember == null) {
                    return false;
                }
                String parentName = parentMember.getName();
                String name = this.getName();
                return (parentName == null ? "" : parentName).equals(name == null ? "" : name);
            }
        }
        throw rolapLevel.getHideMemberCondition().unexpected();
    }

    public int getDepth() {
        return this.level.getDepth();
    }

    public Object getSqlKey() {
        return this.key;
    }

    public Type getTypeX() {
        return ((RolapHierarchy)this.getHierarchy()).memberType;
    }

    public String getPropertyFormattedValue(String propertyName) {
        PropertyFormatter pf;
        Property[] props = this.getLevel().getProperties();
        Property prop = null;
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].getName().equals(propertyName)) continue;
            prop = props[i];
            break;
        }
        if (prop != null && (pf = prop.getFormatter()) != null) {
            return pf.formatProperty(this, propertyName, this.getPropertyValue(propertyName));
        }
        Object val = this.getPropertyValue(propertyName);
        return val == null ? "" : val.toString();
    }
}

