/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.List;
import mondrian.olap.Access;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.FunCall;
import mondrian.olap.HierarchyBase;
import mondrian.olap.Level;
import mondrian.olap.LevelType;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.Role;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.BuiltinFunTable;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RestrictedMemberReader;
import mondrian.rolap.RolapCalculatedMember;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapDimension;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.sql.SqlQuery;
import org.apache.log4j.Logger;

class RolapHierarchy
extends HierarchyBase {
    private static final Logger LOGGER = Logger.getLogger((Class)RolapHierarchy.class);
    MemberReader memberReader;
    MondrianDef.Hierarchy xmlHierarchy;
    private String memberReaderClass;
    private MondrianDef.Relation relation;
    private Member defaultMember;
    private String defaultMemberName;
    private RolapNullMember nullMember;
    private String sharedHierarchy;
    private Exp aggregateChildrenExpression;
    private String primaryKey;
    final Type memberType = new MemberType(this, null, null);

    RolapHierarchy(RolapDimension dimension, String subName, boolean hasAll) {
        super(dimension, subName, hasAll);
        this.levels = new RolapLevel[0];
        this.setCaption(dimension.getCaption());
        if (hasAll) {
            this.allLevelName = "(All)";
            Util.discard((Object)this.newLevel(this.allLevelName, 6));
            this.allMemberName = "All " + this.name + "s";
        }
    }

    RolapHierarchy(RolapCube cube, RolapDimension dimension, MondrianDef.Hierarchy xmlHierarchy, MondrianDef.CubeDimension xmlCubeDimension) {
        this(dimension, xmlHierarchy.name, (boolean)xmlHierarchy.hasAll);
        int i;
        if (xmlHierarchy.relation == null && xmlHierarchy.memberReaderClass == null && cube != null) {
            xmlHierarchy.relation = cube.fact;
        }
        this.xmlHierarchy = xmlHierarchy;
        this.relation = xmlHierarchy.relation;
        this.memberReaderClass = xmlHierarchy.memberReaderClass;
        if (this.hasAll) {
            if (xmlHierarchy.allMemberName != null) {
                this.allMemberName = xmlHierarchy.allMemberName;
            }
            if (xmlHierarchy.allLevelName != null) {
                this.allLevelName = xmlHierarchy.allLevelName;
            }
            this.levels = new RolapLevel[xmlHierarchy.levels.length + 1];
            this.levels[0] = new RolapLevel(this, 0, this.allLevelName, null, null, null, null, null, null, null, RolapProperty.emptyArray, 6, RolapLevel.HideMemberCondition.Never, LevelType.Regular);
            for (i = 0; i < xmlHierarchy.levels.length; ++i) {
                MondrianDef.Level xmlLevel = xmlHierarchy.levels[i];
                if (xmlLevel.getKeyExp() == null && xmlHierarchy.memberReaderClass == null) {
                    throw MondrianResource.instance().LevelMustHaveNameExpression.ex(xmlLevel.name);
                }
                this.levels[i + 1] = new RolapLevel(this, i + 1, xmlLevel);
            }
        } else {
            this.levels = new RolapLevel[xmlHierarchy.levels.length];
            for (i = 0; i < xmlHierarchy.levels.length; ++i) {
                this.levels[i] = new RolapLevel(this, i, xmlHierarchy.levels[i]);
            }
        }
        if (xmlCubeDimension instanceof MondrianDef.DimensionUsage) {
            String sharedDimensionName;
            this.sharedHierarchy = sharedDimensionName = ((MondrianDef.DimensionUsage)xmlCubeDimension).source;
            if (this.subName != null) {
                this.sharedHierarchy = this.sharedHierarchy + "." + this.subName;
            }
        } else {
            this.sharedHierarchy = null;
        }
        if (xmlHierarchy.relation != null && xmlHierarchy.memberReaderClass != null) {
            throw MondrianResource.instance().HierarchyMustNotHaveMoreThanOneSource.ex(this.getUniqueName());
        }
        this.primaryKey = xmlHierarchy.primaryKey;
        if (!Util.isEmpty(xmlHierarchy.caption)) {
            this.setCaption(xmlHierarchy.caption);
        }
        this.defaultMemberName = xmlHierarchy.defaultMember;
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RolapHierarchy)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        RolapHierarchy that = (RolapHierarchy)o;
        return this.sharedHierarchy == null || that.sharedHierarchy == null ? false : this.sharedHierarchy.equals(that.sharedHierarchy) && this.getUniqueName().equals(that.getUniqueName());
    }

    public int hashCode() {
        return super.hashCode() ^ (this.sharedHierarchy == null ? 0 : this.sharedHierarchy.hashCode());
    }

    void init(RolapCube cube, MondrianDef.CubeDimension xmlDimension) {
        for (int i = 0; i < this.levels.length; ++i) {
            ((RolapLevel)this.levels[i]).init(cube, xmlDimension);
        }
        if (this.memberReader == null) {
            this.memberReader = this.getRolapSchema().createMemberReader(this.sharedHierarchy, this, this.memberReaderClass);
        }
        if (this.defaultMemberName != null) {
            String[] uniqueNameParts = Util.explode(this.defaultMemberName);
            Dimension dim = this.getDimension();
            if (dim.getName().equals(uniqueNameParts[0])) {
                String[] tmp = new String[uniqueNameParts.length - 1];
                System.arraycopy(uniqueNameParts, 1, tmp, 0, uniqueNameParts.length - 1);
                uniqueNameParts = tmp;
            }
            this.defaultMember = this.memberReader.lookupMember(uniqueNameParts, false);
            if (this.defaultMember == null) {
                throw Util.newInternal("Can not find Default Member with name \"" + this.defaultMemberName + "\"");
            }
        }
    }

    RolapLevel newLevel(String name, int flags) {
        RolapLevel level = new RolapLevel(this, this.levels.length, name, null, null, null, null, null, null, null, RolapProperty.emptyArray, flags, RolapLevel.HideMemberCondition.Never, LevelType.Regular);
        this.levels = (RolapLevel[])RolapUtil.addElement(this.levels, level);
        return level;
    }

    MondrianDef.Relation getUniqueTable() {
        if (this.relation instanceof MondrianDef.Table || this.relation instanceof MondrianDef.View) {
            return this.relation;
        }
        if (this.relation instanceof MondrianDef.Join) {
            return null;
        }
        throw Util.newInternal("hierarchy's relation is a " + ((Object)((Object)this.relation)).getClass());
    }

    boolean tableExists(String tableName) {
        return this.relation != null && RolapHierarchy.tableExists(tableName, this.relation);
    }

    private static boolean tableExists(String tableName, MondrianDef.Relation relation) {
        if (relation instanceof MondrianDef.Table) {
            MondrianDef.Table table = (MondrianDef.Table)relation;
            return table.name.equals(tableName) || table.alias != null && table.alias.equals(tableName);
        }
        if (relation instanceof MondrianDef.Join) {
            MondrianDef.Join join = (MondrianDef.Join)relation;
            return RolapHierarchy.tableExists(tableName, join.left) || RolapHierarchy.tableExists(tableName, join.right);
        }
        return false;
    }

    RolapSchema getRolapSchema() {
        return (RolapSchema)this.dimension.getSchema();
    }

    MondrianDef.Relation getRelation() {
        return this.relation;
    }

    public Member getDefaultMember() {
        if (this.defaultMember == null) {
            List rootMembers = this.memberReader.getRootMembers();
            if (rootMembers.size() == 0) {
                throw MondrianResource.instance().InvalidHierarchyCondition.ex(this.getUniqueName());
            }
            this.defaultMember = (RolapMember)rootMembers.get(0);
        }
        return this.defaultMember;
    }

    public Member getNullMember() {
        if (this.nullMember == null) {
            this.nullMember = new RolapNullMember(this);
        }
        return this.nullMember;
    }

    public Member createMember(Member parent, Level level, String name, Formula formula) {
        return formula != null ? new RolapCalculatedMember((RolapMember)parent, (RolapLevel)level, name, formula) : new RolapMember((Member)((RolapMember)parent), (RolapLevel)level, name);
    }

    String getAlias() {
        return this.getName();
    }

    void addToFrom(SqlQuery query, MondrianDef.Expression expression) {
        if (this.relation == null) {
            throw Util.newError("cannot add hierarchy " + this.getUniqueName() + " to query: it does not have a <Table>, <View> or <Join>");
        }
        boolean failIfExists = false;
        MondrianDef.Relation subRelation = this.relation;
        if (this.relation instanceof MondrianDef.Join && expression != null) {
            subRelation = RolapHierarchy.relationSubset(this.relation, expression.getTableAlias());
        }
        query.addFrom(subRelation, null, false);
    }

    private static MondrianDef.Relation relationSubset(MondrianDef.Relation relation, String alias) {
        if (relation instanceof MondrianDef.Table) {
            MondrianDef.Table table = (MondrianDef.Table)relation;
            return table.getAlias().equals(alias) ? relation : (table.name.equals(alias) ? relation : null);
        }
        if (relation instanceof MondrianDef.Join) {
            MondrianDef.Join join = (MondrianDef.Join)relation;
            MondrianDef.Relation rightRelation = RolapHierarchy.relationSubset(join.right, alias);
            return rightRelation == null ? RolapHierarchy.relationSubset(join.left, alias) : join;
        }
        throw Util.newInternal("bad relation type " + (Object)((Object)relation));
    }

    MemberReader getMemberReader(Role role) {
        int access = role.getAccess(this);
        switch (access) {
            case 1: {
                throw Util.newInternal("Illegal access to members of hierarchy " + this);
            }
            case 4: {
                return this.isRagged() ? new RestrictedMemberReader(this.memberReader, role) : this.memberReader;
            }
            case 2: {
                return new RestrictedMemberReader(this.memberReader, role);
            }
        }
        throw Access.instance().badValue(access);
    }

    boolean isRagged() {
        for (int i = 0; i < this.levels.length; ++i) {
            RolapLevel level = (RolapLevel)this.levels[i];
            if (level.getHideMemberCondition() == RolapLevel.HideMemberCondition.Never) continue;
            return true;
        }
        return false;
    }

    synchronized Exp getAggregateChildrenExpression() {
        if (this.aggregateChildrenExpression == null) {
            FunCall fc = new FunCall("$AggregateChildren", Syntax.Internal, new Exp[]{this});
            Validator validator = Util.createSimpleValidator(BuiltinFunTable.instance());
            this.aggregateChildrenExpression = fc.accept(validator);
        }
        return this.aggregateChildrenExpression;
    }

    RolapDimension createClosedPeerDimension(RolapLevel src, MondrianDef.Closure clos, RolapCube cube, MondrianDef.CubeDimension xmlDimension) {
        RolapDimension peerDimension = new RolapDimension(this.dimension.getSchema(), this.dimension.getName() + "$Closure", ((RolapDimension)this.dimension).getNextOrdinal(), DimensionType.StandardDimension);
        RolapHierarchy peerHier = peerDimension.newHierarchy(this.subName, true);
        peerHier.allMemberName = this.allMemberName;
        peerHier.allLevelName = this.allLevelName;
        peerHier.sharedHierarchy = this.sharedHierarchy;
        peerHier.primaryKey = this.primaryKey;
        MondrianDef.Join join = new MondrianDef.Join();
        peerHier.relation = join;
        join.left = clos.table;
        join.leftKey = clos.parentColumn;
        join.right = this.relation;
        join.rightKey = clos.childColumn;
        int index = peerHier.levels.length;
        int flags = src.getFlags() & 0xFFFFFFFB;
        MondrianDef.Column keyExp = new MondrianDef.Column(clos.table.name, clos.parentColumn);
        RolapLevel level = new RolapLevel(peerHier, index++, "Closure", keyExp, null, null, null, null, null, null, RolapProperty.emptyArray, flags, src.getHideMemberCondition(), src.getLevelType());
        peerHier.levels = (RolapLevel[])RolapUtil.addElement(peerHier.levels, level);
        flags = src.getFlags() | 4;
        keyExp = new MondrianDef.Column(clos.table.name, clos.childColumn);
        RolapLevel sublevel = new RolapLevel(peerHier, index++, "Item", keyExp, null, null, null, null, null, null, RolapProperty.emptyArray, flags, src.getHideMemberCondition(), src.getLevelType());
        peerHier.levels = (RolapLevel[])RolapUtil.addElement(peerHier.levels, sublevel);
        cube.createUsage(peerHier, xmlDimension);
        return peerDimension;
    }

    class RolapNullMember
    extends RolapMember {
        RolapNullMember(RolapHierarchy hierarchy) {
            super(null, (RolapLevel)hierarchy.getLevels()[0], null, "#Null", 5);
        }

        public boolean isNull() {
            return true;
        }
    }
}

