/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mondrian.olap.Role;
import mondrian.olap.Util;
import mondrian.rolap.DelegatingMemberReader;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.SqlConstraintFactory;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;

class RestrictedMemberReader
extends DelegatingMemberReader {
    private final Role.HierarchyAccess hierarchyAccess;
    private final boolean ragged;
    private final SqlConstraintFactory sqlConstraintFactory = SqlConstraintFactory.instance();

    RestrictedMemberReader(MemberReader memberReader, Role role) {
        super(memberReader);
        RolapHierarchy hierarchy = memberReader.getHierarchy();
        this.hierarchyAccess = role.getAccessDetails(hierarchy);
        this.ragged = hierarchy.isRagged();
        Util.assertPrecondition(this.hierarchyAccess != null || this.ragged, "role.getAccessDetails(memberReader.getHierarchy()) != null || hierarchy.isRagged()");
    }

    public boolean setCache(MemberCache cache) {
        return false;
    }

    public RolapMember getLeadMember(RolapMember member, int n) {
        int i = 0;
        int increment = 1;
        if (n < 0) {
            increment = -1;
            n = -n;
        }
        while (i < n) {
            if ((member = this.memberReader.getLeadMember(member, increment)).isNull()) {
                return member;
            }
            if (!this.canSee(member)) continue;
            ++i;
        }
        return member;
    }

    public void getMemberChildren(RolapMember parentMember, List children) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        this.getMemberChildren(parentMember, children, constraint);
    }

    public void getMemberChildren(RolapMember parentMember, List children, MemberChildrenConstraint constraint) {
        ArrayList fullChildren = new ArrayList();
        this.memberReader.getMemberChildren(parentMember, fullChildren, constraint);
        this.processMemberChildren(fullChildren, children, constraint);
    }

    private void processMemberChildren(List fullChildren, List children, MemberChildrenConstraint constraint) {
        ArrayList grandChildren = null;
        for (int i = 0; i < fullChildren.size(); ++i) {
            int access;
            RolapMember member = (RolapMember)fullChildren.get(i);
            if (this.ragged && member.isHidden()) {
                fullChildren.remove(i);
                if (grandChildren == null) {
                    grandChildren = new ArrayList();
                } else {
                    grandChildren.clear();
                }
                this.memberReader.getMemberChildren(member, grandChildren, constraint);
                fullChildren.addAll(i, grandChildren);
                --i;
                continue;
            }
            if (this.hierarchyAccess != null && (access = this.hierarchyAccess.getAccess(member)) == 1) continue;
            children.add(member);
        }
    }

    private void filterMembers(List members, List filteredMembers) {
        int n = members.size();
        for (int i = 0; i < n; ++i) {
            RolapMember member = (RolapMember)members.get(i);
            if (!this.canSee(member)) continue;
            filteredMembers.add(member);
        }
    }

    private boolean canSee(RolapMember member) {
        if (this.ragged && member.isHidden()) {
            return false;
        }
        if (this.hierarchyAccess != null) {
            int access = this.hierarchyAccess.getAccess(member);
            return access != 1;
        }
        return true;
    }

    public void getMemberChildren(List parentMembers, List children) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        this.getMemberChildren(parentMembers, children, constraint);
    }

    public synchronized void getMemberChildren(List parentMembers, List children, MemberChildrenConstraint constraint) {
        ArrayList fullChildren = new ArrayList();
        super.getMemberChildren(parentMembers, fullChildren, constraint);
        this.processMemberChildren(fullChildren, children, constraint);
    }

    public List getMembersInLevel(RolapLevel level, int startOrdinal, int endOrdinal) {
        TupleConstraint constraint = this.sqlConstraintFactory.getLevelMembersConstraint(null);
        return this.getMembersInLevel(level, startOrdinal, endOrdinal, constraint);
    }

    public List getMembersInLevel(RolapLevel level, int startOrdinal, int endOrdinal, TupleConstraint constraint) {
        if (this.hierarchyAccess != null) {
            int depth = level.getDepth();
            if (this.hierarchyAccess.getTopLevel() != null && depth < this.hierarchyAccess.getTopLevel().getDepth()) {
                return Collections.EMPTY_LIST;
            }
            if (this.hierarchyAccess.getBottomLevel() != null && depth > this.hierarchyAccess.getBottomLevel().getDepth()) {
                return Collections.EMPTY_LIST;
            }
        }
        List membersInLevel = super.getMembersInLevel(level, startOrdinal, endOrdinal, constraint);
        ArrayList filteredMembers = new ArrayList();
        this.filterMembers(membersInLevel, filteredMembers);
        return filteredMembers;
    }
}

