/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunCall;
import mondrian.olap.FunDef;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.Resolver;
import mondrian.olap.type.BooleanType;
import mondrian.olap.type.DimensionType;
import mondrian.olap.type.HierarchyType;
import mondrian.olap.type.LevelType;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.ScalarType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.SymbolType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.spi.UserDefinedFunction;

public class UdfResolver
implements Resolver {
    private final UserDefinedFunction udf;
    private static final String[] emptyStringArray = new String[0];

    public UdfResolver(UserDefinedFunction udf) {
        this.udf = udf;
    }

    public String getName() {
        return this.udf.getName();
    }

    public String getDescription() {
        return this.udf.getDescription();
    }

    public Syntax getSyntax() {
        return this.udf.getSyntax();
    }

    public FunDef resolve(Exp[] args, Validator validator, int[] conversionCount) {
        Type[] parameterTypes = this.udf.getParameterTypes();
        if (args.length != parameterTypes.length) {
            return null;
        }
        int[] parameterCategories = new int[parameterTypes.length];
        Type[] argTypes = new Type[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type parameterType = parameterTypes[i];
            Exp arg = args[i];
            argTypes[i] = arg.getTypeX();
            Type argType = argTypes[i];
            if (parameterType.equals(argType)) continue;
            int parameterCategory = UdfResolver.typeToCategory(parameterType);
            if (!validator.canConvert(arg, parameterCategory, conversionCount)) {
                return null;
            }
            parameterCategories[i] = parameterCategory;
        }
        Type returnType = this.udf.getReturnType(argTypes);
        int returnCategory = UdfResolver.typeToCategory(returnType);
        return new UdfFunDef(returnCategory, parameterCategories);
    }

    private static int typeToCategory(Type type) {
        if (type instanceof NumericType) {
            return 7;
        }
        if (type instanceof BooleanType) {
            return 5;
        }
        if (type instanceof DimensionType) {
            return 2;
        }
        if (type instanceof HierarchyType) {
            return 3;
        }
        if (type instanceof MemberType) {
            return 6;
        }
        if (type instanceof LevelType) {
            return 4;
        }
        if (type instanceof ScalarType) {
            return 13;
        }
        if (type instanceof SetType) {
            return 8;
        }
        if (type instanceof StringType) {
            return 9;
        }
        if (type instanceof SymbolType) {
            return 11;
        }
        if (type instanceof TupleType) {
            return 10;
        }
        throw Util.newInternal("Unknown type " + type);
    }

    public boolean requiresExpression(int k) {
        return false;
    }

    public String[] getReservedWords() {
        String[] reservedWords = this.udf.getReservedWords();
        return reservedWords == null ? emptyStringArray : reservedWords;
    }

    private class UdfFunDef
    extends FunDefBase {
        public UdfFunDef(int returnCategory, int[] parameterCategories) {
            super(UdfResolver.this, returnCategory, parameterCategories);
        }

        public Object evaluate(Evaluator evaluator, Exp[] args) {
            return UdfResolver.this.udf.execute(evaluator, args);
        }

        public boolean callDependsOn(FunCall call, Dimension dimension) {
            return true;
        }
    }
}

