/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Literal;
import mondrian.olap.Member;
import mondrian.olap.Property;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.MondrianEvaluationException;
import mondrian.olap.fun.ResolverBase;

class PropertiesFunDef
extends FunDefBase {
    public PropertiesFunDef(String name, String signature, String description, Syntax syntax, int returnType, int[] parameterTypes) {
        super(name, signature, description, syntax, returnType, parameterTypes);
    }

    public Object evaluate(Evaluator evaluator, Exp[] args) {
        String s;
        Member member = PropertiesFunDef.getMemberArg(evaluator, args, 0, true);
        Object o = member.getPropertyValue(s = PropertiesFunDef.getStringArg(evaluator, args, 1, null));
        if (o == null && !Util.isValidProperty(member, s)) {
            throw new MondrianEvaluationException("Property '" + s + "' is not valid for member '" + member + "'");
        }
        return o;
    }

    static class Resolver
    extends ResolverBase {
        Resolver() {
            super("Properties", "<Member>.Properties(<String Expression>)", "Returns the value of a member property.", Syntax.Method);
        }

        /*
         * WARNING - void declaration
         */
        public FunDef resolve(Exp[] args, Validator validator, int[] conversionCount) {
            void var5_9;
            int returnType;
            int[] argTypes = new int[]{6, 9};
            if (args.length != 2 || args[0].getCategory() != 6 || args[1].getCategory() != 9) {
                return null;
            }
            if (args[1] instanceof Literal) {
                String propertyName = (String)((Literal)args[1]).getValue();
                Hierarchy hierarchy = args[0].getTypeX().getHierarchy();
                Level[] levels = hierarchy.getLevels();
                Property property = Resolver.lookupProperty(levels[levels.length - 1], propertyName);
                if (property == null) {
                    returnType = 13;
                } else {
                    switch (property.getType()) {
                        case 2: {
                            returnType = 5;
                            break;
                        }
                        case 1: {
                            returnType = 7;
                            break;
                        }
                        case 0: {
                            returnType = 9;
                            break;
                        }
                        default: {
                            throw Util.newInternal("Unknown property type " + property.getType());
                        }
                    }
                }
            } else {
                returnType = 13;
            }
            return new PropertiesFunDef(this.getName(), this.getSignature(), this.getDescription(), this.getSyntax(), (int)var5_9, argTypes);
        }

        public boolean requiresExpression(int k) {
            return true;
        }
    }
}

