/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.FunCall;
import mondrian.olap.FunDef;
import mondrian.olap.FunTable;
import mondrian.olap.Member;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunInfo;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.SimpleResolver;
import mondrian.olap.fun.TupleFunDef;
import mondrian.olap.type.DimensionType;
import mondrian.olap.type.HierarchyType;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.ScalarType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.resource.MondrianResource;

public abstract class FunTableImpl
implements FunTable {
    protected final Map mapNameToResolvers = new HashMap();
    private final HashSet reservedWords = new HashSet();
    private final HashSet propertyWords = new HashSet();
    protected static final Resolver[] emptyResolverArray = new Resolver[0];
    protected final List resolvers = new ArrayList();
    protected final List funInfoList = new ArrayList();
    static /* synthetic */ Class class$mondrian$olap$fun$FunTableImpl;

    protected FunTableImpl() {
    }

    public void init() {
        this.defineFunctions();
        this.organizeFunctions();
    }

    protected static String makeResolverKey(String name, Syntax syntax) {
        return name.toUpperCase() + "$" + syntax;
    }

    protected void define(FunDef funDef) {
        this.define(new SimpleResolver(funDef));
    }

    protected void define(Resolver resolver) {
        this.addFunInfo(resolver);
        if (resolver.getSyntax() == Syntax.Property) {
            this.defineProperty(resolver.getName());
        }
        this.resolvers.add(resolver);
        String[] reservedWords = resolver.getReservedWords();
        for (int i = 0; i < reservedWords.length; ++i) {
            String reservedWord = reservedWords[i];
            this.defineReserved(reservedWord);
        }
    }

    protected void addFunInfo(Resolver resolver) {
        this.funInfoList.add(FunInfo.make(resolver));
    }

    public Exp createValueFunCall(Exp exp, Validator validator) {
        Type type = exp.getTypeX();
        if (type instanceof ScalarType) {
            return exp;
        }
        if (!TypeUtil.canEvaluate(type)) {
            String exprString = Util.unparse(exp);
            throw MondrianResource.instance().MdxMemberExpIsSet.ex(exprString);
        }
        if (type instanceof MemberType) {
            return new MemberScalarExp(exp);
        }
        if (type instanceof DimensionType || type instanceof HierarchyType) {
            exp = new FunCall("CurrentMember", Syntax.Property, new Exp[]{exp});
            exp = exp.accept(validator);
            return new MemberScalarExp(exp);
        }
        if (type instanceof TupleType) {
            FunCall call;
            if (exp instanceof FunCall && (call = (FunCall)exp).getFunDef() instanceof TupleFunDef) {
                return new MemberListScalarExp(call.getArgs());
            }
            return new TupleScalarExp(exp);
        }
        throw Util.newInternal("Unknown type " + type);
    }

    static Exp createValueFunCall() {
        return new ScalarExp();
    }

    public FunDef getDef(FunCall call, Validator validator) {
        String key = FunTableImpl.makeResolverKey(call.getFunName(), call.getSyntax());
        String signature = call.getSyntax().getSignature(call.getFunName(), 0, ExpBase.getTypes(call.getArgs()));
        Resolver[] resolvers = (Resolver[])this.mapNameToResolvers.get(key);
        if (resolvers == null) {
            resolvers = emptyResolverArray;
        }
        int[] conversionCount = new int[]{0};
        int minConversions = Integer.MAX_VALUE;
        int matchCount = 0;
        FunDef matchDef = null;
        for (int i = 0; i < resolvers.length; ++i) {
            conversionCount[0] = 0;
            FunDef def = resolvers[i].resolve(call.getArgs(), validator, conversionCount);
            if (def == null) continue;
            int conversions = conversionCount[0];
            if (conversions < minConversions) {
                minConversions = conversions;
                matchCount = 1;
                matchDef = def;
                continue;
            }
            if (conversions != minConversions) continue;
            ++matchCount;
        }
        switch (matchCount) {
            case 0: {
                throw MondrianResource.instance().NoFunctionMatchesSignature.ex(signature);
            }
            case 1: {
                String matchKey = FunTableImpl.makeResolverKey(matchDef.getName(), matchDef.getSyntax());
                Util.assertTrue(matchKey.equals(key), matchKey);
                return matchDef;
            }
        }
        throw MondrianResource.instance().MoreThanOneFunctionMatchesSignature.ex(signature);
    }

    public boolean requiresExpression(FunCall call, int k, Validator validator) {
        FunDef funDef = call.getFunDef();
        if (funDef != null) {
            int[] parameterTypes = funDef.getParameterTypes();
            return parameterTypes[k] != 8;
        }
        String key = FunTableImpl.makeResolverKey(call.getFunName(), call.getSyntax());
        Resolver[] resolvers = (Resolver[])this.mapNameToResolvers.get(key);
        if (resolvers == null) {
            resolvers = emptyResolverArray;
        }
        for (int i = 0; i < resolvers.length; ++i) {
            Resolver resolver2 = resolvers[i];
            if (resolver2.requiresExpression(k)) continue;
            return false;
        }
        return true;
    }

    public List getReservedWords() {
        return new ArrayList(this.reservedWords);
    }

    public boolean isReserved(String s) {
        return this.reservedWords.contains(s.toUpperCase());
    }

    protected void defineReserved(String s) {
        this.reservedWords.add(s.toUpperCase());
    }

    public List getResolvers() {
        ArrayList<Resolver> list = new ArrayList<Resolver>();
        Collection c = this.mapNameToResolvers.values();
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            Resolver[] resolvers = (Resolver[])iterator.next();
            for (int i = 0; i < resolvers.length; ++i) {
                Resolver resolver = resolvers[i];
                list.add(resolver);
            }
        }
        return list;
    }

    public boolean isProperty(String s) {
        return this.propertyWords.contains(s.toUpperCase());
    }

    protected void defineProperty(String s) {
        this.propertyWords.add(s.toUpperCase());
    }

    public List getFunInfoList() {
        return Collections.unmodifiableList(this.funInfoList);
    }

    protected void organizeFunctions() {
        Collections.sort(this.funInfoList);
        int n = this.resolvers.size();
        for (int i = 0; i < n; ++i) {
            Resolver resolver = (Resolver)this.resolvers.get(i);
            String key = FunTableImpl.makeResolverKey(resolver.getName(), resolver.getSyntax());
            Object value = this.mapNameToResolvers.get(key);
            if (value instanceof Resolver[]) continue;
            ArrayList<Resolver> v2 = (ArrayList<Resolver>)value;
            if (v2 == null) {
                v2 = new ArrayList<Resolver>();
                this.mapNameToResolvers.put(key, v2);
            }
            v2.add(resolver);
        }
        Iterator keys = this.mapNameToResolvers.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = this.mapNameToResolvers.get(key);
            if (value instanceof Resolver[]) continue;
            List v2 = (List)value;
            this.mapNameToResolvers.put(key, v2.toArray(new Resolver[v2.size()]));
        }
    }

    protected abstract void defineFunctions();

    public static class MemberListScalarExp
    extends ExpBase {
        private final Exp[] exps;
        static final /* synthetic */ boolean $assertionsDisabled;

        public MemberListScalarExp(Exp[] exps) {
            this.exps = exps;
            for (int i = 0; i < exps.length; ++i) {
                if (!$assertionsDisabled && !(exps[i].getTypeX() instanceof MemberType)) {
                    throw new AssertionError();
                }
            }
        }

        public void unparse(PrintWriter pw) {
            MemberListScalarExp.unparseList(pw, this.exps, "(", ", ", ")");
        }

        public Object[] getChildren() {
            return this.exps;
        }

        public Object clone() {
            return this;
        }

        public int getCategory() {
            return 7;
        }

        public Type getTypeX() {
            return new NumericType();
        }

        public Exp accept(Validator validator) {
            return this;
        }

        public boolean dependsOn(Dimension dimension) {
            boolean uses = false;
            for (int i = 0; i < this.exps.length; ++i) {
                Exp exp = this.exps[i];
                if (exp.dependsOn(dimension)) {
                    return true;
                }
                Type type = exp.getTypeX();
                if (!type.usesDimension(dimension)) continue;
                uses = true;
            }
            return !uses;
        }

        public Object evaluate(Evaluator evaluator) {
            Evaluator evaluator2 = evaluator.push();
            for (int i = 0; i < this.exps.length; ++i) {
                Exp exp = this.exps[i];
                Member member = (Member)exp.evaluate(evaluator);
                evaluator2.setContext(member);
            }
            return evaluator2.evaluateCurrent();
        }

        static {
            $assertionsDisabled = !(class$mondrian$olap$fun$FunTableImpl == null ? (class$mondrian$olap$fun$FunTableImpl = FunTableImpl.class$("mondrian.olap.fun.FunTableImpl")) : class$mondrian$olap$fun$FunTableImpl).desiredAssertionStatus();
        }
    }

    public static class ScalarExp
    extends ExpBase {
        public void unparse(PrintWriter pw) {
            pw.print("$Value()");
        }

        public Object clone() {
            return this;
        }

        public int getCategory() {
            return 7;
        }

        public Type getTypeX() {
            return new NumericType();
        }

        public Exp accept(Validator validator) {
            return this;
        }

        public boolean dependsOn(Dimension dimension) {
            return true;
        }

        public Object evaluate(Evaluator evaluator) {
            return evaluator.evaluateCurrent();
        }
    }

    public static class MemberScalarExp
    extends ExpBase {
        private final Exp exp;

        public MemberScalarExp(Exp exp) {
            this.exp = exp;
        }

        public Object[] getChildren() {
            return new Object[]{this.exp};
        }

        public void unparse(PrintWriter pw) {
            this.exp.unparse(pw);
        }

        public Object clone() {
            return this;
        }

        public int getCategory() {
            return this.exp.getCategory();
        }

        public Type getTypeX() {
            return new ScalarType();
        }

        public Exp accept(Validator validator) {
            Exp exp2 = validator.validate(this.exp, false);
            if (exp2 == this.exp) {
                return this;
            }
            FunTable funTable = validator.getFunTable();
            return funTable.createValueFunCall(exp2, validator);
        }

        public boolean dependsOn(Dimension dimension) {
            Type type = this.exp.getTypeX();
            if (type.usesDimension(dimension)) {
                return this.exp.dependsOn(dimension);
            }
            return true;
        }

        public Object evaluate(Evaluator evaluator) {
            Member member = (Member)this.exp.evaluate(evaluator);
            if (member == null || member.isNull()) {
                return null;
            }
            Member old = evaluator.setContext(member);
            Object value = evaluator.evaluateCurrent();
            evaluator.setContext(old);
            return value;
        }
    }

    public static class TupleScalarExp
    extends ExpBase {
        private final Exp exp;
        static final /* synthetic */ boolean $assertionsDisabled;

        public TupleScalarExp(Exp exp) {
            this.exp = exp;
            if (!$assertionsDisabled && !(exp.getTypeX() instanceof TupleType)) {
                throw new AssertionError();
            }
        }

        public Object[] getChildren() {
            return new Object[]{this.exp};
        }

        public void unparse(PrintWriter pw) {
            this.exp.unparse(pw);
        }

        public Object clone() {
            return this;
        }

        public int getCategory() {
            return this.exp.getCategory();
        }

        public Type getTypeX() {
            return new ScalarType();
        }

        public Exp accept(Validator validator) {
            Exp exp2 = validator.validate(this.exp, false);
            if (exp2 == this.exp) {
                // empty if block
            }
            FunTable funTable = validator.getFunTable();
            return funTable.createValueFunCall(exp2, validator);
        }

        public boolean dependsOn(Dimension dimension) {
            return true;
        }

        public Object evaluate(Evaluator evaluator) {
            return this.exp.evaluateScalar(evaluator);
        }

        static {
            $assertionsDisabled = !(class$mondrian$olap$fun$FunTableImpl == null ? (class$mondrian$olap$fun$FunTableImpl = FunTableImpl.class$("mondrian.olap.fun.FunTableImpl")) : class$mondrian$olap$fun$FunTableImpl).desiredAssertionStatus();
        }
    }
}

