/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;

public final class ConfigHelper {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$util$ConfigHelper == null ? (class$org$hibernate$util$ConfigHelper = ConfigHelper.class$("org.hibernate.util.ConfigHelper")) : class$org$hibernate$util$ConfigHelper));
    static /* synthetic */ Class class$org$hibernate$util$ConfigHelper;

    public static final URL locateConfig(String path) {
        try {
            return new URL(path);
        }
        catch (MalformedURLException e) {
            return ConfigHelper.findAsResource(path);
        }
    }

    public static final URL findAsResource(String path) {
        URL url = null;
        url = Thread.currentThread().getContextClassLoader().getResource(path);
        if (url != null) {
            return url;
        }
        url = (class$org$hibernate$util$ConfigHelper == null ? (class$org$hibernate$util$ConfigHelper = ConfigHelper.class$("org.hibernate.util.ConfigHelper")) : class$org$hibernate$util$ConfigHelper).getClassLoader().getResource(path);
        if (url != null) {
            return url;
        }
        url = ClassLoader.getSystemClassLoader().getResource(path);
        return url;
    }

    public static final InputStream getConfigStream(String path) throws HibernateException {
        URL url = ConfigHelper.locateConfig(path);
        if (url == null) {
            String msg = "Unable to locate config file: " + path;
            log.fatal((Object)msg);
            throw new HibernateException(msg);
        }
        try {
            return url.openStream();
        }
        catch (IOException e) {
            throw new HibernateException("Unable to open config file: " + path, e);
        }
    }

    public static final Reader getConfigStreamReader(String path) throws HibernateException {
        return new InputStreamReader(ConfigHelper.getConfigStream(path));
    }

    public static final Properties getConfigProperties(String path) throws HibernateException {
        try {
            Properties properties = new Properties();
            properties.load(ConfigHelper.getConfigStream(path));
            return properties;
        }
        catch (IOException e) {
            throw new HibernateException("Unable to load properties from specified config file: " + path, e);
        }
    }

    private ConfigHelper() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

