/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.dimensiontree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import rex.graphics.TreeElement;
import rex.graphics.dimensiontree.DimensionTreeModel;
import rex.graphics.dimensiontree.elements.DimensionTreeElement;
import rex.graphics.dimensiontree.elements.HierarchyElement;
import rex.graphics.dimensiontree.elements.LevelElement;
import rex.graphics.dimensiontree.elements.MeasureElement;
import rex.graphics.dimensiontree.elements.PopUpActions;
import rex.graphics.mdxeditor.MdxEditor;
import rex.metadata.Query;
import rex.metadata.QueryElement;
import rex.metadata.ServerMetadata;
import rex.utils.AppColors;
import rex.utils.I18n;
import rex.utils.S;
import rex.utils.WaitCursorEventQueue;
import rex.xmla.XMLADiscoverProperties;
import rex.xmla.XMLADiscoverRestrictions;
import rex.xmla.XMLAObjectsFactory;

public class DimensionTree
extends JPanel
implements ActionListener,
TreeWillExpandListener {
    final JTree tree;
    JPopupMenu popup;
    Query query;
    private DimensionTreeElement popUpSource;
    private MdxEditor mdxEditor;

    public DimensionTree(XMLADiscoverRestrictions _restrictions, XMLADiscoverProperties _properties, ServerMetadata _smd, Query _q) {
        this(_restrictions, _properties, _smd, false);
        this.query = _q;
    }

    public DimensionTree(XMLADiscoverRestrictions _restrictions, XMLADiscoverProperties _properties, ServerMetadata _smd, MdxEditor _mdxEditor) {
        this(_restrictions, _properties, _smd, true);
        this.mdxEditor = _mdxEditor;
        this.tree.addTreeWillExpandListener(this);
    }

    public DimensionTree(XMLADiscoverRestrictions _restrictions, XMLADiscoverProperties _properties, ServerMetadata _smd, boolean withMembersLevel) {
        DimensionTreeModel treeModel = new DimensionTreeModel(_restrictions, _properties, _smd, withMembersLevel);
        this.tree = new JTree(treeModel){
            {
                this.setOpaque(false);
            }

            public void paintComponent(Graphics g) {
                S.paintWhiteBackground(g, this);
                super.paintComponent(g);
            }
        };
        this.tree.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.setCellRenderer(new MyRenderer2());
        this.tree.setOpaque(false);
        JScrollPane treeView = new JScrollPane(this.tree);
        treeView.setOpaque(false);
        treeView.setPreferredSize(new Dimension(400, 600));
        treeView.setMinimumSize(new Dimension(200, 0));
        treeView.setMaximumSize(new Dimension(800, 600));
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.add((Component)treeView, "Center");
        this.popup = new JPopupMenu();
        this.tree.addMouseListener(new PopupListener());
    }

    public JTree getTree() {
        return this.tree;
    }

    public void setQuery(Query q) {
        this.query = q;
    }

    public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
        TreeElement te = (TreeElement)e.getPath().getLastPathComponent();
        if (((DimensionTreeElement)te.getUserObject()).getChildrenCount() > 0 && te.getChildCount() == 0) {
            DimensionTreeModel cfr_ignored_0 = (DimensionTreeModel)this.tree.getModel();
            if (((DimensionTreeElement)te.getUserObject()).getChildrenCount() < DimensionTreeModel.MAX_CHILDREN_COUNT_ASK) {
                ((DimensionTreeModel)this.tree.getModel()).addChildrenOneLevel(te);
            } else {
                DimensionTreeModel cfr_ignored_1 = (DimensionTreeModel)this.tree.getModel();
                int retVal = JOptionPane.showConfirmDialog(null, I18n.getString("msgText.expandNode1") + ((DimensionTreeElement)te.getUserObject()).getChildrenCount() + I18n.getString("msgText.expandNode2"), I18n.getString("msgTitle.expandNode") + DimensionTreeModel.MAX_CHILDREN_COUNT_ASK + " members.", 0);
                if (retVal == 1) {
                    throw new ExpandVetoException(e);
                }
                ((DimensionTreeModel)this.tree.getModel()).addChildrenOneLevel(te);
            }
        }
    }

    public void treeWillCollapse(TreeExpansionEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        boolean i = false;
        if (e.getActionCommand().equals((String)PopUpActions.popUpCaptions.get(PopUpActions.FLATTEN_DIMENSIONS))) {
            ((DimensionTreeModel)this.tree.getModel()).setFlattenDimensions(true);
        } else if (e.getActionCommand().equals((String)PopUpActions.popUpCaptions.get(PopUpActions.GROUP_HIERARCHIES_BY_DIMENSION))) {
            ((DimensionTreeModel)this.tree.getModel()).setFlattenDimensions(false);
        } else if (e.getActionCommand().equals((String)PopUpActions.popUpCaptions.get(PopUpActions.SEND_TO_COLUMNS))) {
            this.query.addToColumns((QueryElement)((Object)this.popUpSource));
            ((DimensionTreeModel)this.tree.getModel()).disableTreeElements((QueryElement)((Object)this.popUpSource));
            this.tree.repaint();
        } else if (e.getActionCommand().equals((String)PopUpActions.popUpCaptions.get(PopUpActions.SEND_TO_ROWS))) {
            this.query.addToRows((QueryElement)((Object)this.popUpSource));
            ((DimensionTreeModel)this.tree.getModel()).disableTreeElements((QueryElement)((Object)this.popUpSource));
            this.tree.repaint();
        } else if (e.getActionCommand().equals((String)PopUpActions.popUpCaptions.get(PopUpActions.SEND_TO_MEASURES))) {
            this.query.addToMeasures((QueryElement)((Object)this.popUpSource));
            ((DimensionTreeModel)this.tree.getModel()).disableTreeElements((QueryElement)((Object)this.popUpSource));
            this.tree.repaint();
        } else if (e.getActionCommand().equals((String)PopUpActions.popUpCaptions.get(PopUpActions.SEND_TO_PAGES))) {
            this.query.addToPages((QueryElement)((Object)this.popUpSource));
            ((DimensionTreeModel)this.tree.getModel()).disableTreeElements((QueryElement)((Object)this.popUpSource));
            this.tree.repaint();
        }
    }

    public static void main(String[] args) {
        ServerMetadata svm = new ServerMetadata("http://localhost/xmla/msxisapi.dll");
        XMLADiscoverRestrictions restrictions = XMLAObjectsFactory.newXMLADiscoverRestrictions();
        XMLADiscoverProperties properties = XMLAObjectsFactory.newXMLADiscoverProperties();
        restrictions.setCatalog("Foodmart 2000");
        restrictions.setCubeName("Sales");
        properties.setDataSourceInfo("Local Analysis Server");
        properties.setCatalog("Sales");
        properties.setFormat("Tabular");
        properties.setContent("SchemaData");
        JFrame frame = new JFrame("Testing DimensionTree...");
        DimensionTree dst = new DimensionTree(restrictions, properties, svm, false);
        frame.getContentPane().add(dst);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.pack();
        frame.setVisible(true);
        WaitCursorEventQueue waitQueue = new WaitCursorEventQueue(500);
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(waitQueue);
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int selRow = DimensionTree.this.tree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = DimensionTree.this.tree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1 && ((TreeElement)selPath.getLastPathComponent()).getUserObject() instanceof QueryElement) {
                    QueryElement qe = (QueryElement)((TreeElement)selPath.getLastPathComponent()).getUserObject();
                    if (DimensionTree.this.mdxEditor != null) {
                        if (qe instanceof MeasureElement) {
                            DimensionTree.this.mdxEditor.addTextToCurrentPosition(((MeasureElement)qe).getUniqueName());
                        } else if (qe instanceof LevelElement) {
                            DimensionTree.this.mdxEditor.addTextToCurrentPosition(((LevelElement)qe).getUniqueName() + ".Members");
                        } else if (qe instanceof HierarchyElement) {
                            DimensionTree.this.mdxEditor.addTextToCurrentPosition(((HierarchyElement)((Object)qe)).getUniqueName() + ".Members");
                        }
                        return;
                    }
                    if (qe instanceof MeasureElement) {
                        DimensionTree.this.query.addToMeasures(qe);
                    } else {
                        DimensionTree.this.query.addToRows(qe);
                    }
                    ((DimensionTreeModel)DimensionTree.this.tree.getModel()).disableTreeElements(qe);
                    DimensionTree.this.tree.repaint();
                }
            }
        }

        private void maybeShowPopup(MouseEvent e) {
            int selRow = DimensionTree.this.tree.getRowForLocation(e.getX(), e.getY());
            TreePath selPath = DimensionTree.this.tree.getPathForLocation(e.getX(), e.getY());
            if (selRow != -1 && e.isPopupTrigger()) {
                DimensionTree.this.popup.removeAll();
                DimensionTree.this.popUpSource = (DimensionTreeElement)((TreeElement)selPath.getLastPathComponent()).getUserObject();
                String[] al = DimensionTree.this.popUpSource.getPopUpActionList();
                for (int i = 0; al != null && i < al.length; ++i) {
                    JMenuItem menuItem = new JMenuItem((String)PopUpActions.popUpCaptions.get(al[i]));
                    menuItem.addActionListener(DimensionTree.this);
                    DimensionTree.this.popup.add(menuItem);
                }
                DimensionTree.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class MyRenderer2
    extends DefaultTreeCellRenderer {
        ImageIcon tutorialIcon;

        public MyRenderer2() {
            this.setOpaque(false);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DimensionTreeElement curr = (DimensionTreeElement)((TreeElement)value).getUserObject();
            this.setText(((Object)curr).toString());
            this.setIcon(curr.getIcon());
            this.setToolTipText(curr.getToolTip());
            if (!curr.isEnabled()) {
                this.setForeground(AppColors.DISABLED_DIM_TREE_NODE_COLOR);
            }
            return this;
        }
    }
}

