/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.gui.util;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;

public class SortedEditableList
extends JPanel {
    private boolean m_editableItems = true;
    private Editor m_editor;
    private DefaultListModel m_model = new DefaultListModel();
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JButton m_buttonAdd;
    private JButton m_buttonDown;
    private JButton m_buttonEdit;
    private JButton m_buttonRemove;
    private JButton m_buttonUp;
    private JList m_itemList;

    public SortedEditableList() {
        this.m_editor = new StringEditor();
        this.initComponents();
        this.m_itemList.setModel(this.m_model);
    }

    public void setEditor(Editor editor) {
        this.m_editor = editor;
    }

    public void setData(Object[] items) {
        this.m_model.removeAllElements();
        for (int i = 0; i < items.length; ++i) {
            this.m_model.addElement(items[i]);
        }
    }

    public Object[] getData() {
        return this.m_model.toArray();
    }

    public int dataSize() {
        return this.m_model.size();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.m_itemList = new JList();
        this.m_buttonAdd = new JButton();
        this.m_buttonRemove = new JButton();
        this.m_buttonEdit = new JButton();
        this.jSeparator1 = new JSeparator();
        this.m_buttonUp = new JButton();
        this.m_buttonDown = new JButton();
        this.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.m_itemList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.m_buttonAdd.setIcon(new ImageIcon(this.getClass().getResource("/icons/stock_insert-element.png")));
        this.m_buttonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SortedEditableList.this.buttonAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.m_buttonAdd, gridBagConstraints);
        this.m_buttonRemove.setIcon(new ImageIcon(this.getClass().getResource("/icons/stock_remove-element.png")));
        this.m_buttonRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SortedEditableList.this.buttonRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.m_buttonRemove, gridBagConstraints);
        this.m_buttonEdit.setIcon(new ImageIcon(this.getClass().getResource("/icons/stock_edit.png")));
        this.m_buttonEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SortedEditableList.this.buttonEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.m_buttonEdit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.m_buttonUp.setIcon(new ImageIcon(this.getClass().getResource("/icons/stock_up.png")));
        this.m_buttonUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SortedEditableList.this.buttonUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        this.add((Component)this.m_buttonUp, gridBagConstraints);
        this.m_buttonDown.setIcon(new ImageIcon(this.getClass().getResource("/icons/stock_down.png")));
        this.m_buttonDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SortedEditableList.this.buttonDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        this.add((Component)this.m_buttonDown, gridBagConstraints);
    }

    private void buttonDownActionPerformed(ActionEvent evt) {
        int max = this.m_model.size();
        int index = this.m_itemList.getSelectedIndex();
        if (index + 1 < max) {
            Object o = this.m_model.remove(index);
            this.m_model.add(index + 1, o);
            this.m_itemList.setSelectedIndex(index + 1);
        }
        this.modelChanged();
    }

    private void buttonUpActionPerformed(ActionEvent evt) {
        int index = this.m_itemList.getSelectedIndex();
        if (index > 0) {
            Object o = this.m_model.remove(index);
            this.m_model.add(index - 1, o);
            this.m_itemList.setSelectedIndex(index - 1);
        }
        this.modelChanged();
    }

    public void setEditableItems(boolean b) {
        this.m_editableItems = b;
        this.m_buttonEdit.setEnabled(b);
        this.m_buttonAdd.setEnabled(b);
        this.m_buttonRemove.setEnabled(b);
    }

    public boolean getEditableItems() {
        return this.m_editableItems;
    }

    private void buttonEditActionPerformed(ActionEvent evt) {
        Object o;
        Object n;
        int index = this.m_itemList.getSelectedIndex();
        if (index >= 0 && (n = this.m_editor.editItem(this, o = this.m_model.get(index))) != null) {
            this.m_model.removeElementAt(index);
            this.m_model.add(index, n);
            this.m_itemList.setSelectedIndex(index);
        }
        this.modelChanged();
    }

    private void buttonRemoveActionPerformed(ActionEvent evt) {
        Object[] items = this.m_itemList.getSelectedValues();
        for (int i = 0; i < items.length; ++i) {
            Object o = items[i];
            if (o == null || !this.m_editor.removeItem(this, o)) continue;
            this.m_model.removeElement(o);
        }
        this.modelChanged();
    }

    private void buttonAddActionPerformed(ActionEvent evt) {
        Object item = this.m_editor.createNewItem(this);
        if (item != null) {
            System.out.println("IsArray: " + item.getClass() + " == " + item.getClass().isArray());
            if (item.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(item); ++i) {
                    Object o = Array.get(item, i);
                    if (this.m_model.contains(o)) continue;
                    this.m_model.addElement(o);
                }
            } else if (!this.m_model.contains(item)) {
                this.m_model.addElement(item);
            }
            this.modelChanged();
        }
    }

    protected void modelChanged() {
    }

    public class StringEditor
    implements Editor {
        public Object createNewItem(SortedEditableList selist) {
            String result = JOptionPane.showInputDialog(selist, (Object)"Type a string");
            return result;
        }

        public Object editItem(SortedEditableList selist, Object item) {
            String result = JOptionPane.showInputDialog(selist, "Type a string", item.toString());
            return result;
        }

        public boolean removeItem(SortedEditableList selist, Object item) {
            return true;
        }
    }

    public static interface Editor {
        public Object createNewItem(SortedEditableList var1);

        public Object editItem(SortedEditableList var1, Object var2);

        public boolean removeItem(SortedEditableList var1, Object var2);
    }
}

