/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.drag.outline.x11;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Properties;
import org.flexdock.docking.drag.outline.x11.DataBuffer;
import org.flexdock.logging.Log;
import org.flexdock.util.ResourceManager;

public class Connection {
    public static final String LOCALHOST = "127.0.0.1";
    public static final String DISPLAY_VAR = "DISPLAY";
    private static final ConnectionInfo CONNECTION_INFO = Connection.getConnectionInfo();
    private static final boolean SERVER_AVAILABLE = Connection.isServerAvailable();
    private Socket socket;
    private DataInputStream dataIn;
    private OutputStream dataOut;

    public Connection() throws IOException {
        if (!SERVER_AVAILABLE) {
            throw new RuntimeException("X Server is unavailable.  Please check your xhost access control list to ensure localhost may connect.");
        }
        try {
            this.socket = new Socket(CONNECTION_INFO.host, 6000 + CONNECTION_INFO.display);
            this.dataIn = new DataInputStream(this.socket.getInputStream());
            this.dataOut = this.socket.getOutputStream();
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    public void close() {
        ResourceManager.close(this.dataOut);
        ResourceManager.close(this.dataIn);
        ResourceManager.close(this.socket);
    }

    public void sendRequest(DataBuffer req) throws IOException {
        this.sendRequest(req, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBuffer sendRequest(DataBuffer req, boolean readReply) throws IOException {
        if (req == null) {
            return null;
        }
        OutputStream outputStream = this.dataOut;
        synchronized (outputStream) {
            this.dataOut.write(req.getBytes());
            if (!readReply) {
                return null;
            }
            byte[] tmp = new byte[4096];
            int bytesRead = -1;
            DataInputStream dataInputStream = this.dataIn;
            synchronized (dataInputStream) {
                bytesRead = this.dataIn.read(tmp);
            }
            byte[] ret = new byte[bytesRead];
            System.arraycopy(tmp, 0, ret, 0, bytesRead);
            return new DataBuffer(ret);
        }
    }

    private static boolean isServerAvailable() {
        try {
            Process process = Runtime.getRuntime().exec("xhost +" + CONNECTION_INFO.host);
            process.waitFor();
            DataInputStream in = new DataInputStream(process.getInputStream());
            in.readFully(new byte[in.available()]);
            in.close();
            return true;
        }
        catch (Exception e) {
            Log.debug(e.getMessage(), e);
            return false;
        }
    }

    private static ConnectionInfo getConnectionInfo() {
        String displayInfo = Connection.getEnv().getProperty(DISPLAY_VAR);
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < displayInfo.length(); ++i) {
            char c = displayInfo.charAt(i);
            if (c == ':' || c == '.') {
                list.add(sb.toString());
                sb = new StringBuffer();
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            list.add(sb.toString());
        }
        while (list.size() < 3) {
            list.add("");
        }
        ConnectionInfo info = new ConnectionInfo();
        info.host = Connection.getHost(list.get(0));
        info.display = Connection.getInt(list.get(1));
        info.screen = Connection.getInt(list.get(2));
        return info;
    }

    private static int getInt(Object data) {
        try {
            return Integer.parseInt(data.toString());
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static String getHost(Object data) {
        if (data == null || data.toString().trim().length() == 0) {
            return LOCALHOST;
        }
        return data.toString().trim();
    }

    private static Properties getEnv() {
        try {
            Process proc = Runtime.getRuntime().exec("env");
            proc.waitFor();
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            Properties p = new Properties();
            while (br.ready()) {
                String data = br.readLine();
                int indx = data.indexOf(61);
                if (indx == -1) continue;
                String key = data.substring(0, indx);
                String value = data.substring(indx + 1, data.length());
                p.setProperty(key, value);
            }
            return p;
        }
        catch (Exception e) {
            Log.debug(e.getMessage(), e);
            return new Properties();
        }
    }

    private static class ConnectionInfo {
        private String host = "127.0.0.1";
        private int display;
        private int screen;

        private ConnectionInfo() {
        }
    }
}

