/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import mondrian.olap.Util;
import mondrian.rolap.RolapStar;
import mondrian.rolap.agg.AbstractQuerySpec;
import mondrian.rolap.agg.ColumnConstraint;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.sql.SqlQuery;

class SegmentArrayQuerySpec
extends AbstractQuerySpec {
    private final Segment[] segments;
    private final boolean isDistinct;

    SegmentArrayQuerySpec(Segment[] segments, boolean isDistinct) {
        super(segments[0].aggregation.getStar());
        this.segments = segments;
        this.isDistinct = isDistinct;
        Util.assertPrecondition(segments.length > 0, "segments.length > 0");
        for (int i = 0; i < segments.length; ++i) {
            Segment segment = segments[i];
            Util.assertPrecondition(segment.aggregation == segments[0].aggregation);
            int n = segment.axes.length;
            Util.assertTrue(n == segments[0].axes.length);
            for (int j = 0; j < segment.axes.length; ++j) {
                Util.assertTrue(segment.axes[j].getConstraints() == segments[0].axes[j].getConstraints());
            }
        }
    }

    public int getMeasureCount() {
        return this.segments.length;
    }

    public RolapStar.Measure getMeasure(int i) {
        return this.segments[i].measure;
    }

    public String getMeasureAlias(int i) {
        return "m" + Integer.toString(i);
    }

    public RolapStar.Column[] getColumns() {
        return this.segments[0].aggregation.getColumns();
    }

    public String getColumnAlias(int i) {
        return "c" + Integer.toString(i);
    }

    public ColumnConstraint[] getConstraints(int i) {
        return this.segments[0].axes[i].getConstraints();
    }

    public String generateSqlQuery() {
        SqlQuery sqlQuery = this.newSqlQuery();
        if (!sqlQuery.getDialect().allowsCountDistinct() && this.hasDistinct()) {
            this.distinctGenerateSQL(sqlQuery);
        } else {
            this.nonDistinctGenerateSQL(sqlQuery);
        }
        return sqlQuery.toString();
    }

    protected boolean hasDistinct() {
        return this.isDistinct;
    }

    protected void addMeasure(int i, SqlQuery sqlQuery) {
        RolapStar.Measure measure = this.getMeasure(i);
        Util.assertTrue(measure.getTable() == this.getStar().getFactTable());
        measure.getTable().addToFrom(sqlQuery, false, true);
        String exprInner = measure.getExpression(sqlQuery);
        String exprOuter = measure.getAggregator().getExpression(exprInner);
        sqlQuery.addSelect(exprOuter, this.getMeasureAlias(i));
    }

    protected boolean isAggregate() {
        return true;
    }

    protected void distinctGenerateSQL(SqlQuery outerSqlQuery) {
        int i;
        SqlQuery innerSqlQuery = this.newSqlQuery();
        innerSqlQuery.setDistinct(true);
        RolapStar.Column[] columns = this.getColumns();
        int arity = columns.length;
        for (i = 0; i < arity; ++i) {
            RolapStar.Column column = columns[i];
            RolapStar.Table table = column.getTable();
            if (table.isFunky()) continue;
            table.addToFrom(innerSqlQuery, false, true);
            String expr = column.getExpression(innerSqlQuery);
            ColumnConstraint[] constraints = this.getConstraints(i);
            if (constraints != null) {
                innerSqlQuery.addWhere(RolapStar.Column.createInExpr(expr, constraints, column.isNumeric()));
            }
            String alias = "d" + i;
            innerSqlQuery.addSelect(expr, alias);
            outerSqlQuery.addSelect(alias);
            outerSqlQuery.addGroupBy(alias);
        }
        int count = this.getMeasureCount();
        for (i = 0; i < count; ++i) {
            RolapStar.Measure measure = this.getMeasure(i);
            Util.assertTrue(measure.getTable() == this.getStar().getFactTable());
            measure.getTable().addToFrom(innerSqlQuery, false, true);
            String alias = this.getMeasureAlias(i);
            String expr = measure.getExpression(outerSqlQuery);
            innerSqlQuery.addSelect(expr, alias);
            outerSqlQuery.addSelect(measure.getAggregator().getNonDistinctAggregator().getExpression(alias));
        }
        outerSqlQuery.addFrom(innerSqlQuery, "dummyname", true);
    }
}

