/*
 * KeywordMap.java - Fast keyword->id map
 * Copyright (C) 1998, 1999 Slava Pestov
 * Copyright (C) 1999 Mike Dillon
 *
 * You may use and modify this package for any purpose. Redistribution is
 * permitted, in both source and binary form, provided that this notice
 * remains intact in all source distributions of this package.
 */

package org.syntax.jedit;

import org.syntax.jedit.tokenmarker.*;
import javax.swing.text.Segment;

/**
 * A <code>KeywordLookupIF</code> provides a mean to extends the number of
 * keywords for a CTokenMarker easily.
 *
 * @author Kees Kuip 
 * @version $Id: KeywordLookupIF.java 39 2004-02-14 14:13:42Z keeskuip $
 */
public interface KeywordLookupIF
{
	/**
	 * Looks up a key.
	 * @param text The text segment
	 * @param offset The offset of the substring within the text segment
	 * @param length The length of the substring
	 */
	public byte lookup(Segment text, int offset, int length);

}
