/*
 * ComboBoxSheetProperty.java
 *
 * Created on 16 febbraio 2005, 19.13
 */

package it.businesslogic.ireport.gui.sheet;

import it.businesslogic.ireport.ExpressionContext;
import javax.swing.*;

public class SeriesColorsSheetProperty extends SheetProperty {
    
    private SeriesColorsSheetPropertyComponent editor = null;

    public SeriesColorsSheetProperty(String key, String name) {
        super( key, name, SheetProperty.STRING, null);
    }
    
    public JComponent getEditor()
    {
        if (editor != null) return editor;
        editor = new SeriesColorsSheetPropertyComponent();
        editor.addActionListener( this );
        return editor;
    }
    
    public Object getEditorValue(JComponent component)
    {
        return editor.getListOfSeriesColor();
    }
    
    public void setEditorValue(JComponent component, Object str)
    {
        try {
            getEditor(); // In this way we are sure that editor is not null.
            editor.setListOfSeriesColor( (java.util.List)str);
            
        } catch (Exception ex) {}
    }
}