/*
 * ScrollableList.java
 *
 * Created on 8 ottobre 2004, 2.55
 */

package it.businesslogic.ireport.gui.listview;
import java.awt.*;
import javax.swing.*;

public class ScrollableList extends JList
{
   protected boolean trackWidth = true;
   protected boolean trackHeight = false;

   public ScrollableList()
   {
      super();
      setCellRenderer(
         new it.businesslogic.ireport.chart.gui.ChartCellRenderer());
   }
   
   public int getVisibleRowCount()
   {
      return 0;
   }
   
   public boolean 
      getScrollableTracksViewportWidth()
   {
      return trackWidth;
   }

   public void setScrollableTracksViewportWidth(
      boolean trackWidth)
   {
      this.trackWidth = trackWidth;
   }

   public boolean 
      getScrollableTracksViewportHeight()
   {
      return trackHeight;
   }

   public void setScrollableTracksViewportHeight(
      boolean trackHeight)
   {
      this.trackHeight = trackHeight;
   }
   
   public void setLayoutOrientation(
      int orientation)
   {
      super.setLayoutOrientation(orientation);
      if (orientation == VERTICAL)
      {
         setScrollableTracksViewportWidth(true);
         setScrollableTracksViewportHeight(false);
      }
      if (orientation == VERTICAL_WRAP)
      {
         setScrollableTracksViewportWidth(false);
         setScrollableTracksViewportHeight(true);
      }
      if (orientation == HORIZONTAL_WRAP)
      {
         setScrollableTracksViewportWidth(true);
         setScrollableTracksViewportHeight(false);
      }
      revalidate();
   }
}