/*
 * FormatCommandMoveToLeftMargin.java
 *
 * Created on 9 mei 2005, 21:36
 */

package it.businesslogic.ireport.gui.command;

import it.businesslogic.ireport.OperationType;
import it.businesslogic.ireport.ReportElement;
import java.awt.Point;
import java.util.Enumeration;

/**
 * Move all elements towards to the right margin over a distance depicted
 * by the distance of the element with the right most EDGE to the right margin
 * A distance left of the right margin is considered positive.
 * Right of the right margin is considered negative.
 */
public class FormatCommandMoveToRightMargin extends FormatCommand {
    {
        operationType = OperationType.MOVE_TO_RIGHT_MARGIN;
    }
    
    int deltaRight;
    
    public void preparation() {
        // Find the element width the right most edge
        ReportElement re = null;
        ReportElement rightMostRe = (ReportElement) this.getSelectedElements().firstElement();
        
        Enumeration enum2 = this.getSelectedElements().elements();
        while (enum2.hasMoreElements()) {
            re = (ReportElement) enum2.nextElement();
            if ( (re.getPosition().x + re.getWidth()) > (rightMostRe.getPosition().x + rightMostRe.getWidth()) ) {
                rightMostRe = re;
            }
        }
        
        deltaRight = jrf.getReport().getRightMargin() - rightMostRe.getPosition().x;
        
    }
    
    public void modify() {
        re.setPosition(new Point(re.getPosition().x + 10 + deltaRight,  re.getPosition().y));
    }
    
}
