/*
 * ToolbarConnectionPanel.java
 *
 *
 * A test to work out whether it is possible to create atoolbar weparate form the main form and
 * to include it in the mainform.
 * It speeds up the creation of the toolbar. In the mainform each modification took 20 seconds to be generated
 * Created on 7 mei 2005, 13:27
 */

package it.businesslogic.ireport.gui;
//import it.businesslogic.ireport.gui.event.*;
//import it.businesslogic.ireport.undo.*;
//import it.businesslogic.ireport.util.*;
import javax.swing.JToolBar;



/**
 *
 * @Author: Robert Lamping
 */
public class ToolbarConnectionPanel extends javax.swing.JPanel {
    
    private boolean updating = false;
    private MainFrame mf = null; // MainFrame.getMainInstance();;
    private StringBuffer outputBuffer;
    
    
    /** Creates new form ToolbarFormatPanel */
    // Pass the workspace to this toolbar
    public ToolbarConnectionPanel(MainFrame mf ) {
        this.mf = mf;
        initComponents();
    }
    
    public JToolBar getToolBar() {
        // Make toolbar available to e.g. MainFrame
        return jToolBarConnections;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jToolBarConnections = new javax.swing.JToolBar();
        jComboBoxConnections = new javax.swing.JComboBox();

        setLayout(new java.awt.BorderLayout());

        setName("ToolbarConnectionPanel");
        getAccessibleContext().setAccessibleName("ToolbarConnectionPanel");
        jComboBoxConnections.setMaximumSize(new java.awt.Dimension(250, 32767));
        jComboBoxConnections.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxConnectionsActionPerformed(evt);
            }
        });

        jToolBarConnections.add(jComboBoxConnections);
        jComboBoxConnections.getAccessibleContext().setAccessibleName("ToolbarConnections");

        add(jToolBarConnections, java.awt.BorderLayout.NORTH);
        jToolBarConnections.getAccessibleContext().setAccessibleName("ToolbarConnections");

    }// </editor-fold>//GEN-END:initComponents

    private void jComboBoxConnectionsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxConnectionsActionPerformed
        
        if (!updating && jComboBoxConnections.getSelectedItem() != null)
        {
            this.getMainFrame().getProperties().put("DefaultConnection",jComboBoxConnections.getSelectedItem());
            this.getMainFrame().saveiReportConfiguration();
        }
    }//GEN-LAST:event_jComboBoxConnectionsActionPerformed
                                                                        
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox jComboBoxConnections;
    private javax.swing.JToolBar jToolBarConnections;
    // End of variables declaration//GEN-END:variables
    
    public javax.swing.JComboBox getJComboBoxConnextions()
    {
        return jComboBoxConnections;
    }
    
    public synchronized void updateConnections()
    {
        this.updating = true;
        
        try {
            it.businesslogic.ireport.util.Misc.updateComboBox(jComboBoxConnections,getMainFrame().getConnections());
            if (getMainFrame().getProperties().get("DefaultConnection") != null )
                jComboBoxConnections.setSelectedItem( getMainFrame().getProperties().get("DefaultConnection"));
        } catch (Exception ex)
        {
            ex.printStackTrace();
        }
        this.updating = false;
    }
    
    private MainFrame getMainFrame() {
        return mf;
    }
    
    
    
    
}