/*
 * ProjectDialog.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 4 giugno 2003, 1.34
 */

package it.businesslogic.ireport.gui;
import it.businesslogic.ireport.util.*;
/**
 *
 * @author  Administrator
 */
public class ProjectDialog extends javax.swing.JDialog {
    
    /** Creates new form ProjectDialog */
    public ProjectDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        this.setSize(400, 260);           
        Misc.centerFrame(this);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
        private void initComponents() {//GEN-BEGIN:initComponents
                java.awt.GridBagConstraints gridBagConstraints;

                jPanel1 = new javax.swing.JPanel();
                jButtonSave = new javax.swing.JButton();
                jButtonCancel = new javax.swing.JButton();
                jPanel2 = new javax.swing.JPanel();
                jComboBoxConnection = new javax.swing.JComboBox();
                jLabel4 = new javax.swing.JLabel();
                jTextFieldOutputDir = new javax.swing.JTextField();
                jButton2 = new javax.swing.JButton();
                jLabel3 = new javax.swing.JLabel();
                jTextFieldSourcesDir = new javax.swing.JTextField();
                jButton1 = new javax.swing.JButton();
                jLabel2 = new javax.swing.JLabel();
                jTextFieldProjectName = new javax.swing.JTextField();
                jLabel1 = new javax.swing.JLabel();

                addWindowListener(new java.awt.event.WindowAdapter() {
                        public void windowClosing(java.awt.event.WindowEvent evt) {
                                closeDialog(evt);
                        }
                });

                jPanel1.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

                jButtonSave.setText("Save");
                jButtonSave.setMnemonic('s');
                jButtonSave.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonSaveActionPerformed(evt);
                        }
                });

                jPanel1.add(jButtonSave);

                jButtonCancel.setText("Cancel");
                jButtonCancel.setMnemonic('c');
                jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonCancelActionPerformed(evt);
                        }
                });

                jPanel1.add(jButtonCancel);

                getContentPane().add(jPanel1, java.awt.BorderLayout.SOUTH);

                jPanel2.setLayout(new java.awt.GridBagLayout());

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 7;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 5, 3);
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                jPanel2.add(jComboBoxConnection, gridBagConstraints);

                jLabel4.setText("Default connection");
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 6;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                jPanel2.add(jLabel4, gridBagConstraints);

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 5, 3);
                gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
                jPanel2.add(jTextFieldOutputDir, gridBagConstraints);

                jButton2.setText("Browse");
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 5;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 5, 3);
                gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
                jPanel2.add(jButton2, gridBagConstraints);

                jLabel3.setText("Output directory");
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 4;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                jPanel2.add(jLabel3, gridBagConstraints);

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 5, 3);
                gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
                jPanel2.add(jTextFieldSourcesDir, gridBagConstraints);

                jButton1.setText("Browse");
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 5, 3);
                gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
                jPanel2.add(jButton1, gridBagConstraints);

                jLabel2.setText("Sources directory");
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                jPanel2.add(jLabel2, gridBagConstraints);

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 5;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 5, 3);
                gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
                jPanel2.add(jTextFieldProjectName, gridBagConstraints);

                jLabel1.setText("Project name");
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                jPanel2.add(jLabel1, gridBagConstraints);

                getContentPane().add(jPanel2, java.awt.BorderLayout.CENTER);

                java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
                setBounds((screenSize.width-390)/2, (screenSize.height-260)/2, 390, 260);
        }//GEN-END:initComponents

    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed

        
        
        
        this.setDialogResult( javax.swing.JOptionPane.CANCEL_OPTION);
        setVisible(false);
        dispose();
    }//GEN-LAST:event_jButtonCancelActionPerformed

    private void jButtonSaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSaveActionPerformed
        
        /* TODO: Check user inputs */
        this.setProjectName( this.jTextFieldProjectName.getText());
        this.setSourcesDir( this.jTextFieldSourcesDir.getText());
        this.setOutputDir( this.jTextFieldOutputDir.getText());
        this.setConnection(this.jComboBoxConnection.getSelectedItem()+"");
        this.setDialogResult( javax.swing.JOptionPane.OK_OPTION);
        setVisible(false);
        dispose();
    }//GEN-LAST:event_jButtonSaveActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        this.setDialogResult( javax.swing.JOptionPane.CLOSED_OPTION);
        setVisible(false);
        dispose();
    }//GEN-LAST:event_closeDialog
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new ProjectDialog(new javax.swing.JFrame(), true).setVisible(true);
    }
    
    /** Getter for property connection.
     * @return Value of property connection.
     *
     */
    public java.lang.String getConnection() {
        return connection;
    }    
    
    /** Setter for property connection.
     * @param connection New value of property connection.
     *
     */
    public void setConnection(java.lang.String connection) {
        this.connection = connection;
    }
    
    /** Getter for property dialogResult.
     * @return Value of property dialogResult.
     *
     */
    public int getDialogResult() {
        return dialogResult;
    }
    
    /** Setter for property dialogResult.
     * @param dialogResult New value of property dialogResult.
     *
     */
    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }
    
    /** Getter for property outputDir.
     * @return Value of property outputDir.
     *
     */
    public java.lang.String getOutputDir() {
        return outputDir;
    }
    
    /** Setter for property outputDir.
     * @param outputDir New value of property outputDir.
     *
     */
    public void setOutputDir(java.lang.String outputDir) {
        this.outputDir = outputDir;
    }
    
    /** Getter for property projectName.
     * @return Value of property projectName.
     *
     */
    public java.lang.String getProjectName() {
        return projectName;
    }
    
    /** Setter for property projectName.
     * @param projectName New value of property projectName.
     *
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    
    /** Getter for property sourcesDir.
     * @return Value of property sourcesDir.
     *
     */
    public java.lang.String getSourcesDir() {
        return sourcesDir;
    }
    
    /** Setter for property sourcesDir.
     * @param sourcesDir New value of property sourcesDir.
     *
     */
    public void setSourcesDir(java.lang.String sourcesDir) {
        this.sourcesDir = sourcesDir;
    }
    
        // Variables declaration - do not modify//GEN-BEGIN:variables
        private javax.swing.JButton jButton1;
        private javax.swing.JButton jButton2;
        private javax.swing.JButton jButtonCancel;
        private javax.swing.JButton jButtonSave;
        private javax.swing.JComboBox jComboBoxConnection;
        private javax.swing.JLabel jLabel1;
        private javax.swing.JLabel jLabel2;
        private javax.swing.JLabel jLabel3;
        private javax.swing.JLabel jLabel4;
        private javax.swing.JPanel jPanel1;
        private javax.swing.JPanel jPanel2;
        private javax.swing.JTextField jTextFieldOutputDir;
        private javax.swing.JTextField jTextFieldProjectName;
        private javax.swing.JTextField jTextFieldSourcesDir;
        // End of variables declaration//GEN-END:variables

    private int dialogResult;    
    
    private String projectName;
    
    private String sourcesDir;
    
    private String outputDir;
    
    private String connection;
    
}
