/*
 * CSVQueryExecuter.java
 *
 * Created on August 3, 2006, 4:30 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package it.businesslogic.ireport.examples.queryexecuter;

import it.businesslogic.ireport.connection.JRCSVDataSource;
import java.io.StringReader;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRCsvDataSource;
import net.sf.jasperreports.engine.query.JRQueryExecuter;

/**
 *
 * @author gtoffoli
 */
public class CSVQueryExecuter implements JRQueryExecuter {
    
    String fileContent;
    
    /** Creates a new instance of CSVQueryExecuter */
    public CSVQueryExecuter(String fileContent) {
        this.fileContent = fileContent;
    }

    public JRDataSource createDatasource() throws JRException {
        
        JRCsvDataSource csvds = new JRCsvDataSource( new StringReader( fileContent ));
        //csvds.setRecordDelimiter("\n");
        //csvds.setFieldDelimiter(",");
        
        return csvds;
    }

    public void close() {
    }

    public boolean cancelQuery() throws JRException {
        return true;
    }    
}
