/*
 * ChartTitle.java
 *
 * Created on 8 luglio 2005, 17.36
 *
 * Can be used as ChartTitle and as ChartSubtitle
 */

package it.businesslogic.ireport.chart;

import it.businesslogic.ireport.*;

/**
 *
 * @author Administrator
 */
public class ChartTitle {
    
   private IReportFont font = null;
   
   private String titleExpression = "";
    
   private java.awt.Color color = java.awt.Color.BLACK;
   
   private String position = "Top";
   
   /** Creates a new instance of ChartTitle */
   public ChartTitle(String title) {
       
       this.titleExpression = title;
   }

    public IReportFont getFont() {
        return font;
    }

    public void setFont(IReportFont font) {
        this.font = font;
    }

    public String getTitleExpression() {
        return titleExpression;
    }

    public void setTitleExpression(String titleExpression) {
        this.titleExpression = titleExpression;
    }

    public java.awt.Color getColor() {
        return color;
    }

    public void setColor(java.awt.Color color) {
        this.color = color;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }
    
    public ChartTitle cloneMe() {
        
        ChartTitle ct = new ChartTitle(getTitleExpression());
        if (getFont() != null) ct.setFont( (IReportFont)getFont().clone() );
        if (getColor() != null) ct.setColor(  new java.awt.Color( getColor().getRGB() ));
        ct.setPosition( new String( getPosition()));
        ct.position = position;
        
        return ct;
    }
}
