/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.plaf.theme.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.flexdock.plaf.theme.TitlebarUI;
import org.flexdock.view.Button;
import org.flexdock.view.Titlebar;

public class MetalTitlebarUI
extends TitlebarUI {
    protected void paintBackground(Graphics g, Titlebar titlebar) {
        Rectangle paintArea = this.getPaintRect(titlebar);
        g.translate(paintArea.x, paintArea.y);
        g.setColor(this.getBackgroundColor(titlebar.isActive()));
        g.fillRect(0, 0, paintArea.width, paintArea.height);
        g.translate(-paintArea.x, -paintArea.y);
        Rectangle paintAreaer = this.getPainterRect(g, titlebar);
        g.translate(paintAreaer.x, paintAreaer.y);
        this.painter.paint(g, paintAreaer.width, paintAreaer.height, titlebar.isActive(), titlebar);
        g.translate(-paintAreaer.x, -paintAreaer.y);
    }

    protected Color getBackgroundColor(boolean active) {
        return active ? MetalLookAndFeel.getPrimaryControl() : MetalLookAndFeel.getControl();
    }

    protected int getPainterX(Graphics g, Titlebar titlebar) {
        int paintX = this.getTextLocation(this.getIconRect(titlebar));
        Rectangle2D rect = g.getFontMetrics(super.getFont()).getStringBounds(titlebar.getText(), g);
        paintX += (int)rect.getWidth();
        return paintX += 10;
    }

    protected int getPainterWidth(Graphics g, Titlebar titlebar) {
        int buttonWidth = 0;
        Component[] c = titlebar.getComponents();
        for (int i = 0; i < c.length; ++i) {
            if (!(c[i] instanceof Button)) continue;
            Button b = (Button)c[i];
            buttonWidth = b.getHeight();
            break;
        }
        int paintY = (this.getButtonMargin() + buttonWidth) * 2;
        return paintY += 5;
    }

    private Rectangle getPainterRect(Graphics g, Titlebar titlebar) {
        Rectangle painterRectangle = this.getPaintRect(titlebar);
        painterRectangle.x = this.getPainterX(g, titlebar);
        painterRectangle.width = titlebar.getWidth() - painterRectangle.x;
        painterRectangle.width -= this.getPainterWidth(g, titlebar);
        painterRectangle.y += 3;
        painterRectangle.height -= 6;
        return painterRectangle;
    }
}

