/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.defaults;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Map;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.DockingStrategy;
import org.flexdock.docking.RegionChecker;
import org.flexdock.docking.defaults.DefaultDockingPort;
import org.flexdock.docking.defaults.DockingSplitPane;
import org.flexdock.docking.drag.DragManager;
import org.flexdock.docking.drag.DragOperation;
import org.flexdock.docking.event.DockingEvent;
import org.flexdock.docking.floating.frames.DockingFrame;
import org.flexdock.docking.floating.frames.FloatingDockingPort;
import org.flexdock.docking.state.FloatManager;
import org.flexdock.event.Event;
import org.flexdock.event.EventManager;
import org.flexdock.util.DockingUtility;
import org.flexdock.util.RootWindow;
import org.flexdock.util.SwingUtility;

public class DefaultDockingStrategy
implements DockingStrategy,
DockingConstants {
    public static final String PREFERRED_PROPORTION = "DefaultDockingStrategy.PREFERRED_PROPORTION";

    public static Dockable getSibling(Dockable dockable) {
        if (dockable == null) {
            return null;
        }
        DockingPort port = dockable.getDockingPort();
        String startRegion = DefaultDockingStrategy.findRegion(dockable.getComponent());
        String region = DockingUtility.flipRegion(startRegion);
        Dockable sibling = DefaultDockingStrategy.findDockable(port, dockable.getComponent(), region, startRegion, 0);
        return sibling;
    }

    public static Dockable getSibling(Dockable dockable, String region) {
        if (dockable == null || !DockingManager.isValidDockingRegion(region) || "CENTER".equals(region)) {
            return null;
        }
        DockingPort port = dockable.getDockingPort();
        String startRegion = DefaultDockingStrategy.findRegion(dockable.getComponent());
        Dockable sibling = DefaultDockingStrategy.findDockable(port, dockable.getComponent(), region, startRegion, 0);
        return sibling;
    }

    private static Dockable findDockable(DockingPort port, Component self, String region, String startRegion, int loop) {
        if (port == null) {
            return null;
        }
        if (loop > 10) {
            return null;
        }
        Component docked = port.getDockedComponent();
        if (!(docked instanceof JSplitPane)) {
            DockingPort superPort = DockingManager.getDockingPort((Component)((Object)port));
            return DefaultDockingStrategy.findDockable(superPort, self, region, startRegion, loop + 1);
        }
        JSplitPane split = (JSplitPane)docked;
        Component sibling = port.getComponent(region);
        if (sibling == self) {
            if (!(self instanceof JSplitPane)) {
                DockingPort superPort = DockingManager.getDockingPort((Component)((Object)port));
                return DefaultDockingStrategy.findDockable(superPort, self, region, startRegion, loop + 1);
            }
            return null;
        }
        if (sibling instanceof JSplitPane) {
            DockingPort subPort = DockingManager.getDockingPort(sibling);
            Component other = port.getComponent(DockingUtility.flipRegion(region));
            String subRegion = DefaultDockingStrategy.findSubRegion((JSplitPane)sibling, other, region, startRegion);
            return DefaultDockingStrategy.findDockable(subPort, self, subRegion, startRegion, loop + 1);
        }
        if (sibling == null) {
            DockingPort superPort = DockingManager.getDockingPort((Component)((Object)port));
            self = port.getDockedComponent();
            return DefaultDockingStrategy.findDockable(superPort, self, region, startRegion, loop + 1);
        }
        return DockingManager.getDockable(sibling);
    }

    private static String findSubRegion(JSplitPane split, Component other, String targetRegion, String baseRegion) {
        boolean translated;
        String region = DockingUtility.translateRegionAxis(split, targetRegion);
        if (!(other instanceof JSplitPane)) {
            return region;
        }
        boolean bl = translated = !targetRegion.equals(region);
        if (translated && !DockingUtility.isAxisEquivalent(region, baseRegion)) {
            region = DockingUtility.flipRegion(region);
        }
        return region;
    }

    public static String findRegion(Component comp) {
        if (comp == null) {
            return null;
        }
        DockingPort port = DockingManager.getDockingPort(comp);
        Component docked = port.getDockedComponent();
        if (!(docked instanceof JSplitPane)) {
            DockingPort superPort = DockingManager.getDockingPort((Component)((Object)port));
            Component component = docked = superPort == null ? docked : superPort.getDockedComponent();
        }
        if (!(docked instanceof JSplitPane)) {
            return "CENTER";
        }
        JSplitPane split = (JSplitPane)docked;
        boolean horiz = split.getOrientation() == 1;
        Component left = split.getLeftComponent();
        if (left == port) {
            return horiz ? "WEST" : "NORTH";
        }
        return horiz ? "EAST" : "SOUTH";
    }

    public boolean dock(Dockable dockable, DockingPort port, String region) {
        return this.dock(dockable, port, region, null);
    }

    public boolean dock(Dockable dockable, DockingPort port, String region, DragOperation operation) {
        if (!this.isDockingPossible(dockable, port, region, operation)) {
            return false;
        }
        if (!this.dragThresholdElapsed(operation)) {
            return false;
        }
        DockingPort oldPort = dockable.getDockingPort();
        DockingResults results = this.dropComponent(dockable, port, region, operation);
        DockingPort newPort = results.dropTarget;
        int evtType = results.success ? 2 : 3;
        Map dragContext = DragManager.getDragContext(dockable);
        DockingEvent evt = new DockingEvent(dockable, oldPort, newPort, evtType, dragContext);
        evt.setRegion(region);
        evt.setOverWindow(operation == null ? true : operation.isOverWindow());
        Object[] evtTargets = new Object[]{oldPort, newPort, dockable};
        EventManager.dispatch((Event)evt, evtTargets);
        return results.success;
    }

    protected boolean dragThresholdElapsed(DragOperation token) {
        if (token == null || token.isPseudoDrag() || token.getStartTime() == -1L) {
            return true;
        }
        long elapsed = System.currentTimeMillis() - token.getStartTime();
        return elapsed > 200L;
    }

    protected boolean isDockingPossible(Dockable dockable, DockingPort port, String region, DragOperation token) {
        FloatingDockingPort floatingDockingPort;
        if (this.isFloatable(dockable, token)) {
            return true;
        }
        DockingPort oldPort = DockingManager.getDockingPort(dockable);
        if (oldPort instanceof FloatingDockingPort && oldPort == port && (floatingDockingPort = (FloatingDockingPort)oldPort).getDockableCount() == 1) {
            return false;
        }
        if (dockable == null || dockable.getComponent() == null || port == null) {
            return false;
        }
        if (!DockingManager.isValidDockingRegion(region)) {
            return false;
        }
        Dockable docked = DockingManager.getDockable(port.getDockedComponent());
        if (docked == null) {
            return true;
        }
        if (docked.getDockingProperties().isTerritoryBlocked(region).booleanValue()) {
            return false;
        }
        Container container = docked.getComponent().getParent();
        DockingPort grandparent = DockingManager.getDockingPort(container);
        if (grandparent == null) {
            return true;
        }
        Component currentlyInRegion = grandparent.getComponent(region);
        return currentlyInRegion != dockable.getComponent();
    }

    protected boolean isFloatable(Dockable dockable, DragOperation token) {
        if (dockable == null || dockable.getComponent() == null || token == null) {
            return false;
        }
        if (token.isPseudoDrag()) {
            return false;
        }
        return !token.isOverWindow();
    }

    protected DockingResults dropComponent(Dockable dockable, DockingPort target, String region, DragOperation token) {
        if (this.isFloatable(dockable, token)) {
            return this.floatComponent(dockable, target, token);
        }
        DockingResults results = new DockingResults(target, false);
        if ("UNKNOWN".equals(region) || target == null) {
            return results;
        }
        Component docked = target.getDockedComponent();
        Component dockableCmp = dockable.getComponent();
        if (dockableCmp != null && dockableCmp == docked) {
            return results;
        }
        Container contentPane = SwingUtility.getContentPane((Component)((Object)target));
        Point contentPaneLocation = token == null ? null : token.getCurrentMouse(contentPane);
        this.undock(dockable);
        if (contentPaneLocation != null && contentPane != null) {
            target = results.dropTarget = DockingUtility.findDockingPort(contentPane, contentPaneLocation);
        }
        results.success = target.dock(dockableCmp, region);
        SwingUtility.revalidate((Component)((Object)target));
        return results;
    }

    public boolean undock(Dockable dockable) {
        if (dockable == null) {
            return false;
        }
        Component dragSrc = dockable.getComponent();
        Container parent = dragSrc.getParent();
        RootWindow rootWin = RootWindow.getRootContainer(parent);
        if (parent == null) {
            return false;
        }
        boolean success = false;
        DockingPort dockingPort = DockingUtility.getParentDockingPort(dragSrc);
        Map dragContext = DragManager.getDragContext(dockable);
        DockingEvent dockingEvent = new DockingEvent(dockable, dockingPort, dockingPort, 5, dragContext);
        EventManager.dispatch(dockingEvent);
        if (dockingPort != null) {
            success = dockingPort.undock(dragSrc);
        } else {
            parent.remove(dragSrc);
            success = true;
        }
        if (rootWin != null) {
            SwingUtility.revalidate(rootWin.getContentPane());
        }
        if (success) {
            dockingEvent = new DockingEvent(dockable, dockingPort, dockingPort, 4, dragContext);
            Object[] evtTargets = new Object[]{dockingPort, dockable};
            EventManager.dispatch((Event)dockingEvent, evtTargets);
        }
        return success;
    }

    protected DockingResults floatComponent(Dockable dockable, DockingPort target, DragOperation token) {
        DockingResults results = new DockingResults(target, false);
        Point screenLoc = token.getCurrentMouse(true);
        SwingUtility.add(screenLoc, token.getMouseOffset());
        Rectangle screenBounds = dockable.getComponent().getBounds();
        screenBounds.setLocation(screenLoc);
        FloatManager mgr = DockingManager.getFloatManager();
        DockingFrame frame = mgr.floatDockable(dockable, dockable.getComponent(), screenBounds);
        results.dropTarget = frame.getDockingPort();
        results.success = true;
        return results;
    }

    public DockingPort createDockingPort(DockingPort base) {
        DockingPort port = this.createDockingPortImpl(base);
        if (port instanceof DefaultDockingPort && base instanceof DefaultDockingPort) {
            DefaultDockingPort newPort = (DefaultDockingPort)port;
            DefaultDockingPort ddp = (DefaultDockingPort)base;
            newPort.setBorderManager(ddp.getBorderManager());
            newPort.setTabsAsDragSource(ddp.isTabsAsDragSource());
            newPort.setRoot(false);
        }
        return port;
    }

    protected DockingPort createDockingPortImpl(DockingPort base) {
        return new DefaultDockingPort();
    }

    public JSplitPane createSplitPane(DockingPort base, String region) {
        JSplitPane split = this.createSplitPaneImpl(base, region);
        SwingUtility.putClientProperty(split, "region", region);
        boolean elderInTopLeft = !DockingUtility.isRegionTopLeft(region);
        boolean resizeWeight = elderInTopLeft;
        split.setResizeWeight((double)resizeWeight);
        int orientation = 1;
        if ("NORTH".equals(region) || "SOUTH".equals(region)) {
            orientation = 0;
        }
        split.setOrientation(orientation);
        split.setBorder(null);
        split.setDividerSize(3);
        if (!(split.getUI() instanceof BasicSplitPaneUI)) {
            return split;
        }
        BasicSplitPaneDivider divider = ((BasicSplitPaneUI)split.getUI()).getDivider();
        if (divider != null) {
            divider.setBorder(null);
        }
        return split;
    }

    protected JSplitPane createSplitPaneImpl(DockingPort base, String region) {
        return new DockingSplitPane(base, region);
    }

    public int getInitialDividerLocation(DockingPort port, JSplitPane splitPane) {
        if (port == null || splitPane == null) {
            return 0;
        }
        Container dockingPort = (Container)((Object)port);
        Insets in = dockingPort.getInsets();
        boolean vert = splitPane.getOrientation() == 0;
        int inset = vert ? in.top + in.bottom : in.left + in.right;
        int portSize = vert ? dockingPort.getHeight() : dockingPort.getWidth();
        portSize -= inset;
        double proportion = this.getDividerProportion(port, splitPane);
        if (proportion < 0.0 || proportion > 1.0) {
            proportion = 0.5;
        }
        return (int)((double)portSize * proportion);
    }

    public double getDividerProportion(DockingPort port, JSplitPane splitPane) {
        Dockable dockable;
        if (port == null || splitPane == null) {
            return DockingManager.getDefaultSiblingSize();
        }
        Component elder = this.getElderComponent(splitPane);
        if (elder == null) {
            return DockingManager.getDefaultSiblingSize();
        }
        Float prefProp = this.getPreferredProportion(splitPane, elder);
        if (prefProp != null) {
            return prefProp.doubleValue();
        }
        if (elder instanceof DockingSplitPane) {
            elder = ((DockingSplitPane)elder).getElderComponent();
        }
        if ((dockable = DockingManager.getDockable(elder)) != null) {
            RegionChecker rc = port.getDockingProperties().getRegionChecker();
            float prefSize = rc.getSiblingSize(dockable.getComponent(), this.getCreationRegion(splitPane));
            return this.isElderTopLeft(splitPane) ? (double)(1.0f - prefSize) : (double)prefSize;
        }
        return DockingManager.getDefaultSiblingSize();
    }

    protected String getCreationRegion(JSplitPane splitPane) {
        if (splitPane instanceof DockingSplitPane) {
            return ((DockingSplitPane)splitPane).getRegion();
        }
        return (String)SwingUtility.getClientProperty(splitPane, "region");
    }

    protected boolean isElderTopLeft(JSplitPane splitPane) {
        if (splitPane instanceof DockingSplitPane) {
            return ((DockingSplitPane)splitPane).isElderTopLeft();
        }
        String region = this.getCreationRegion(splitPane);
        return !DockingUtility.isRegionTopLeft(region);
    }

    protected Float getPreferredProportion(JSplitPane splitPane, Component controller) {
        Container controllerPort = controller.getParent();
        return DefaultDockingStrategy.getPreferredProportion(controllerPort);
    }

    protected Component getElderComponent(JSplitPane splitPane) {
        Component comp;
        if (splitPane instanceof DockingSplitPane) {
            return ((DockingSplitPane)splitPane).getElderComponent();
        }
        boolean inTopLeft = this.isElderTopLeft(splitPane);
        Component component = comp = inTopLeft ? splitPane.getLeftComponent() : splitPane.getRightComponent();
        if (comp instanceof DockingPort) {
            comp = ((DockingPort)((Object)comp)).getDockedComponent();
        }
        return comp;
    }

    protected static Float getPreferredProportion(Component c) {
        return c == null ? null : (Float)SwingUtility.getClientProperty(c, PREFERRED_PROPORTION);
    }

    protected static class DockingResults {
        public DockingPort dropTarget;
        public boolean success;

        public DockingResults(DockingPort port, boolean status) {
            this.dropTarget = port;
            this.success = status;
        }
    }
}

