/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Syntax;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.Resolver;

class SimpleResolver
implements Resolver {
    private final FunDef funDef;

    SimpleResolver(FunDef funDef) {
        this.funDef = funDef;
    }

    public FunDef getFunDef() {
        return this.funDef;
    }

    public String getName() {
        return this.funDef.getName();
    }

    public String getDescription() {
        return this.funDef.getDescription();
    }

    public Syntax getSyntax() {
        return this.funDef.getSyntax();
    }

    public String[] getReservedWords() {
        return FunUtil.emptyStringArray;
    }

    public FunDef resolve(Exp[] args, Validator validator, int[] conversionCount) {
        int[] parameterTypes = this.funDef.getParameterTypes();
        if (parameterTypes.length != args.length) {
            return null;
        }
        for (int i = 0; i < args.length; ++i) {
            if (validator.canConvert(args[i], parameterTypes[i], conversionCount)) continue;
            return null;
        }
        return this.funDef;
    }

    public boolean requiresExpression(int k) {
        int[] parameterTypes = this.funDef.getParameterTypes();
        return k >= parameterTypes.length || parameterTypes[k] != 8;
    }
}

