/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.ExpCacheDescriptor;
import mondrian.olap.FunCall;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.BuiltinFunTable;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.Type;

public abstract class RankFunDef
extends FunDefBase {
    public RankFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    protected Exp validateArg(Validator validator, FunCall call, int i, int type) {
        if (call.getArgCount() == 2 && i == 1) {
            Exp arg = call.getArgs()[1];
            RankedListExp rankedListExp = new RankedListExp(arg);
            if (MondrianProperties.instance().EnableExpCache.get()) {
                FunCall cacheCall = new FunCall("$Cache", Syntax.Internal, new Exp[]{rankedListExp});
                return validator.validate(cacheCall, false);
            }
            return validator.validate(rankedListExp, false);
        }
        return super.validateArg(validator, call, i, type);
    }

    static boolean equalTuple(Member[] tuple, Member[] m) {
        if (tuple.length != m.length) {
            return false;
        }
        for (int i = 0; i < tuple.length; ++i) {
            if (tuple[i].equals(m[i])) continue;
            return false;
        }
        return true;
    }

    static boolean tupleContainsNullMember(Member[] tuple) {
        for (int i = 0; i < tuple.length; ++i) {
            Member member = tuple[i];
            if (!member.isNull()) continue;
            return true;
        }
        return false;
    }

    public static MultiResolver createResolver() {
        return new MultiResolver("Rank", "Rank(<Tuple>, <Set> [, <Calc Expression>])", "Returns the one-based rank of a tuple in a set.", new String[]{"fitx", "fitxn", "fimx", "fimxn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                switch (args.length) {
                    case 2: {
                        return new Rank2FunDef(dummyFunDef);
                    }
                    case 3: {
                        return new Rank3FunDef(dummyFunDef);
                    }
                }
                throw Util.newInternal("invalid arg count " + args.length);
            }
        };
    }

    static class RankedList {
        Map map = new HashMap();

        /*
         * WARNING - void declaration
         */
        RankedList(List members) {
            for (int i = 0; i < members.size(); ++i) {
                void var4_4;
                Object key;
                Object o = members.get(i);
                if (o instanceof Member) {
                    key = o;
                } else if (o instanceof Member[]) {
                    key = Arrays.asList((Member[])o);
                } else {
                    throw Util.newInternal("bad member/tuple " + o);
                }
                Integer value = this.map.put(var4_4, new Integer(i));
                if (value == null) continue;
                this.map.put(var4_4, value);
            }
        }

        int indexOf(Member m) {
            return this.indexOf((Object)m);
        }

        int indexOf(Member[] tuple) {
            return this.indexOf(Arrays.asList(tuple));
        }

        private int indexOf(Object o) {
            Integer integer = (Integer)this.map.get(o);
            if (integer == null) {
                return -1;
            }
            return integer;
        }
    }

    private static class RankedListExp
    extends ExpBase {
        private final Exp listExp;

        public RankedListExp(Exp listExp) {
            this.listExp = listExp;
        }

        public Object clone() {
            return this;
        }

        public int getCategory() {
            return this.listExp.getCategory();
        }

        public Type getTypeX() {
            return this.listExp.getTypeX();
        }

        public Exp accept(Validator validator) {
            return this;
        }

        public boolean dependsOn(Dimension dimension) {
            return this.listExp.dependsOn(dimension);
        }

        public Object evaluate(Evaluator evaluator) {
            List members = (List)this.listExp.evaluate(evaluator);
            if (members == null) {
                return null;
            }
            return new RankedList(members);
        }
    }

    private static class SortResult {
        final boolean empty;
        final Object[] values;

        public SortResult(boolean empty, Object[] values) {
            this.empty = empty;
            this.values = values;
        }

        public void print(PrintWriter pw) {
            if (this.empty) {
                pw.println("SortResult: empty");
            } else {
                pw.println("SortResult {");
                for (int i = 0; i < this.values.length; ++i) {
                    if (i > 0) {
                        pw.println(",");
                    }
                    Object value = this.values[i];
                    pw.print(value);
                }
                pw.println("}");
            }
            pw.flush();
        }
    }

    private static class SortExp
    extends ExpBase {
        private final Exp listExp;
        private final Exp sortExp;

        public SortExp(Exp listExp, Exp sortExp) {
            this.listExp = listExp;
            this.sortExp = sortExp;
        }

        public Object clone() {
            return this;
        }

        public int getCategory() {
            throw new UnsupportedOperationException();
        }

        public Type getTypeX() {
            return new NumericType();
        }

        public Exp accept(Validator validator) {
            return this;
        }

        public boolean dependsOn(Dimension dimension) {
            if (this.listExp.dependsOn(dimension)) {
                return true;
            }
            if (this.listExp.getTypeX().usesDimension(dimension)) {
                return false;
            }
            return this.sortExp.dependsOn(dimension);
        }

        public Object evaluate(Evaluator evaluator) {
            Evaluator evaluator2 = evaluator.push();
            List members = (List)this.listExp.evaluate(evaluator2);
            if (members == null) {
                return new SortResult(true, null);
            }
            RuntimeException exception = null;
            Object[] values = new Object[members.size()];
            int j = 0;
            for (int i = 0; i < members.size(); ++i) {
                Object o = members.get(i);
                if (o instanceof Member) {
                    Member member = (Member)o;
                    evaluator2.setContext(member);
                } else {
                    evaluator2.setContext((Member[])o);
                }
                Object value = this.sortExp.evaluateScalar(evaluator2);
                if (value instanceof RuntimeException) {
                    if (exception != null) continue;
                    exception = (RuntimeException)value;
                    continue;
                }
                if (value == Util.nullValue) continue;
                values[j++] = value;
            }
            if (exception != null) {
                return exception;
            }
            if (j < members.size()) {
                Object[] oldValues = values;
                values = new Object[j];
                System.arraycopy(oldValues, 0, values, 0, j);
            }
            FunUtil.sortValuesDesc(values);
            return new SortResult(false, values);
        }
    }

    private static class Rank3FunDef
    extends RankFunDef {
        private ExpCacheDescriptor cacheDescriptor;
        private static final boolean debug = false;

        public Rank3FunDef(FunDef dummyFunDef) {
            super(dummyFunDef);
        }

        public Object evaluate(Evaluator evaluator, Exp[] args) {
            Object cachedResult;
            Member[] tuple = Rank3FunDef.getTupleOrMemberArg(evaluator, args, 0);
            if (tuple == null || Rank3FunDef.tupleContainsNullMember(tuple)) {
                return null;
            }
            Exp sortExp = args[2];
            Evaluator evaluator2 = evaluator.push(tuple);
            Object value = sortExp.evaluateScalar(evaluator2);
            if (value instanceof RuntimeException) {
                return value;
            }
            if (this.cacheDescriptor == null) {
                Exp listExp = args[1];
                BuiltinFunTable funTable = BuiltinFunTable.instance();
                SortExp sortedListExp = new SortExp(listExp, funTable.createValueFunCall(sortExp, Util.createSimpleValidator(funTable)));
                this.cacheDescriptor = new ExpCacheDescriptor(sortedListExp, evaluator);
            }
            if ((cachedResult = evaluator.getCachedResult(this.cacheDescriptor)) instanceof RuntimeException) {
                return (RuntimeException)cachedResult;
            }
            SortResult sortResult = (SortResult)cachedResult;
            if (sortResult.empty) {
                return Util.nullValue;
            }
            if (value == Util.nullValue) {
                return new Double(sortResult.values.length + 1);
            }
            int j = FunUtil.searchValuesDesc(sortResult.values, value);
            if (j < 0) {
                j = -(j + 1);
                return new Double(j + 1);
            }
            if (j <= sortResult.values.length) {
                while (j > 0 && sortResult.values[j - 1].equals(value)) {
                    --j;
                }
            }
            return new Double(j + 1);
        }
    }

    private static class Rank2FunDef
    extends RankFunDef {
        public Rank2FunDef(FunDef dummyFunDef) {
            super(dummyFunDef);
        }

        public Object evaluate(Evaluator evaluator, Exp[] args) {
            Exp arg = args[0];
            Object o = arg.evaluate(evaluator);
            if (o == null || o instanceof Member && ((Member)o).isNull() || o instanceof Member[] && Rank2FunDef.tupleContainsNullMember((Member[])o)) {
                return null;
            }
            RankedList rankedList = (RankedList)Rank2FunDef.getArg(evaluator, args, 1);
            if (rankedList == null) {
                return new Double(0.0);
            }
            if (o instanceof Member[]) {
                Member[] tuple = (Member[])o;
                if (Rank2FunDef.tupleContainsNullMember(tuple)) {
                    return null;
                }
                int i = rankedList.indexOf(tuple);
                return new Double(i + 1);
            }
            if (o instanceof Member) {
                Member member = (Member)o;
                if (member.isNull()) {
                    return null;
                }
                int i = rankedList.indexOf(member);
                return new Double(i + 1);
            }
            throw Util.newInternal("Expected tuple or member, got " + o);
        }
    }
}

