/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.Util;
import mondrian.olap.fun.BuiltinFunTable;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.FunkBase;

public abstract class LinReg
extends FunkBase {
    final Exp valueFunCall;

    protected static void debug(String type, String msg) {
    }

    protected LinReg() {
        BuiltinFunTable.instance();
        this.valueFunCall = BuiltinFunTable.createValueFunCall();
    }

    public abstract Object evaluate(Evaluator var1, Exp[] var2);

    protected Value accuracy(Evaluator evaluator, Exp[] args) {
        Value value = this.process(evaluator, args);
        if (value == null) {
            return null;
        }
        return LinReg.accuracy(value);
    }

    protected Value process(Evaluator evaluator, Exp[] args) {
        List members = (List)LinReg.getArg(evaluator, args, 0);
        LinReg.debug("LinReg.process", "members.size=" + members.size());
        ExpBase expY = (ExpBase)LinReg.getArgNoEval(args, 1);
        ExpBase expX = (ExpBase)LinReg.getArgNoEval(args, 2, this.valueFunCall);
        evaluator = evaluator.push();
        FunUtil.SetWrapper[] sws = LinReg.evaluateSet(evaluator, members, new ExpBase[]{expY, expX});
        FunUtil.SetWrapper swY = sws[0];
        FunUtil.SetWrapper swX = sws[1];
        if (swY.errorCount > 0) {
            LinReg.debug("LinReg.process", "ERROR error(s) count =" + swY.errorCount);
            return null;
        }
        if (swY.v.size() == 0) {
            return null;
        }
        return LinReg.linearReg(swX.v, swY.v);
    }

    public static Value accuracy(Value value) {
        double sumErrSquared = 0.0;
        double sumErr = 0.0;
        double sumSquaredY = 0.0;
        double sumY = 0.0;
        double sumSquaredYF = 0.0;
        double sumYF = 0.0;
        List yfs = LinReg.forecast(value);
        Iterator ity = value.ys.iterator();
        Iterator ityf = yfs.iterator();
        while (ity.hasNext()) {
            double y = (Double)ity.next();
            double yf = (Double)ityf.next();
            double error = yf - y;
            sumErr += error;
            sumErrSquared += error * error;
            sumY += y;
            sumSquaredY += y * y;
            sumYF = yf;
            sumSquaredYF = yf * yf;
        }
        int n = value.ys.size();
        if (n > 2) {
            double variance = sumErrSquared / (double)(n - 2);
            value.setVariance(variance);
        }
        double MSE = sumErr / (double)n;
        double MST = sumY / (double)n;
        double SSE = 0.0;
        double SST = 0.0;
        ity = value.ys.iterator();
        ityf = yfs.iterator();
        while (ity.hasNext()) {
            double y = (Double)ity.next();
            double yf = (Double)ityf.next();
            double error = yf - y;
            SSE += (error - MSE) * (error - MSE);
            SST += (y - MST) * (y - MST);
        }
        if (SST != 0.0) {
            double rSquared = 1.0 - SSE / SST;
            value.setRSquared(rSquared);
        }
        return value;
    }

    public static Value linearReg(List xlist, List ylist) {
        int size = ylist.size();
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXX = 0.0;
        double sumXY = 0.0;
        LinReg.debug("LinReg.linearReg", "ylist.size()=" + ylist.size());
        LinReg.debug("LinReg.linearReg", "xlist.size()=" + xlist.size());
        int n = 0;
        for (int i = 0; i < size; ++i) {
            Object yo = ylist.get(i);
            Object xo = xlist.get(i);
            if (yo == null || xo == null) continue;
            ++n;
            double y = (Double)yo;
            double x = (Double)xo;
            LinReg.debug("LinReg.linearReg", " " + i + " (" + x + "," + y + ")");
            sumX += x;
            sumY += y;
            sumXX += x * x;
            sumXY += x * y;
        }
        double xMean = sumX / (double)n;
        double yMean = sumY / (double)n;
        LinReg.debug("LinReg.linearReg", "yMean=" + yMean);
        LinReg.debug("LinReg.linearReg", "(n*sumXX - sumX*sumX)=" + ((double)n * sumXX - sumX * sumX));
        double slope = ((double)n * sumXY - sumX * sumY) / ((double)n * sumXX - sumX * sumX);
        double intercept = yMean - slope * xMean;
        Value value = new Value(intercept, slope, xlist, ylist);
        LinReg.debug("LinReg.linearReg", "value=" + value);
        return value;
    }

    public static List forecast(Value value) {
        ArrayList<Double> yfs = new ArrayList<Double>(value.xs.size());
        Iterator it = value.xs.iterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            double yf = value.intercept + value.slope * x;
            yfs.add(new Double(yf));
        }
        return yfs;
    }

    public static class Variance
    extends LinReg {
        public Object evaluate(Evaluator evaluator, Exp[] args) {
            Variance.debug("LinReg.Variance.evaluator", "TOP");
            Value value = this.accuracy(evaluator, args);
            if (value == null) {
                return Util.nullValue;
            }
            return new Double(value.getVariance());
        }
    }

    public static class R2
    extends LinReg {
        public Object evaluate(Evaluator evaluator, Exp[] args) {
            R2.debug("LinReg.R2.evaluator", "TOP");
            Value value = this.accuracy(evaluator, args);
            if (value == null) {
                return Util.nullValue;
            }
            return new Double(value.getRSquared());
        }
    }

    public static class Slope
    extends LinReg {
        public Object evaluate(Evaluator evaluator, Exp[] args) {
            Slope.debug("LinReg.Slope.evaluator", "TOP");
            Value value = this.process(evaluator, args);
            if (value == null) {
                return Util.nullValue;
            }
            return new Double(value.getSlope());
        }
    }

    public static class Point
    extends LinReg {
        public Object evaluate(Evaluator evaluator, Exp[] args) {
            double x = Point.getDoubleArg(evaluator, args, 0);
            Point.debug("LinReg.Point.evaluator", "x=" + x);
            Point.debug("LinReg.Point.evaluator", "args.length=" + args.length);
            Exp[] args2 = new Exp[args.length - 1];
            System.arraycopy(args, 1, args2, 0, args.length - 1);
            Point.debug("LinReg.Point.evaluator", "args2.length=" + args2.length);
            Value value = this.process(evaluator, args2);
            if (value == null) {
                return Util.nullValue;
            }
            double y = x * value.getSlope() + value.getIntercept();
            Point.debug("LinReg.Point.evaluator", "y=" + y);
            return new Double(y);
        }
    }

    public static class Intercept
    extends LinReg {
        public Object evaluate(Evaluator evaluator, Exp[] args) {
            Intercept.debug("LinReg.Intercept.evaluator", "TOP");
            Value value = this.process(evaluator, args);
            if (value == null) {
                return Util.nullValue;
            }
            Intercept.debug("LinReg.Intercept.evaluator", "BOTTOM: " + value.getIntercept());
            return new Double(value.getIntercept());
        }
    }

    static class Value {
        private List xs;
        private List ys;
        double intercept;
        double slope;
        double rSquared = Double.MAX_VALUE;
        double variance = Double.MAX_VALUE;

        Value(double intercept, double slope, List xs, List ys) {
            this.intercept = intercept;
            this.slope = slope;
            this.xs = xs;
            this.ys = ys;
        }

        public double getIntercept() {
            return this.intercept;
        }

        public double getSlope() {
            return this.slope;
        }

        public double getRSquared() {
            return this.rSquared;
        }

        public void setRSquared(double rSquared) {
            this.rSquared = rSquared;
        }

        public double getVariance() {
            return this.variance;
        }

        public void setVariance(double variance) {
            this.variance = variance;
        }

        public String toString() {
            return "LinReg.Value: slope of " + this.slope + " and an intercept of " + this.intercept + ". That is, y=" + this.intercept + (this.slope > 0.0 ? " +" : " ") + this.slope + " * x.";
        }
    }
}

