/*
 * JBGList.java
 *
 * Created on March 22, 2006, 4:27 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package it.businesslogic.ireport.gui.style;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

/**
 *
 * @author gtoffoli
 */
public class JBGList extends JList {
    
    private boolean showLibrary = true;
    /**
     * 109 x 106
     */
    public static Image backGround =  (new javax.swing.ImageIcon(JBGList.class.getResource("/it/businesslogic/ireport/icons/styles/library.png"))).getImage() ; 
    public static Image backGroundDocument =  (new javax.swing.ImageIcon(JBGList.class.getResource("/it/businesslogic/ireport/icons/styles/document.png"))).getImage() ; 
    /** Creates a new instance of JBGList */
    public JBGList() {
        super();
        this.setCellRenderer(new StyleCellRenderer());
        ((DefaultListCellRenderer)this.getCellRenderer()).setOpaque(false);
    }
    
    
    public void paint(Graphics g)
    {
        
        Rectangle r = this.getVisibleRect();
        g.setColor(Color.WHITE);
        g.fillRect((int)r.getX(), (int)r.getY(), (int)r.getWidth(),(int)r.getHeight());
        g.drawImage( (isShowLibrary()) ? backGround : backGroundDocument,  (int)r.getX()+(int)r.getWidth()-109,(int)r.getY()+(int)r.getHeight()-106,109,106,this);
        super.paint(g);
        
    }

    public boolean isShowLibrary() {
        return showLibrary;
    }

    public void setShowLibrary(boolean newShowLibrary) {
        if (showLibrary == newShowLibrary) return;
        this.showLibrary = newShowLibrary;
        this.repaint();
    }
    
}
