/*
 * JSQLTablesPane.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 21 maggio 2003, 19.03
 */

package it.businesslogic.ireport.gui;
import java.awt.*;
import java.awt.image.*;
import javax.swing.*;
/**
 *
 * @author  Administrator
 */
public class JSQLTablesPane extends javax.swing.JDesktopPane {
    
    boolean repainting = false;
    private Graphics2D offscreen = null;
    private BufferedImage offscreenImage = null;
    /** Creates a new instance of JSQLTablesPane */
    public JSQLTablesPane() {
        
        Dimension offscreenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        offscreenImage = new java.awt.image.BufferedImage(offscreenDimension.width, offscreenDimension.height, java.awt.image.BufferedImage.TYPE_4BYTE_ABGR_PRE);
        
        offscreen = GraphicsEnvironment.getLocalGraphicsEnvironment().createGraphics(offscreenImage);
        offscreen.setBackground(this.getBackground());
        offscreen.setColor(Color.BLACK);
        this.setDoubleBuffered(false);
        
    }
    
    public void paint(Graphics g)
    {
        if (repainting) return;
        repainting = true;
        //this.repaint();
        //super.paint(g);
        if (offscreen == null) return;
        offscreen.clearRect(0,0, this.getWidth(), this.getHeight());
        JInternalFrame[] frames = this.getAllFrames();
        // Draw a line between two fields...
        offscreen.drawLine( frames[0].getLocation().x+frames[0].getWidth()/2,
                    frames[0].getLocation().y+frames[0].getHeight()/2,
                    frames[1].getLocation().x+frames[1].getWidth()/2,
                    frames[1].getLocation().y+frames[1].getHeight()/2);
        
        super.paintChildren(offscreen);
        g.drawImage( offscreenImage,0,0,(ImageObserver)this);
        repainting = false;
    }
    
     public void repaint()
    {
        paint( this.getGraphics() );
    }
     /*
    public void repaint(int x,int y, int width, int height)
    {
        super.repain
        //paint(this.getGraphics() );
    }
      **/
}
