/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.awt.Color;
import java.util.Collection;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.xml.JRBaseFactory;
import net.sf.jasperreports.engine.xml.JRXmlConstants;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.xml.sax.Attributes;

public class JRChartFactory
extends JRBaseFactory {
    private static final String ATTRIBUTE_isShowLegend = "isShowLegend";
    private static final String ATTRIBUTE_evaluationTime = "evaluationTime";
    private static final String ATTRIBUTE_evaluationGroup = "evaluationGroup";
    private static final String ATTRIBUTE_hyperlinkType = "hyperlinkType";
    private static final String ATTRIBUTE_hyperlinkTarget = "hyperlinkTarget";
    private static final String ATTRIBUTE_bookmarkLevel = "bookmarkLevel";
    private static final String ATTRIBUTE_customizerClass = "customizerClass";

    public Object createObject(Attributes atts) {
        String chartCustomizerClass;
        String bookmarkLevelAttr;
        Byte hyperlinkTarget;
        String hyperlinkType;
        Byte evaluationTime;
        JRXmlLoader xmlLoader = (JRXmlLoader)this.digester.peek(this.digester.getCount() - 1);
        Collection groupEvaluatedCharts = xmlLoader.getGroupEvaluatedCharts();
        JRDesignChart chart = (JRDesignChart)this.digester.peek();
        String isShowLegend = atts.getValue(ATTRIBUTE_isShowLegend);
        if (isShowLegend != null && isShowLegend.length() > 0) {
            chart.setShowLegend(Boolean.valueOf(isShowLegend));
        }
        if ((evaluationTime = (Byte)JRXmlConstants.getEvaluationTimeMap().get(atts.getValue(ATTRIBUTE_evaluationTime))) != null) {
            chart.setEvaluationTime(evaluationTime);
        }
        if (chart.getEvaluationTime() == 5) {
            groupEvaluatedCharts.add(chart);
            String groupName = atts.getValue(ATTRIBUTE_evaluationGroup);
            if (groupName != null) {
                JRDesignGroup group = new JRDesignGroup();
                group.setName(groupName);
                chart.setEvaluationGroup(group);
            }
        }
        if ((hyperlinkType = atts.getValue(ATTRIBUTE_hyperlinkType)) != null) {
            chart.setLinkType(hyperlinkType);
        }
        if ((hyperlinkTarget = (Byte)JRXmlConstants.getHyperlinkTargetMap().get(atts.getValue(ATTRIBUTE_hyperlinkTarget))) != null) {
            chart.setHyperlinkTarget(hyperlinkTarget);
        }
        if ((bookmarkLevelAttr = atts.getValue(ATTRIBUTE_bookmarkLevel)) != null) {
            chart.setBookmarkLevel(Integer.parseInt(bookmarkLevelAttr));
        }
        if ((chartCustomizerClass = atts.getValue(ATTRIBUTE_customizerClass)) != null && chartCustomizerClass.length() > 0) {
            chart.setCustomizerClass(chartCustomizerClass);
        }
        return chart;
    }

    public static class JRChartSubtitleFactory
    extends JRBaseFactory {
        private static final String ATTRIBUTE_color = "color";

        public Object createObject(Attributes atts) {
            JRDesignChart chart = (JRDesignChart)this.digester.peek();
            Color color = JRXmlConstants.getColor(atts.getValue(ATTRIBUTE_color), Color.black);
            if (color != null) {
                chart.setSubtitleColor(color);
            }
            return chart;
        }
    }

    public static class JRChartTitleFactory
    extends JRBaseFactory {
        private static final String ATTRIBUTE_position = "position";
        private static final String ATTRIBUTE_color = "color";

        public Object createObject(Attributes atts) {
            Color color;
            JRDesignChart chart = (JRDesignChart)this.digester.peek();
            String position = atts.getValue(ATTRIBUTE_position);
            if (position != null && position.length() > 0) {
                chart.setTitlePosition((Byte)JRXmlConstants.getChartTitlePositionMap().get(position));
            }
            if ((color = JRXmlConstants.getColor(atts.getValue(ATTRIBUTE_color), Color.black)) != null) {
                chart.setTitleColor(color);
            }
            return chart;
        }
    }
}

